/***************************************************************************
                          knutrwvar.h  -  description
                             -------------------
    begin                : So rj 26 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTRWVAR_H
#define KNUTRWVAR_H

#include <kdialogbase.h>
#include <klineedit.h>
#include <klocale.h>
#include <kcombobox.h>
#include <qstring.h>
#include <qlayout.h>

#include "knutnet.h"

/**
 * Tato trida je graficke rozhrani pro zmenu RW promennych.
 *
 * @author Daniel Prynych
 * @short RW promenne
 * @version 0.1
*/
class KNutRWVar : public KDialogBase  {
  Q_OBJECT
  public: 
/**
 * Konstruktor - vytvori okno pro zmenu RW promene.
 *
 * @param uName Urcuje uzivatelske jmeno.
 * @param password Urcuje heslo.
 * @param upsNet Je odkaz na instanci tridy KNutNet.
 * @since  0.1
 **/
  KNutRWVar(QString uName, QString password, KNutNet* initUpsNet, QWidget* parent = 0, const char* name = 0, bool modal = TRUE);

/**
 * Destruktor
 *
 * @since  0.1
 **/
  ~KNutRWVar();


  
  private slots:

/**
 * @internal
 *
 * Nastavi hodnotu a zpusob vyberu hodnoty promenne.
 */
  void slotChangeVar(int item);

/**
 * @internal
 *
 * Nastavi hodnotu promenne na puvodni hodnotu.
 */
  virtual void slotDefault ();

/**
 * @internal
 *
 * Provede akci
 */
  virtual void slotOk();



/**
 * @internal
 *
 * Najde pozadovanou polozku v boxu.
 * Ve verzi qt > 3.0.0 neni potreba.
 */
int findItem(KComboBox *myBox ,QString text);
  

  signals:
/**
 * Signal je aktivovam pokud je zmenen udaj na kterekoliv strance.
 *
 * @param changeSetting Udava co bylo zmeneno.
 *
 * @since  0.1
 **/
  void signalChangeRWVars (QString varName);


    private:
    KNutNet* myUpsNet;
    KLineEdit *lineEditName;
    KLineEdit *lineEditPassword;
    KComboBox *rWVarBox;
    KComboBox *valueVarBox;
    KLineEdit *valueVarLine;
    QGridLayout *passLayout;
    bool upsValueType;

  };

#endif
