/***************************************************************************
                          knutprintupsvar.h  -  description
                             -------------------
    begin                : St cec 3 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTPRINTUPSVAR_H
#define KNUTPRINTUPSVAR_H

#include <qvariant.h>
#include <qlayout.h>
#include <qlabel.h>

//#include <kdialog.h>
#include <kdialogbase.h>
#include <kcombobox.h>
#include <kpushbutton.h>

#include "knutupsdata.h"
#include "knutnet.h"


struct lVars {
  struct lVars *nextVar;
  QLabel *myName;
  QLabel *myVar;
  };



/**
  *@author Daniel Prynych
  */

/**
 * Tato trida zajistuje zobrazeni vsech promenych,
 * ktere podporuje prislusny ovladac/driver/model (ovladac) NUTu
 * pro urcenou UPS-ku
 * @author Daniel Prynych
 * @short NUT show UPS vars
 * @version 0.2
*/
class KNutPrintUpsVar : public KDialogBase  {

    Q_OBJECT

public:
/**
 * Konstruktor - vytvori okno, nacte hodnoty promennych,
 * a vypise jmena a hodnoty promenych.
 * @param upsnet Je odkaz na instanci KNutNet - obsahuje hodnoty promennych systemu NUT,
 * pokud data o UPS-kach neexistuji vraci funkce upsOk vzdy false.
 *
 * since 0.2
 **/
  KNutPrintUpsVar(KNutNet* upsNet, QWidget* parent = 0, const char* name = 0, bool modal = true);

/**
 * @since  0.1
 **/
  ~KNutPrintUpsVar();


/**
 * Vrati zda se povedlo pripojit na server NUT-u a nacist udaje.
 *
 * @since  0.1
 **/
  bool upsOk (void);


/**
 * @static
 * Zobrazi jmeno chyby na zaklade jeho cisla.
 *
 * @since  0.1
 **/
  static void showError (int error);


protected:

/****** protected vars ************/
  int countVars;
  int countIComms;

  KNutNet* myUpsNet;

  KPushButton* reloadButton;

  QVBoxLayout* upsVarsLayout;
  QGridLayout* myGridROVars;
  QGridLayout* myGridRWVars;
  QGridLayout* myGridICVars;
  lVars* firstVar;

  bool upsConnectOk;

protected slots:
/**
 * @internal
 * Nacte a prepise hodnoty promenych
 *
 * @since  0.1
 **/
  void slotReloadVars (void);


};

#endif
