/***************************************************************************
                          knutprefdlg.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTPREFDLG_H
#define KNUTPREFDLG_H

#include <kdialogbase.h>
#include <kpushbutton.h>
#include <klistbox.h>
#include <klocale.h>
#include <kfontdialog.h>
#include <kcolorbtn.h>
#include <kcombobox.h>

#include <qwidget.h>
#include <qstrlist.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qfont.h>
#include <qlabel.h>

#include "knutnewupsdlg.h"
#include "knutupsdata.h"
#include "knutvardata.h"

#define CHANGE_COUNT_COLS 1
#define CHANGE_CUSTOM_BCOLOR 2
#define CHANGE_MBCOLOR 4
#define CHANGE_VOLTAGE 8
#define CHANGE_FREQUENCY 16
#define CHANGE_XFER 32

#define CHANGE_UPS_SETTING 64
#define CHANGE_MAIN_PANEL_SETTING 128
#define CHANGE_CUSTOM_MPANEL_BCOLOR 256
#define CHANGE_MPBCOLOR 512

#define CHANGE_ANALOG_FONT 1024
#define CHANGE_PANEL_FONT 2048

#define CHANGE_CUSTOM_APANEL_BCOLOR 4096
#define CHANGE_APBCOLOR 8192

#define CHANGE_CUSTOM_APANEL_OCOLOR 16384
#define CHANGE_APOCOLOR 32768


/**
  *@author Daniel Prynych
  */

/**
 * Tato trida je konfiguracni dialog.
 * @author Daniel Prynych
 * @short NUT get data
 * @version 0.4
 */
class KNutPrefDlg : public KDialogBase
{
  Q_OBJECT
  public:

  enum Page {
    mainSettingPage =0,
    upsSettingPage,
    panelSettingPage,
    fontSettingPage,
    analogSettingPage
    };

/**
 * Konstruktor vytvori konfiguracni dialog.
 *
 * @param upsData Je odkaz na instanci tridy KNutUpsData, ktera spravuje informace o UPS-kach.
 * @param analogData Je odkaz na na instanci tridy KNutVarData, ktera spravuje data o analogovych panelech.
 * @param settingData Je odkaz na strukturu ktera obsahuje hodnoty nastavovane v dialogu.
 * @param upsName Je jmeno aktivni UPS-ky.
 *
 * @since  0.4
 **/
  KNutPrefDlg(KNutUpsData* upsData, KNutVarData* analogData, SettingDataDef* settingData, QString upsName, QWidget* parent = 0, const char* name = 0, bool modal = TRUE);

/**
 * @since  0.2
 **/
  ~KNutPrefDlg();

  signals:

/**
 * Signal je aktivovam pokud je zmenen udaj na kterekoliv strance.
 *
 * @param changeSetting Udava, co bylo zmeneno.
 *
 * @since  0.1
 **/
  void signalChangeConfig (unsigned int changeSetting );



  private slots:

/**
 * @internal
 */
  virtual void slotDefault();

/**
 * @internal
 */
  virtual void slotApply();

/**
 * @internal
 */
  virtual void slotOk();

/**
 * @internal
 */
  void slotChangeSettingFont(int index);

/**
 * @internal
 */
  void slotEnableVoltage(bool enable);


/**
 * @internal
 */
  void slotEnableFrequency(bool enable);


/**
 * @internal
 */
  void slotUseCustomBColor(bool enable);

/**
 * @internal
 */
  void slotUseCustomBPanelColor(bool enable);

/**
 * @internal
 */
void slotUseCustomBAnalogColor(bool enable);


/**
 * @internal
 */
void slotUseCustomOAnalogColor(bool enable);

  
/**
 * @internal
 */
  void slotNewUps();

/**
 * @internal
 */
  void slotEditUps();

/**
 * @internal
 */
  void slotDeleteUps();

  
  private:

/**
 * @internal
 */
  void initSetting();

/**
 * @internal
 */
  void initUps();

/**
 * @internal
 */
  void initPanel();

/**
 * @internal
 */
  void initFonts();

/**
 * @internal
 */
  void initAnalog ();


// Soukrome promene
  QString activeUpsName;
  KListBox* ListBox2;
  KNutUpsData* myUpsData;
  KNutVarData* myAnalogData;
  KNutNewUpsDlg* newUpsDlg;

  bool checked; // nastaveno kdyz doslo k zmene v definici UPS
  bool checkedActiveUps; // nastaveno pokud doslo ke zmene na aktivni UPS

  QSpinBox *numberOfColumns;
  KColorButton *BGButton;
  QCheckBox *checkBoxCbc;
  QCheckBox *checkBoxAys;
  QCheckBox *xfer;
  QLabel *label3;
  

  QCheckBox *checkBoxOver;
  QCheckBox *checkBoxBL;
  QCheckBox *checkBoxRB;
  QCheckBox *checkBoxCal;
  QCheckBox *checkBoxMFRM;
  QCheckBox *checkBoxMFR;
  QCheckBox *checkBoxModel;
  QCheckBox *checkBoxSerial;
  QCheckBox *checkBoxFirm;
  QCheckBox *checkBoxRun;
  QCheckBox *checkBoxCbpc;
  KColorButton *BGPButton;
  QLabel *label4;

  QRadioButton *vRadioButton1;
  QRadioButton *vRadioButton2;
  QRadioButton *fRadioButton1;
  QRadioButton *fRadioButton2;

  QButtonGroup	*voltageGroup;
  QButtonGroup	*frequencyGroup;
  SettingDataDef* prefData;

  QCheckBox* customFont; // Uzivatelske Font (nepouzit systemove fonty)
  KComboBox *panelFonts;
  KFontChooser *fontWidget;

  QFont aPanelFont; // Analog panel font
  QFont mPanelFont; // Main panel font

  int settingFont; // ktery font nastavujeme


  QCheckBox* checkBoxCbac;
  QCheckBox* checkBoxCoac;
  KColorButton* BGAButton;
  KColorButton* AFingerButton;
  KColorButton* AOKButton;
  KColorButton* AWarnningButton;
  KColorButton* AErrorButton;
  KColorButton* AScaleButton;
  KColorButton* AFontButton;
  QLabel *label5;
  QLabel *label6;
  QLabel *label7;
  QLabel *label8;
  QLabel *label9;
  QLabel *label10;
  QLabel *label11;



};

#endif
