/***************************************************************************
                          knutnet.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTNET_H
#define KNUTNET_H

//#define UPSNET_NO_EXCEPTION

/**
  *@author Daniel Prynych
  */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h>

//#include <qmutex.h>



#define UPS_VAR_CHAR_LENGTH 20
#define UPS_VAR_NAME_LENGTH 90
#define UPS_COMM_NAME_LENGTH 90



#define KUPS_LOW_MEM 1   // nebyla pridelena pamet
#define KUPS_NULL_ADDRESS 2 // nebyla zadana adresa pocitace
#define KUPS_NO_SUCH_HOST 3 // nespravna adresa pocitace
#define KUPS_CANT_CONNECT  4 // Nemohu se spojit se serverem
#define KUPS_SOCKET_ERR  5 // Nejde vytvorit socket
#define KUPS_BIND_ERR  6 // Nejde provest bind
#define KUPS_CONNECT_ERR  7 // Nejde provest connect
#define KUPS_SENDTO_ERR  8 // Nejde provest sendto
#define KUPS_SEND_ERR  9 // Nejde provest sendto
#define KUPS_RECVFROM_ERR  10 // Nejde provest recvfrom
#define KUPS_RECV_ERR  11 // Nejde provest recvfrom
#define KUPS_SELECT_ERR  12 // Nejde provest select
#define KUPS_NO_DATA  13 // Nebyla zadana zadna data
#define KUPS_NO_BUFFER  14 // Nebyl zadan zadny buffer
#define KUPS_UNKNOWN_ANSWER  16 // Server neodpovedel spravne
#define KUPS_UNKNOWN_FORMAT  17 // Data nemaji spravnou strukturu
#define KUPS_NO_SERVER_DATA  18 // Melze precist data ze serveru (Sever neodpovida)
#define KUPS_NO_UPSNET_OK     19 // je nastaven UpsNetOk na false
#define KUPS_UNKNOWN_ERR 20 // neznama chyba - neznamy text za ERR
#define KUPS_COMM_NOT_FIND 21 //prikaz nebyl nalezen v seznamu promenych module
#define KUPS_VAR_NOT_FIND 22 // promena nebyla nalezena v seznamu promenych modulu
// bud nazev neexistuje nebo zadanne poradi je mimo rozsah


// tyto zpravy vraci server
#define KUPS_ACCESS_DENIED 128 // pristup odmitnut
#define KUPS_PASSWORD_REQUIRED 129 // pro akci je nutno zaslat heslo
#define KUPS_PASSWORD_INCORRECT 130 //  nespravane heslo
#define KUPS_UNKNOWN_UPS 131 // tato ups neni na zadane adrese
#define KUPS_ALREADY_LOGGED_IN 132  // prihlaseni LOGIN jiz bylo provedeno
#define KUPS_ALREADY_SET_PASSWORD 133 // heslo jiz bylo zadano
#define KUPS_DATA_STALE 134 // neni mozne ziskat z modulu nove data
#define KUPS_MISSING_ARGUMENT 135 // chyby argument
#define KUPS_UNKNOWN_TYPE 136  //neznamy typ promene
#define KUPS_UNKNOWN_COMMAND 137 //nezmamy prikaz pr: poslem treba "UPERNAME admin"

//tyto chyby se vztahuji k driveru pro danny typ UPS-ky
#define KUPS_NO_RESPONSE 192 // driver pro ups neodpovedel ve vymezenem case
#define KUPS_UNKNOWN_REPLY 193 // neznama odpoved
#define KUPS_NOT_IMPLEMENTED 194
#define KUPS_COMMAND_FAILED 195  // chybny prikaz
#define KUPS_VAR_UNKNOWN 196 // Promena neni driverem podporovana
#define KUPS_VAR_NOT_SUPPORTED 197 // neni mozno zislat data pro tuto promeno
//#define KUPS_UNKNOWN_COMMAND 198 //nezmamy prilaz pr: poslem treba "UPERNAME admin"
#define KUPS_UNKNOWN_INSTCMD 199  // neznamy okamzity prikaz
#define KUPS_CMD_NOT_SUPPORTED 200  // tento okamzity prikaz neni podporovan





#define SBUFFER_LEN 1024
#define RBUFFER_LEN 1024

#define ALL_VARS 0
#define RO_VARS 1
#define RW_VARS 2


  struct enumVal {
    struct enumVal *enumValNext;
    char *stringValue;
    bool selected;
    };

  struct upsRVar {
    char upsVarName[UPS_VAR_NAME_LENGTH+1];
    bool upsVarNa;
    bool upsVarActivate;
    bool upsVarType; // typ true(1) RO -  false (0) RW (muzeme menit)
    bool upsValueType;  // typ true(1) char  - false (0) enum (vyctova)
                        // ma vyznam jen pro RW promenne
    int  upsVarMax;        // udave max delku string promenne nebo pocet moznosto pro enum promennou
                        // ma vyznam jen pro RW promenne
    char upsValue[UPS_VAR_CHAR_LENGTH+1];
    };


  struct upsVars {
    struct upsVars *upsNext;
    char *upsVarName;
    bool upsVarNa;
    bool upsVarActivate;// zda je promena aktivni (ma se nacitat)
    bool upsVarType;    // typ true(1) RO -  false (0) RW (muzeme menit)
    bool upsValueType;  // typ true(1) char  - false (0) enum (vyctova)
                        // ma vyznam jen pro RW promenne
    int  upsVarMax;        // udave max delku string promenne nebo pocet moznosto pro enum promennou
                        // ma vyznam jen pro RW promenne
    unsigned long upsCharLength;
    char *upsValue;     // hodnota promene
    char *upsDescription;  // informace o promene
    struct enumItem *enumValues; // odkaz na seznam moznych vyctovych hodnot, ma vyznam jen kdyz je
                          // promena vyctoveho typu;
    };


   struct upsRIComm {
    char upsCommName[UPS_COMM_NAME_LENGTH+1];
    char upsDescription;
    };



  struct upsIComm {
    struct upsIComm *upsNext;
    char *upsCommName;
    char upsDescription;
    };

  struct enumItem {
    struct enumItem *itemNext;
    char *enumString;
    };  

/**
 * Tato trida zajistuje cteni dat ze serveru NUT.
 * @author Daniel Prynych
 * @short NUT get data
 * @version 0.4
*/
class KNutNet {
public:


/**
 * Konstruktor pouze nastavi zakladni promene a struktury, ale nenavazuje spojeni ani necte promene se serveru NUT.
 *
 * @param name Je jmeno ups-ky ve tvaru <jmeno@>pocitac
 * Pocitac muze byt zadan jako ip adresa nebo domenove jmeno pocitace
 * pr.: localhost  ups1@karel.domena.cz victron@194.212.25.55.
 * @param protocol Je kod protocolu tcp=true udp=false default je true.
 * @param port Je cislo portu na kterem nasloucha NUT server, default je 3493.
 *
 * @since  0.3
 **/
	KNutNet (char *name, bool protocol = false, unsigned short port = 3493);

/**
 * @since  0.1
 **/
	~KNutNet ();

/**
 * Vraci kod chyby, pokud k ni doslo.
 *
 * @since  0.1
 **/
	int getError ( void );

/**
 * Nacte vsechny promene UPS-ky a nastavi jejich typ (znakove/char, numericke/float a status)
 * nastavi priznak aktivity jen pro status.
 *
 * @param setTypeVars Povoluje nastavovat typ promenych na FLOAT.
 *
 * @since  0.4
 **/
  int getUpsVars ( void );

/**
 * Nacte hodnoty vsech promenych UPS-ky pokud je nastaven jejich priznak aktivity,
 * nebo je nastaven allVars na true.
 * Pozor po provedeni getUpsVars je priznak aktivity nastaven jen pro status.
 *
 * @param allVars Urcuje zda se prikaz tyka vsech promenych, nebo jen tech ktere
 * maji nastaven priznak aktivity na TRUE.
 *
 * @since  0.2
 **/
  int getUpsValues ( bool allVars = true );


/**
 * Nacte hodnoty jedne promene UPS-ky bez ohledu na jeji priznak aktivity,
 *
 * @param upsVarName Udava jmeno promene.
 *
 * @since  0.1
 **/
  int getUpsValue (char *upsVarName );

  
/**
 * Vrati pocet promenych UPS-ky. Pri chybe vraci -1.
 *
 * @param typVar Udava typ promene pro ktere zjistujeme pocet
 * muze se jednat o RO promenne nebo RW promene.
 *
 * @since  0.3
 **/
  int readNumberVars ( int typVar = 0 );

/**
 * Vrati pocet prikazu UPS-ky. Pri chybe vraci -1.
 *
 * @since  0.1
 **/
  int readNumberComms (void);

///**
// * Vrati odkaz na hodnotu promene pokud je typu char.
// * Pri chybe vrati 0L.
// *
// * @param seqNumber Udava poradove cislo promene, ta zacina VZDY cislem 1.
// *
// * @since  0.2
// **/
//  char *readStringVar ( int seqNumber );

/**
 * Vrati odkaz na hodnotu promene pokud je typu char.
 * Pri chybe vrati 0L.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.2
 **/
  char* readStringVar ( char *name);


/**
 * Vrati strukturu udavajici vsechny hodnoty pro prikaz.
 * Pri chybe vrati 0L
 *
 * @param seqNumber Udava cislo promene.
 * @param upsRIComm Je struktura.
 *
 * @since  0.1
 **/
int readIComm (int seqNumber, struct upsRIComm&);



///**
// * Vrati typ promene 0=RW 1=RO
// * Pri chybe vrati -1
// *
// * @param seqNumber udava poradove cislo promene, ta zacina VZDY cislem 1.
// *
// * @since  0.2
// **/
//  int readTypeVar ( int seqNumber );

///**
// * Vrati typ promene 0=RW 1=RO
// * Pri chybe vrati -1
// *
// * @param name udava jmeno promene
// *
// * @since  0.1
// **/
//  int readTypeVar ( char *name );

///**
// * Vrati odkaz na jmeno promene
// * Pri chybe vrati 0L
// *
// * @param seqNumber udava poradove cislo promene, ta zacina VZDY cislem 1.
// *
// * @since  0.1
// **/
//  char *readNameVar ( int seqNumber );


/**
 * Vrati strukturu obsahujici vsechny udaje promene.
 * Pri chybe vrati 0L.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.2
 **/
  int readVars (char *name, struct upsRVar& allVars );


/**
 * Vrati strukturu obsahujici vsechny udaje promene.
 * Pri chybe vrati 0L.
 *
 * @param seqNumber Udava poradove cislo promene, ta zacina VZDY cislem 1.
 * @param typVar Udava typ promene /RO/RW/ALL.
 *
 * @since  0.3
 **/
  int readVars (int seqNumber, struct upsRVar& allVars, int typVar = ALL_VARS);

/**
 * Nastavi priznak aktivity. Pri chybe vrati -1.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.1
 **/
  int setActivate ( char *name );

///**
// * Nastavi priznak aktivity
// * Pri chybe vrati -1
// *
// * @param seqNumber udava poradove cislo promene, ta zacina VZDY cislem 1.
// *
// * @since  0.1
// **/
//  int setActivate ( int seqNumber );

/**
 * Zrusi nastaveni priznaku aktivity. Pri chybe vrati -1.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.1
 **/
  int unSetActivate ( char *name );

///**
// * Zrusi nastaveni priznaku aktivity
// * Pri chybe vrati -1
// *
// * @param seqNumber udava poradove cislo promene, ta zacina VZDY cislem 1.
// *
// * @since  0.1
// **/
//  int unSetActivate ( int seqNumber );

/**
 * Zrusi nastaveni priznaku aktivity pro VSECHNY promene.
 * Pri chybe vrati -1.
 *
 * @since  0.1
 **/
  int unSetActivateAll ( void );

/**
 * Testuje zda existuje promena danneho jmena.
 * Vraci 1 pokud existuje 0 pokud neexistuje.
 * Pri chybe vrati -1.
 *
 * @param name Udava jmeno promene.
 *
 * @since  0.1
 **/
  int existName ( char *name );

/**
 * Nacte jednu z hodnot vyctove promenne.
 * Vraci odkaz na jednu z hodnot vyctove promenne udanou poradovym cislem hodnoty.
 *
 * @param name Udava nazev vyctove promenne.
 * @param valueNumber Udava poradove cislo hodnoty vyctove promenne.
 *
 * @since  0.1
 **/
  char* readEnumValueVar (char *name, int valueNumber);

/**
 * Provede okamzity prikaz.
 * Vraci 0 pokud provedeni skoncilo v poradku jinak kod chyby.
 *
 * @param command Udava nazev prikazu.
 * @param userName Udava uzivatelske jmeno.
 * @param password Udava heslo.
 *
 * @since  0.1
 **/
  int instantCommand (char *command, char *userName, char*password);



/**
 * Nastavi RW promenou.
 * Vraci 0 pokud provedeni skoncilo v poradku jinak kod chyby;
 *
 * @param variable Udava nazev promenne.
 * @param value Udava hodnotu.
 * @param userName Udava uzivatelske jmeno.
 * @param password Udava heslo.
 *
 * @since  0.1
 **/
  int setVariable (char *variable, char *value, char *userName, char*password);

                        
/**
 * Vraci kod stavu (statusu) UPS-ky
 * kody je mozne scitat napt OB+LB = 12
 * OFF = 1, UPS-ka je vypnuta
 * OL = 2, UPS-ka bezi na sit
 * OB = 4 UPS-ka bezi na baterie
 * LB = 8 baterie je vybyta (pokud je zaroven OB dojde k shutdownu)
 * CAL = je spustena kalibrace UPS-ky
 * OVER	=128 UPS-ka je pretizena
 * RB = 256 UPS-ka pozaduje vymenu baterie
 * Pri chybe vrati -1
 *
 * @since  0.1
 **/
  int readStatus(void);



private:
  char  *upsName , *upsAddress , *upsIpAddress ;
  bool upsNetOk; // je nastaveno na FALSE pri chybe v konstruktoru nebo pri otevirani socketu
                 // nebo pri nedostatku pameti
  int upsErr;    // kod chyby
  unsigned short upsPort;
  struct sockaddr_in upsAddr;
  bool upsProtocol; // typ protokolu pro komunikaci

  struct upsVars *upsFirstName;
  struct upsIComm *commFirstName;

  int upsStatusVar;

  int numberVars; // pocet vsech promennych
  int numberRWVars;
  int numberIComms;

 // QMutex je v QT az od verze 3.x.x pro to ho zatim nepouzijeme
 // QMutex netMutex; // mutex pro synchronizaci cteni hodnot promenych;
  bool netMutex;
  
// konstanty
  static const int ups_get_timeout = 2; // doba cekani na navrat paketu
  static const int ups_get_timeout2 = 1; // doba cekani na navrat paketu pro druhy test - jen UDP


// interni funkce
/**
 * @internal
 * Otevre spojeni
 */
  int openUpsDate (void);

/**
 * @internal
 * Zavre otevrene spojeni
 */
  int closeUpsDate(int soc_addr);

/**
 * @internal
 */
  int getUpsData (int soc_addr,char *sbuffer, int sbuffer_len, char *rbuffer, int rbuffer_len, char* endString = 0L);


/**
 * @internal
 */
  int getValue   (int soc_addr, struct upsVars *uk_vars);



  
/**
 * @internal
 * Odstrani z konce retezce znaky CR/LF.
 */
  void correctBuffer (char *buffer);

/**
 * Urcuje zda string konci na zadany token.
 * @internal
 */
  bool ifEnd (char *token, char *string);


/**
 * @internal
 * Prevede text chyby na jeji kod.
 *
 * @param string Je text chyby.
 */
  int upsTranslateError (char *string);


/**
 * @internal
 * Prevede text chyby na jeji kod.
 * Jde o kodovani v hodnote promene ktere pouziva jen stara verze
 * upsd. Je zahrnuto pro moznost pouziti na stare verzi.
 *
 * @param string Je text chyby.
 */
  int upsOldTranslateError (char *string);


/**
 * @internal
 */
  void upsSetType (struct upsVars *uVars);

/**
 * @internal
 * Smaze vsechny UPS promenne.
 */
  void deleteVars (void);

/**
 * @internal
 */
  void genStatusFlags (struct upsVars *uVars);

/**
 * @internal
 * @param string Ukazatel na jmeno promene.
 * @param valueType Udava typ hodnoty 1=string 0=enum (vyctovy typ).
 * @param varMax Udava maximalni delku stringu nebo pocet variant pro typ hodnoty enum.
 */
  void setRWVars (char *string, bool valueType, int varMax, struct enumItem *enumValues);

/**
 * Rozhodi radku na slova.
 * Slova jsou oddeleny mezerami, druhe slovo muze byt uzavreno mezi uvozovkamy.
 * Neni pridelena nova pamet, jsou provedeny zmeny v pameti na kterou jiz ukazuje line.
 * @internal
 * @param line Odkaz na radku ( vstupni data).
 * @param word1 Prvni slovo ( vystupni data).
 * @param word2 Druhe slovo ( vystupni data).
 */
  void findWords(char *line, char*& word1, char*& word2, char*& word3);

  int sendComm (int socAddr, char *command, char *arg1, char *arg2, char *inBuffer, int inBufferLen, char *outBuffer, int outBufferLen, bool useUpsName=false );

  
};

#endif
