/***************************************************************************
                          knutfrontpanel.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "knutfrontpanel.h"

#include <klocale.h>
#include <kapp.h>
#include <qtooltip.h>
#include <qstring.h>


#include <qpaintdevice.h>
//#include <iostream>


KNutFrontPanel::KNutFrontPanel( QPalette* paletteIn, QWidget *parent, unsigned int flags, QFont *panelFonts, const char *name, int width ) : QFrame( parent, name ), panelFlags(flags), panelWidth(width), myPalette(paletteIn) {
  upsOk = green;
  upsError = red;
  upsBack = white; //backgroundColor();
  textWidth=panelWidth-18;


  setMinimumWidth( width );
  setMaximumWidth( width );
  setFrameStyle( QFrame::Box | QFrame::Raised );
  setLineWidth( 2 );

  if (panelFonts == 0) {
    panelFont =kapp->font(); // nastavime font sytemovy font
    panelBoldFont = kapp->font();
    }
  else {
    panelFont = *panelFonts; // nastavime font
    panelBoldFont = *panelFonts; // pozdeji zmenime
    }
  panelBoldFont.setBold (TRUE);
  panelFont.setBold (FALSE); // Zrusime bold u panelu

  QBrush myBrush= myPalette->brush(QPalette::Active,QColorGroup::Background);

  QPalette Ppalette = palette();
  QBrush Pbrush = Ppalette.brush(QPalette::Active,QColorGroup::Background);
   
  textLabel1 = new QLabel( i18n("UPS On line"),this);
  frameOL = new  QFrame (this);
  frameOL->setBackgroundColor(upsBack);
  frameOL->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  QToolTip::add(textLabel1,textLabel1->text());

  textLabel2 = new QLabel( i18n("UPS On battery"), this);
  frameOB = new  QFrame (this);
  frameOB->setBackgroundColor(upsBack);
  frameOB->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  QToolTip::add(textLabel2,textLabel2->text());

  textLabel3 = new QLabel( i18n("UPS Overload"), this);
  frameOVER = new  QFrame (this);
  frameOVER->setBackgroundColor(upsBack);
  frameOVER->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  QToolTip::add(textLabel3,textLabel3->text());

  textLabel4 = new QLabel( i18n("UPS Battery low"), this);
  frameLB = new  QFrame (this);
  frameLB->setBackgroundColor(upsBack);
  frameLB->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  QToolTip::add(textLabel4,textLabel4->text());

  textLabel5 = new QLabel( i18n("Replace battery"), this);
  frameRB = new  QFrame (this);
  frameRB->setBackgroundColor(upsBack);
  frameRB->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  QToolTip::add(textLabel5,textLabel5->text());

  textLabel6 = new QLabel( i18n("UPS calibration"), this);
  frameCAL = new  QFrame (this);
  frameCAL->setBackgroundColor(upsBack);
  frameCAL->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  QToolTip::add(textLabel6,textLabel6->text());

  textLabelManufac = new QLabel( i18n("Manufac. : "), this);
  QToolTip::add(textLabelManufac,textLabelManufac->text());

  textLabelName = new QLabel( i18n("Name : "), this);
  QToolTip::add(textLabelName,textLabelName->text());

  textLabelSerial = new QLabel( i18n("Serial : "), this);
  QToolTip::add(textLabelSerial,textLabelSerial->text());

  textLabelFirm = new QLabel( i18n("Firm. rev. : "), this);
  QToolTip::add(textLabelFirm,textLabelFirm->text());

  textLabelRun = new QLabel( i18n("Runtime : "), this);
  QToolTip::add(textLabelRun,textLabelRun->text());

  textLabel7 = new QLabel( "", this);
  QToolTip::add(textLabel7,textLabel7->text());

  textLabel8 = new QLabel( "", this);
  textLabel9 = new QLabel( "", this);
  textLabel10 = new QLabel( "", this);
  textLabel11 = new QLabel( "", this);

// nastavime LCD panel pro RUNTIME
  LCDNumber1 = new QLCDNumber (3,this);
  LCDNumber1->setSegmentStyle (QLCDNumber::Flat);
  LCDNumber1->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  LCDPaletteOk = palette();
  LCDPaletteErr = palette();
//Nastavime barvu pro OK system je online
  QColorGroup activeColorGroup = LCDPaletteOk.active();
  activeColorGroup.setColor( QColorGroup::Foreground, green);
  LCDPaletteOk.setActive(activeColorGroup);
  LCDPaletteOk.setInactive(activeColorGroup);
//Nastvime Barvu pro Error - System neni online
  activeColorGroup = LCDPaletteErr.active();
  activeColorGroup.setColor( QColorGroup::Foreground, red);
  LCDPaletteErr.setActive(activeColorGroup);
  LCDPaletteErr.setInactive(activeColorGroup);

  LCDNumber1->setPalette (LCDPaletteOk);
  changePanelFont();
  paintPanel ();
  }

KNutFrontPanel::~KNutFrontPanel(){
  }



//************************************************************

void KNutFrontPanel::paintPanel( void ) {

  rowY = PANEL_TEXT_TOP;
  if (panelFlags & PB_ON_LINE) {
    textLabel1->setGeometry( QRect( 10, rowY, panelWidth-50, 20 ));
    frameOL->setGeometry( QRect( panelWidth-40, rowY, 30, 20 ));
    textLabel1->show();
    frameOL->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel1->hide();
    frameOL->hide();
    }

  if (panelFlags & PB_ON_BATT) {
    textLabel2->setGeometry( QRect( 10, rowY, panelWidth-50, 20 ) );
    frameOB->setGeometry( QRect( panelWidth-40, rowY, 30, 20 ) );
    textLabel2->show();
    frameOB->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel2->hide();
    frameOB->hide();
    }

  if (panelFlags & PB_OVER) {
    textLabel3->setGeometry( QRect( 10, rowY, panelWidth-50, 20 ) );
    frameOVER->setGeometry( QRect( panelWidth-40, rowY, 30, 20 ) );
    textLabel3->show();
    frameOVER->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel3->hide();
    frameOVER->hide();
    }

  if (panelFlags & PB_BATT_LOW) {
    textLabel4->setGeometry( QRect( 10, rowY, panelWidth-50, 20 ) );
    frameLB->setGeometry( QRect( panelWidth-40, rowY, 30, 20 ) );
    textLabel4->show();
    frameLB->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel4->hide();
    frameLB->hide();
    }

  if (panelFlags & PB_REP_BATT) {
    textLabel5->setGeometry( QRect( 10, rowY, panelWidth-50, 20 ) );
    frameRB->setGeometry( QRect( panelWidth-40, rowY, 30, 20 ) );
    textLabel5->show();
    frameRB->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel5->hide();
    frameRB->hide();
    }

  if (panelFlags & PB_CAL) {
    textLabel6->setGeometry( QRect( 10, rowY, panelWidth-50, 20 ) );
    frameCAL->setGeometry( QRect( panelWidth-40, rowY, 30, 20 ) );
    textLabel6->show();
    frameCAL->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel6->hide();
    frameCAL->hide();
    }

  if (panelFlags & PB_MFR_MOD) {
    textLabel7->setGeometry( QRect( 10, rowY, panelWidth-18, 20 ) ); //FRM + NAME
    textLabel7->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else textLabel7->hide();


  if (panelFlags & PB_MFR) {
    textLabelManufac->setGeometry( QRect( 10, rowY, mfrWidth, 20 ) ); //FRM
    textLabel8->setGeometry( QRect( 10+mfrWidth, rowY, textWidth-mfrWidth, 20 ) ); //FRM
    textLabel8->show();
    textLabelManufac->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel8->hide();
    textLabelManufac->hide();
    }

  if (panelFlags & PB_MODEL) {
    textLabelName->setGeometry( QRect( 10, rowY, textWidth, 20 ) );  //Name
    textLabel9->setGeometry( QRect( nameWidth+10, rowY, textWidth-nameWidth, 20 ) );  //Name
    textLabel9->show();
    textLabelName->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel9->hide();
    textLabelName->hide();
    }

  if (panelFlags & PB_SERIAL) {
    textLabelSerial->setGeometry( QRect( 10, rowY, serialWidth, 20 ) ); //Serial
    textLabel10->setGeometry( QRect( serialWidth+10, rowY, textWidth-serialWidth, 20 ) ); //Serial
    textLabel10->show();
    textLabelSerial->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel10->hide();
    textLabelSerial->hide();
    }

  if (panelFlags & PB_FIRM) {
    textLabelFirm->setGeometry( QRect( 10, rowY, firmWidth, 20 ) ); //Firmware Revision
    textLabel11->setGeometry( QRect( firmWidth+10, rowY, textWidth-firmWidth, 20 ) ); //Firmware Revision
    textLabel11->show();
    textLabelFirm->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    textLabel11->hide();
    textLabelFirm->hide();
    }

  if (panelFlags & PB_RUN) {
    textLabelRun->setGeometry( QRect( 10, rowY, runWidth, 20 ) ); //RUNTIME
    LCDNumber1->setGeometry( QRect( panelWidth-40, rowY, 30, 20 ) ); //RUNTIME
    LCDNumber1->setBackgroundColor(upsBack);
    LCDNumber1->show();
    textLabelRun->show();
    rowY += PANEL_TEXT_HIGH;
    }
  else {
    LCDNumber1->hide();
    textLabelRun->hide();
    }

  // Prepocteme a prenastavime velikost
  panelHeight = rowY + PANEL_TEXT_BOTTOM;
  setMinimumHeight( panelHeight );
  setMaximumHeight( panelHeight );
  }


int KNutFrontPanel::getPanelHeight( void) { return panelHeight; }

unsigned int KNutFrontPanel::getPanelFlags( void) { return panelFlags; }

void KNutFrontPanel::setPanelFlags( int upsPanelFlags) { panelFlags = upsPanelFlags; }

void KNutFrontPanel::setAllNameUps(QString panelUpsAllName ){
  textLabel7->setText(panelUpsAllName);
  QToolTip::remove(textLabel7);
  QToolTip::add(textLabel7,panelUpsAllName);
  }

void KNutFrontPanel::setMFRUps(QString panelUpsFRM ){
  textLabel8->setText(panelUpsFRM);
  QToolTip::remove(textLabelManufac);
  QToolTip::add(textLabelManufac,textLabelManufac->text()+panelUpsFRM);
  }

void KNutFrontPanel::setNameUps(QString panelUpsName ){
  textLabel9->setText(panelUpsName);
  QToolTip::remove(textLabelName);
  QToolTip::add(textLabelName,textLabelName->text()+panelUpsName);
  }

void KNutFrontPanel::setSerialUps(QString panelUpsSerial ){
  textLabel10->setText(panelUpsSerial);
  QToolTip::remove(textLabelSerial);
  QToolTip::add(textLabelSerial,textLabelSerial->text()+panelUpsSerial);
  }

void KNutFrontPanel::setFirmRevUps(QString upsPanelFormRev ){
  textLabel11->setText(upsPanelFormRev);
  QToolTip::remove(textLabelFirm);
  QToolTip::add(textLabelFirm,textLabelFirm->text()+upsPanelFormRev);
  }


void KNutFrontPanel::cleanPanel(void) {
  textLabel7->setText("");
  textLabel8->setText("");
  textLabel9->setText("");
  textLabel10->setText("");
  textLabel11->setText("");

  frameOL->setBackgroundColor(upsBack);
  frameOB->setBackgroundColor(upsBack);
  frameOVER->setBackgroundColor(upsBack);
  frameLB->setBackgroundColor(upsBack);
  frameRB->setBackgroundColor(upsBack);
  frameCAL->setBackgroundColor(upsBack);
  }

void KNutFrontPanel::setRuntime(int runtime) {
  LCDNumber1->display(runtime);
  }


void KNutFrontPanel::setPanel(int panelBulbs) {
//  OFF			- 1 ups je vypnuta
//  OL			- 2 ups je bezi na sit
//  OB			- 4 ups bezi na baterie
//  LB			- 8 baterie je vybyta (pokud je zaroven OB dojde k shutdownu)
//  CAL			- 16 je spustena calibrace
//  OVER		- 128 ups je pretizena
//  RB			- 256 ups pozaduje vymenu baterie

  if (panelBulbs > 1) {
    // ups online /na sit
    if (panelBulbs & 2) {
      frameOL->setBackgroundColor(upsOk);
      LCDNumber1->setPalette (LCDPaletteOk);
      }
    else frameOL->setBackgroundColor(upsBack);

    // ups ofline /na baterie
    if (panelBulbs & 4) {
      frameOB->setBackgroundColor(upsError);
      LCDNumber1->setPalette (LCDPaletteErr);
      }
    else frameOB->setBackgroundColor(upsBack);

    if (panelBulbs & 8) frameLB->setBackgroundColor(upsError);
    else frameLB->setBackgroundColor(upsBack);

    if (panelBulbs & 128) frameOVER->setBackgroundColor(upsError);
    else frameOVER->setBackgroundColor(upsBack);

    if (panelBulbs & 256) frameRB->setBackgroundColor(upsError);
    else frameRB->setBackgroundColor(upsBack);
    }
  }

void KNutFrontPanel::changePanelFont (void) {
  textLabel1->setFont(panelFont);
  textLabel2->setFont(panelFont);
  textLabel3->setFont(panelFont);
  textLabel4->setFont(panelFont);
  textLabel5->setFont(panelFont);
  textLabel6->setFont(panelFont);

  textLabelManufac->setFont(panelFont);
  QFontMetrics fm = textLabelManufac->fontMetrics();
  mfrWidth = fm.width(textLabelManufac->text());

  textLabelName->setFont (panelFont);
  fm = textLabelName->fontMetrics();
  nameWidth= fm.width(textLabelName->text());

  textLabelSerial->setFont (panelFont);
  fm = textLabelSerial->fontMetrics();
  serialWidth= fm.width(textLabelSerial->text());

  textLabelFirm->setFont (panelFont);
  fm = textLabelFirm->fontMetrics();
  firmWidth= fm.width(textLabelFirm->text());

  textLabelRun->setFont (panelFont);
  fm = textLabelRun->fontMetrics();
  runWidth= fm.width(textLabelRun->text());

  textLabel7->setFont (panelBoldFont);
  textLabel8->setFont (panelBoldFont);
  textLabel9->setFont (panelBoldFont);
  textLabel10->setFont (panelBoldFont);
  textLabel11->setFont (panelBoldFont);

  textLabelRun->setFont (panelFont);
  }

void KNutFrontPanel::slotSetPanelFont(QFont newPanelFont) {

  panelFont = newPanelFont; // nastavime font
  panelBoldFont = newPanelFont; // pozdeji zmenime

  panelBoldFont.setBold (TRUE);
  panelFont.setBold (FALSE); // Zrusime bold u panelu

  changePanelFont(); // zmeni pismo
  paintPanel();
  }
