/***************************************************************************
                          knutclient.h  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTCLIENT_H
#define KNUTCLIENT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <kaction.h>

#include <qwidget.h>

#include "knutprefdlg.h"
#include "knutupsdata.h"
#include "knutvardata.h"
#include "knutfrontpanel.h"
#include "knutnet.h"
#include "kanalog.h"



#define SPACE_PANELS 2 // vzdalenost mezi meraky

#define MIN_HEIGHT_AREA 199; //min viska plochy
#define MIN_WIDTH_AREA 204; //min sirka plochy

#define PANEL_WIDTH 180
#define FRONT_PANEL_WIDTH 180


#define MAX_BATTVOLT 80
#define MAX_CURRENT 25
#define MAX_BAT_CURRENT 30

class KNutClient : public KMainWindow {
  Q_OBJECT
  public:
    KNutClient(QWidget* parent=0,const char* name=0);
    ~KNutClient();

  private slots:

    void slotShowToolBar();
    void slotShowStatusBar();
    void slotPreferencesUps();
    void slotPrintUPSVars();
    void slotInstComms();
    void slotRWVars();
    void slotLoadUps (const QString &);
    void slotSetConfig (unsigned int changeSetting);
    void slotChangeRWVars ( QString varName);

  
    void timeout (void);
    void closeEvent( QCloseEvent *e );
    void slotCloseKnutClient (void);


  private:
/****************************************************/
/*               private functions                  */
/****************************************************/
// activuje cteni dat pro promene z UPS pokud je true zjisti se SELECT MFR MODEL SERIAL FIRMREV
  void setActiveUpsVars (bool nameVars = true);

  void upsActivate ( void );
  void upsDeactivate (void);

  void activateAnalogs (void );
  void deActivateAnalogs (void);

  char* nameUpsVar (int codeUpsVar);

  void setSize (bool showPanel = false);
  void activeConfiguration (bool anRepaint);

  void saveConfiguration (void);
  void loadConfiguration (void);

  void setActiveUpsInfo (UpsRecord* upsRecordPointer);

  void setActiveXFerVars (bool activate); // Activuje/Deaktivuje nacitani hodnot XFER

  void repaintAnalogPanels (bool repaintFrequencyPanels, bool repaintVoltagePanels, bool repaintAllPanels, bool repaintBGAPanels);
  

    
/************************/
/* inicializacni funkce */
/************************/
  void initVars ( void );
  void initAction ( void );
  void initStatusBar ( void );
  void initToolBar ( void );
  void initAnalogs (void );

/************************************/
/*            private vars          */
/************************************/
// Nazvy promenych UPS cislovany jsou od 0 do 10 "NONE", "UTILITY", "BATTPCT", "UPSTEMP", "ACFREQ", "LOADPCT", "AMBTEMP", "AMBHUMID", "BATTVOLT", "OUTVOLT", "CURRENT"

  SettingDataDef settingData;  // v teto strukture jsou ulozeny promene ktere nastavuji konfiguraci

  KAction *quit;
  KAction *preferencesUps;

  KNutPrefDlg* prefDlg;
  KNutUpsData* upsRecords;
  KNutVarData* analogRecords;

  bool errorUpsData; // zda doslo pri zpracovani dat k chybe

  QTimer* upsTimer;
  int activeUpsIndex;
  UpsInfo activeUpsInfo; // hodnoty pro vybrane ups

  QLabel *area; // hlavni plocha na ni umistime panel a analogove ukazatele

  KNutFrontPanel* frontPanel;
  KNutNet*	activeUps;

  int heightArea, widthArea, minHeightArea, minWidthArea; // velikost zakladni plochy


  // nactene hodnoty promenych UPS, tyto promene se ctou jen jednou
  QString manufacturer, upsModel, serial, firmrev;
  bool existLowHighXfer;
  float lowXfer, highXfer;

  QPalette mainPalette, areaPalette, mPanelPalette, aPanelPalette;
  
  };

#endif
