#include "knap_preferences.h"
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include "support_funcs.h"

#include <iostream>

KNAP_Preferences::KNAP_Preferences()
{
   load();
}
KNAP_Preferences::~KNAP_Preferences()
{

}
void KNAP_Preferences::load()
{
   KConfig *config = KGlobal::config();

   username = config->readEntry("username","");
   password = config->readEntry("password","");
   email = config->readEntry("email","");
   newuser = config->readBoolEntry("newuser",true);

   // connection
   server = config->readEntry("server","server.napster.com");
   port = config->readNumEntry("port",6699);
   connectionspeed = config->readNumEntry("connectionspeed",0);
   firewall = config->readBoolEntry("firewall",false);

   // transfer
   downloadpath = config->readEntry("downloadpath","~/");
   maxdownloads = config->readNumEntry("maxdownloads",0);
   downloadtimeout = config->readNumEntry("downloadtimeout",9);
   beeponfinish = config->readBoolEntry("beeponfinish",true);

   maxuploads = config->readNumEntry("maxuploads",0);
   maxuploadsperuser = config->readNumEntry("maxuploadsperuser",0);

   // color
   normalcolor = config->readColorEntry("normalcolor",&Qt::black);
   messagecolor = config->readColorEntry("messagecolor",&Qt::blue);
   QColor notifycol = QColor(0x00,0xBB,0xBB);
   notifycolor = config->readColorEntry("notifycolor",&notifycol);
// &Qt::black);
   errorcolor = config->readColorEntry("errorcolor",&Qt::red);
   // misc
   clearonnewsearch = config->readBoolEntry("clearonnewsearch",true);
   showfullfilepath = config->readBoolEntry("showfullfilepath",true);
   multiselect = config->readBoolEntry("multiselect",true);
   useexternalplayer = config->readBoolEntry("useexternalplayer",true);
   playercommand = config->readEntry("playercommand",""); 
   languagefilter = config->readBoolEntry("languagefilter",false); 

   // shared list
   QStrList paths;

   config->readListEntry("sharepath",paths);

//   KNAP_PathInfo *pathinfo;

   QString tmp_path = paths.first();

   sharepaths.clear();

   while (tmp_path) 
   {
      QString path, tmpstr;
      bool shared;
      int depth;

      int pos = tmp_path.find(QChar('|'));

      path = expandFileName( tmp_path.left(pos) );
      tmp_path.remove(0, pos+1);
      
      pos = tmp_path.find(QChar('|'));
      tmpstr = tmp_path.left(pos);
      
      shared = (tmpstr.toInt()==1); 
      tmpstr = tmp_path.remove(0, pos+1);

      depth = tmpstr.toInt();
      if(depth<0) depth=0;

      if(path.length()>0) sharepaths.append(KNAP_PathInfo(path,shared,depth));

      tmp_path=paths.next();
   }

}
void KNAP_Preferences::save()
{
   KConfig *config = KGlobal::config();

   // userinfo
   config->writeEntry("username",username); 
   config->writeEntry("password",password); 
   config->writeEntry("email",email); 
   config->writeEntry("newuser",newuser); 

   // connection
   config->writeEntry("server",server);
   config->writeEntry("port",port);
   config->writeEntry("connectionspeed",connectionspeed);
   config->writeEntry("firewall",firewall);

   // transfer
   config->writeEntry("downloadpath",downloadpath);
   config->writeEntry("maxdownloads",maxdownloads);
   config->writeEntry("downloadtimeout",downloadtimeout);
   config->writeEntry("beeponfinish",beeponfinish);

   config->writeEntry("maxuploads",maxuploads);
   config->writeEntry("maxuploadsperuser",maxuploadsperuser);

   // colors
   config->writeEntry("normalcolor",normalcolor);
   config->writeEntry("messagecolor",messagecolor);
   config->writeEntry("notifycolor",notifycolor);
   config->writeEntry("errorcolor",errorcolor);

   // we can't save if there is no header or name to save under
   //   if(head==NULL || name()==NULL) return false;
   //    
   //      cols = head->count();
   //       
   //         for(i=0;i<cols;i++)
   //           {
   //               widthlist.append( QString().setNum(columnWidth(i)) );
   //                 }
   //                  
   //                    config->writeEntry(name(),widthlist);  

   config->writeEntry("clearonnewsearch",clearonnewsearch);
   config->writeEntry("showfullfilepath",showfullfilepath);
   config->writeEntry("multiselect",multiselect);
   config->writeEntry("useexternalplayer",useexternalplayer);
   config->writeEntry("playercommand",playercommand); 
   config->writeEntry("languagefilter",languagefilter); 

   // shared list
   QStrList paths;

//   KNAP_PathInfo *path;

   PathInfoList::Iterator it;
   for( it = sharepaths.begin(); it != sharepaths.end(); ++it )
//   for ( pathinfo=sharepaths.first(); pathinfo != 0; pathinfo=sharepaths.next() )
   {
      paths.append((*it).toString());
   }     
   config->writeEntry("sharepath",paths);

}
/*
 *  NOTE this was reuired to load the prefs - but isnt required
 * any more as prefs get loaded on creation of a prefs object
 */
/*
KNAP_Preferences KNAP_Preferences::getPreferences()
{
   KNAP_Preferences p;
   p.load();
   return p;
}
*/
