#ifndef KNAP_CHATMANAGERPANEL_H
#define KNAP_CHATMANAGERPANEL_H

//#include "knap_buttontabbar.h" 
#include <qtabwidget.h>
#include <qlist.h>
#include "knap_chanpanel.h"

class KNAP_ChatManagerPanel
//: public KNAP_ButtonTabbar
: public QTabWidget
{
   Q_OBJECT
signals:
      void message(const char *msg);
      void command(const char *comm);
      
private:      
      class ChatData
      {
	 public:
        QString name;
	QWidget *wid;

	ChatData(const QString &s,QWidget *w)
	{
	   name = s;
	   wid =w;
	}
	ChatData &operator=(const ChatData &d)
	{
          if(this != &d)
	  {
            name = d.name;
	    wid  = d.wid;
	  }
	  return *this;
	} 
	ChatData(const ChatData &d)
	{
            name = d.name;
	    wid  = d.wid;
	}
      };
      
      QList<ChatData> chans;

      QString whoami;

   public:
       KNAP_ChatManagerPanel(QWidget *parent=0,const char *name=0);
       virtual ~KNAP_ChatManagerPanel();

       void setOffline();

       void setWhoAmI(const QString me) { whoami = me; }

       void writeChannel(const QString &data, 
	     KNAP_ChanPanel::MessageType type=KNAP_ChanPanel::MessageNone);
       
       void writeChannel(const QString &channame,QString &text, 
	     KNAP_ChanPanel::MessageType type=KNAP_ChanPanel::MessageNone);

       void writeChannelActionMessage(const QString &data);

       void writeChannelMessage(const QString &data);
       void writeUserMessage(const QString &data);
       
       void clearChannel(const QString &channame);
      
       void writeError(QString &text);
     
       KNAP_ChanPanel * openChatWindow(const char *name,bool showuserlist);
       void closeChatWindow(const char *name);

       void setChannelTopic(QString &data);

       void userJoined(const QString &data,bool notify);
       void userLeft(const QString &data);

//       void writeChannel(const QString &channame,QString &text, 
//	     KNAP_ChanPanel::MessageType type=KNAP_ChanPanel::MessageNone);
       //KNAP_ChanPanel * findChannelWindow(const QString name);
       KNAP_ChanPanel *findWidget(const QString &n);

       KNAP_ChanPanel *findChanWindow(const QString &n);
       KNAP_ChanPanel *findChatWindow(const QString &n);
  private:
       void addTab(QWidget *, const QString &);
       void remTab(QWidget *);

};


#endif // KNAP_CHATMANAGERPANEL_H
