/***************************************************************************
  napsterconnection.cpp  -  description
  -------------------
begin                : Sun Dec 5 1999
copyright            : (C) 1999-2000 by jade
email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napsterconnection.h"
//#include "napsterdownload.h"
#include "incomingconnection.h"

#include "support_funcs.h" // for inet_aton if required
#include <qtimer.h>
/*
#include <netdb.h>
 */
#include <sys/socket.h>

#include <sys/time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h> 
//#include <arpa/tftp.h>
/*
#include <stdio.h>
#include <string>
#include <cstring>
 */

#include "../config.h" // for "VERSION"

#include <kapp.h>

#include <iostream.h>

#include "songinfo.h"
// for doing looping inbetween parts set this 0- not that it makes much difference
// #define KDE_INTERACTION

// some machines dont seem to know this constant
#ifndef INADDR_NONE
#define INADDR_NONE -1
#endif

// error strings - match those from NapError 
const char *NapsterConnection::errorstr[]=
{
   "Ok","Timeout","Bad port number","Bad IP number",
   "Cannot connect to host",
   "Read error","Write error",
   "Server is busy","Could not connect to server to get best host",
   "Bad data received","Trying to send bad data",
   "Could not login - incorrect user/password??",
   "Could not download","Could not open socket",
   "Could not create binded listener socket",
   "Could not create a new user - perhaps this name is already in use",
   "Invalid username/password for new user - use a different name/password.",
   "Extended knapster Error",
   "Unknown error",
   ""
};

const char *NapsterConnection::getLastErrorStr() const
{ 
   if(_lasterror==NAP_EXTENDED_ERROR)
   {
      NAPBLOCKPTR blk = (NAPBLOCKPTR)_buffer;

      if(blk->size>0) return blk->data;
   }
   if(_lasterror<0 || _lasterror>NAP_LAST) return errorstr[NAP_LAST];
   return errorstr[_lasterror];
}

   NapsterConnection::NapsterConnection(QObject *parent, const char *name)
: QObject(parent,name)
{
   incominglist.setAutoDelete(true);

   
   _connected=false;
   _havehost=false;

   _napster=0;
   _listener=0;

   _napsterport=-1;

   _buffer[0]='\0';

   _lasterror=NAP_OK;

   QTimer *timer=new QTimer(this);
   if(timer)
   {
      connect(timer,SIGNAL(timeout()),this,SLOT(timeout()));

      timer->start(1 * 1000); // update every 2 seconds
   } 

}
NapsterConnection::~NapsterConnection()
{
   close();
}

// assumes getBestHost was called
/*
   bool NapsterConnection::open(int port)
   {
   close();

   _lasterror=NAP_OK;

   _listenerport=port; // save the listen port for doing logins

   setupListener(port);

   cerr << "napsterconnection::open(): " << _napsteraddr << " " << _napsterport <<endl;

   _napster = new KSocket(_napsteraddr,_napsterport); // timeout

   if(!_napster || _napster->socket()==-1)
   {
   delete _napster;
   _napster=0;
#ifdef DEBUG_1
cerr<<"Can't connect!\n"<<flush;
#endif
  _lasterror=NAP_NO_CONNECT;
  return(false);
}
#ifdef DEBUG_1
cerr<<"connected to "<< getIPAddressString() << " ("<<_napster->socket()<<")"<<endl;
#endif

_connected = true;

return true;
}
*/
// assumes getBestHost was called
bool NapsterConnection::open(int port)
{

   int _napstersock;
   struct sockaddr_in _sockaddr;

   close();

   _lasterror=NAP_OK;

   _listenerport=port; // save the listen port for doing logins

   setupListener(port);


   memset(&_sockaddr,0,sizeof(_sockaddr));
   if(!inet_aton(_napsteraddr,&_sockaddr.sin_addr)) 
   {
      cout<<"NapsterConnection::open(): error: no server address found\n"
	 << flush;
      _lasterror=NAP_BAD_IP;
      return false;
   }
   _sockaddr.sin_family = AF_INET;
   _sockaddr.sin_port = htons(_napsterport);


   _napstersock = socket(AF_INET,SOCK_STREAM,0);
   if(_napstersock==-1) 
   {
      _lasterror=NAP_NO_SOCKET;
      return false;
   }

#ifdef KDE_INTERACTION
//   kapp->processEvents(1000);
#endif

   if(std::connect(_napstersock,(sockaddr
	       *)&_sockaddr,sizeof(struct sockaddr))<0) 
   {
      std::close(_napstersock);
      _napstersock=-1;
      cerr<<"NapsterConnection::open(): Can't connect!\n"<<flush;
      _lasterror=NAP_NO_CONNECT;
      return(false);
   }
   cerr<<"NapsterConnection::open(): connected to "
      << getIPAddressString()<<endl;

   _napster = new KSocket(_napstersock);
   /*
    * should have been able to replace all that with:    
    * _napster = new KSocket(_napsteraddr,_napsterport);
    * but it doesnt like it for somereason
    */

   connect(_napster,SIGNAL(readEvent(KSocket *)),this,SLOT(napsterRead(KSocket *)));
   connect(_napster,SIGNAL(closeEvent(KSocket *)),this,SLOT(napsterClose(KSocket *))); 

   return true;
} 
void NapsterConnection::receiveData(bool yes)
{
   _napster->enableRead(yes);
//   _listener->enableRead(yes);
}
// disconnect
void NapsterConnection::close()
{
   // close the listener
   if(_listener!=0) delete _listener;
   _listener = 0;

   if(_napster!=0) delete _napster;
   _napster=0;
  
   // kill pending incomes 
   incominglist.clear();

   _connected=false;
}

int NapsterConnection::getSocket() const
{
   return _napster==0 ? -1 : _napster->socket();
}
int NapsterConnection::getListener() const
{
   return _listener==0 ? -1 : _listener->socket();
}

bool NapsterConnection::getBestHost(const char *server)
{
   //KSocket *sock;

   struct hostent *hent;

   _havehost=false;

   _lasterror=NAP_OK;


   // find the best host by querying the main napster server
   KSocket sock(server,SERVER_PORT); // lets use a local so we dont have to bother with
   // delete

   if(sock.socket()==-1)
   {
      _lasterror=NAP_NO_SOCKET;

      return false;
   }

   // get the best host info
   int sz;
   // TODO add timeout if can't connect
   fd_set fdsr;
   struct timeval tm;

   tm.tv_sec=0;
   tm.tv_usec=500;

   FD_ZERO(&fdsr);
   FD_SET(sock.socket(),&fdsr);
   while((sz = select(sock.socket()+1,&fdsr,NULL,NULL,&tm))==0)
   {
#ifdef KDE_INTERACTION
//      kapp->processEvents(1000);
#endif

      tm.tv_sec=0;
      tm.tv_usec=500;

      FD_ZERO(&fdsr);
      FD_SET(sock.socket(),&fdsr);

   }

   if((sz=recv(sock.socket(),_buffer,256,0))<=0) 
   {
      cout<<"NapsterConnection::getBestHost(): "
	 << "Can't get best host info!\n"<<flush;
      _lasterror=NAP_NO_READ;
      return false;
   }
   _buffer[sz]='\0';

   // *********** NEED TO ALSO HANLE busy and wait *************************
   cout<<"NapsterConnection::getBestHost(): "
      << "read data for host was '"<<_buffer<<"'\n";

   if(strncmp(_buffer,"busy",4)==0 || strncmp(_buffer,"wait",4)==0)
   {
      cout<<"NapsterConnection::getBestHost(): "
	 << "server is busy!!!!\n"<<flush;
      _lasterror=NAP_SERVER_BUSY;
      return false;
   }
   cerr<<"NapsterConnection::getBestHost(): "
      << "retrieved server string of: "<<_buffer<<endl<<flush;

   if(!parseBestHostString(_buffer)) return false;


   return true;
}
// NOT const data in coz it will be modified
bool NapsterConnection::parseBestHostString(const char *str)
{
   // get the address to connect to ( the best host )
   const char *ip;
   char *p;

   _havehost=false;


   cerr << "NapsterConnection::parseBestHostString() " << str << endl;

   if(str==NULL) return false;

   // TODO handle http on front when a URL ???

   ip = str;
   p = strchr(str,':');
   if(p==NULL) {
#ifdef DEBUG_1
      cout<<"NapsterConnection::parseBestHostString() "
	 << "best host info invalid\n"<<flush;
#endif
      _lasterror=NAP_BAD_RECV_DATA;
      return false;
   }
   p[0] = '\0';
   p ++;

   _napsteraddr = ip;
   if(_napsteraddr.isEmpty())
   {
#ifdef DEBUG_1
      cout<<"NapsterConnection::parseBestHostString() "
	 << "error: no server address found\n"<<flush;
#endif
      _lasterror=NAP_BAD_IP;
      return false;
   }
   _napsterport = QString(p).toInt();

#ifdef DEBUG_1
   cerr<<"NapsterConnection::parseBestHostString() "
      << "*** addr is at "<<_napsteraddr<<endl;
   cerr<<"NapsterConnection::parseBestHostString() "
      << "*** port is at "<<_napsterport<<endl;
#endif

   _havehost=true;

   return true;
}

void NapsterConnection::timeout()
{

   fd_set fdsr;
   int s;
   struct timeval tm;
   IncomingConnection::ConnectionType type;
   SongInfo si;
   
   //cerr << "NapsterConnection::timeout(): checking ... " << incominglist.count() << endl;
   // check if an incomming connection has been wworked out yet
   IncomingConnection *i;
   for (i=incominglist.first(); i != 0; i=incominglist.next() )
   {
     type = i->getType();

     // if we have one we have worked out -> process it
     if(type!=IncomingConnection::CONNECTION_UNKNOWN)
     {
       cerr << "Worked out this connection!!\n";	
       if(type==IncomingConnection::CONNECTION_DOWNLOAD)
       {
	  cerr << "ConnectionType: download\n";
          KSocket *s = new KSocket(i->getSocket());
	  si = i->getSongInfo(); 
          emit onTransferConnection(s,&si,true);
       }
       else if(type==IncomingConnection::CONNECTION_UPLOAD)
       {
	  cerr << "ConnectionType: upload\n";
          KSocket *s = new KSocket(i->getSocket());
	  
	  si = i->getSongInfo(); 
          emit onTransferConnection(s,&si,false);

       }
       // kill from list
       else 
	  std::close(i->getSocket());
       
       incominglist.removeRef(i);
     }
   }
   // check for new connections and process if needed
   
   if(getListener()==-1) return;

   s=getListener();

   FD_ZERO(&fdsr);
   FD_SET(s,&fdsr);

   tm.tv_sec=0;
   tm.tv_usec=1;

   s=select(s+1,&fdsr,NULL,NULL,&tm);
   if(s<=0) // timeout or error
      return; 

   cerr << "NapsterConnection::timeout(): have a connection\n";

   // accept()
     struct sockaddr_in connaddr;
       s=sizeof(connaddr);  
   s = accept(getListener(),(struct sockaddr *)&connaddr, (size_t *)&s);
   if(s==-1)
   {
     cerr << "NapsterConnection::timeout(): couldnt accept connection\n";
     return;
   }

   IncomingConnection *conn = new IncomingConnection(s);
   conn->run();
   incominglist.append(conn);

}
void NapsterConnection::napsterRead(KSocket *)
{
   NAPBLOCKPTR blk;

   // read pending block
   blk=readBlock(false);

   cerr << "NapsterConnection::napsterRead(): [" 
      << QString().setNum(blk->type) 
      <<  QString("] size: ") << QString().setNum(blk->size) << "=" 
      << blk->data << endl;

   if(blk->type!=NAP_ERROR || blk->size>0)
      emit onRead(blk);

}
void NapsterConnection::napsterClose(KSocket *)
{
   close();
   emit onClosed();
}

QString NapsterConnection::getUser() const 
{ 
   return username; 
}

bool NapsterConnection::login(const char *_username,const char *password,
      const char *email,int conn,bool new_user)
{
   _lasterror=NAP_OK;

   username = _username;

   if(_napster==0) 
   {
      _lasterror=NAP_NO_CONNECT;
      return false;
   }
   QString tmp;
   int len;

   if(new_user) 
   {
#ifdef DEBUG_1
      cout<<"creating new user...\n"<<flush;
#endif
      //  tmp = username;

      //    len=tmp.length();

      writeBlock(NAP_CREATEUSER_REQ,username);

      // now its time to logon
#ifdef DEBUG_1
      cout<<"new user logging on...\n"<<flush;
#endif

      tmp=username + QString(" ") + password + QString(" ") 
	 + QString().setNum(_listenerport)
	 + " \"knapster2-" VERSION "\" " + QString().setNum(conn) + QString(" ") 
	 + email;

      //    len=tmp.length();

      writeBlock(NAP_NEWUSERLOGIN_REQ,tmp);

      // now get the response
#ifdef DEBUG_1
      cout<<"Wait for server response\n"<<flush;
#endif

      NAPBLOCKPTR ptr;

      ptr=readBlock();

      cout<<"resp: ["<<ptr->type<<"] "
	 <<" ["<<ptr->size<<"] "<<ptr->data<<endl<<flush;

      if(ptr->type==NAP_CREATEUSER_ERROR) 
      {
	 _lasterror=NAP_NO_CREATEUSER;
	 return false;
      }

      if(ptr->type==NAP_CREATEUSER_INVALIDNAME) 
      {
	 _lasterror=NAP_BAD_USERNAME;
	 return false;
      }

      if(ptr->type==NAP_ERROR) 
      {
	 cout<<"login error: "<<ptr->data<<endl<<flush;

	 _lasterror=NAP_NO_LOGIN;

	 _connected=false;

	 return false;
      }
   }
   else 

   {
      // now its time to logon as normal user
#ifdef DEBUG_1
      cout<<"logging on...\n"<<flush;
#endif

      tmp=QString(username) + QString(" ") + password + QString(" ") 
	 + QString().setNum(_listenerport) 
	 + " \"knapster2-" VERSION "\" " + QString().setNum(conn);

#ifdef DEBUG_1
      // only print out this kind of info in special debug mode
      cerr << "NapsterConnection::login(): " << tmp << endl;
#endif
      writeBlock(NAP_LOGIN_REQ,tmp);

      // now get the response
#ifdef DEBUG_1
      cout<<"Wait for server response\n"<<flush;
#endif

      NAPBLOCKPTR ptr;

      ptr=readBlock();

      cout<<"resp: ["<<ptr->type<<"] "<<" ["<<ptr->size<<"] "
	 <<ptr->data<<endl<<flush;

      cout << "Last Error: " << getLastErrorStr() << endl;

      if(ptr->type==NAP_ERROR) 
      {
	 cout<<"login error: "<<ptr->data<<endl<<flush;
         if(ptr->size>0)
         {
           _lasterror = NAP_EXTENDED_ERROR;
         }
         else 
	   _lasterror=NAP_NO_LOGIN;

	 _connected=false;

	 return false;
      }
   }
   // wow!! - we finally did it
   _connected=true;

   return true;
}


QString NapsterConnection::getIPAddressString() const
{
   //  QString s="";
   //  struct in_addr in;

   //  if(_napster)
   //  {
   //     in.s_addr = _napster->ipv4_addr();
   //     s=inet_ntoa(in);
   //  }
   //  return(s);
   return _napsteraddr;
}

int NapsterConnection::getIPPort() const
{
   //return ntohs(_sockaddr.sin_port);
   // _sockaddr.sin_port = htons
   //_napster->
   return _napsterport;
}


// read the comms port -> ret -1 on error and -2 on timeout
// otherwise ret num of chars read
int NapsterConnection::readComm(char *xbuffer,int size)
{
   int s=0;

#ifdef KDE_INTERACTION
//   kapp->processEvents(1000);
#endif

   _lasterror=NAP_OK;

   if(_napster==0) 
   {
#ifdef DEBUG_1     
      cerr << "socket is null\n";
#endif
      _lasterror=NAP_NO_CONNECT;
      return(-1);
   }

   // using recv not read since we want full records not
   // just whatever we can get??
   s=recv(_napster->socket(),xbuffer,size,0);

   //#ifdef DEBUG_1
   //   if(s>=0) xbuffer[s]='\0';
   //   cerr << "readCom(): [" << s << "]: " << xbuffer <<endl;
   //#endif  

   return(s);
}
int NapsterConnection::writeComm(const char *astring,int size)
{
   int s;

   _lasterror=NAP_OK;

#ifdef KDE_INTERACTION
//   kapp->processEvents(1000);
#endif

   if(_napster==0) 
   {
      _lasterror=NAP_NO_CONNECT;

      return(-1);
   }
   s=send(_napster->socket(),astring,size,0);
   return s;
}

NAPBLOCKPTR NapsterConnection::readBlock(bool waitfordata)
{
   int s;
   NAPBLOCKPTR ptr;

   ptr=(NAPBLOCKPTR)_buffer;

   ptr->type=NAP_ERROR;
   ptr->size=0;

   if(_napster==0) 
   {
      _lasterror=NAP_NO_CONNECT;

      return ptr;
   }
   // --- test that reads will get valid data

   // TODO - force it to wait for data if waitfordata is true
   if(waitfordata)
   {
      fd_set fdsr;
   //   struct timeval tm;

   //   tm.tv_sec=0;
   //   tm.tv_usec=500;

      FD_ZERO(&fdsr);
      FD_SET(_napster->socket(),&fdsr);
      select(_napster->socket()+1,&fdsr,NULL,NULL,NULL);
   }

   if(!waitfordata)
   {
      //#ifdef DEBUG_1
      //      cerr << "in wait for data\n";
      //#endif  
      s = recv(_napster->socket(),_buffer,MAX_NAP_BLOCK,MSG_PEEK);
      if(s<4)
      {
	 /* not even the start of the header yet */
	 ptr->size=0;
	 ptr->type=NAP_ERROR;

	 _lasterror = NAP_NO_READ;
	 return ptr;
      }
      ptr->size=NAP_TO_SHORT(ptr->size); // make sure its in the right endian

      if(ptr->size<MAX_NAP_BLOCK) // TODO valid to be > ??
      {
	 //       s = ptr->size;
	 //       if(recv(_napster,_buffer,4+s,MSG_PEEK)<(4+s))
	 if((ptr->size + 4) > s)
	 {
	    // not enough to read yet

	    ptr->size=0;
	    ptr->type=NAP_ERROR;

	    _lasterror = NAP_NO_READ;
	    return ptr;
	 }
      }
   }

   //--------------
   // now do the real read
   if((s = readComm(_buffer,4))<=0)  // error or no data
   {
      _lasterror=NAP_NO_READ;
#ifdef DEBUG_1
      cout<<"read err1: "<<s<<endl<<flush;
#endif
      return ptr;
   }

   ptr->size=NAP_TO_SHORT(ptr->size); // make sure its in the right endian
   ptr->type=NAP_TO_SHORT(ptr->type);

   if((short int)ptr->size < 0) {
      //cout<<"size error\n";
      ptr->type=NAP_ERROR;
      _lasterror=NAP_BAD_RECV_DATA;
#ifdef DEBUG_1
      cout<<"read err2: "<<ptr->size<<endl<<flush;
#endif
      ptr->size=0;
   }
   else if(ptr->size<MAX_NAP_BLOCK) 
   {      // ******** may be > 1024 ?????????????????

      s=readComm(ptr->data,ptr->size );

      ptr->data[s]='\0';

      _lasterror=NAP_OK;
#ifdef DEBUG_2
      cout<<"NapsterConnection::readBlock(): ["
	 << ptr->type << "]: (" << s <<")bytes "
	 << ptr->data << endl << flush;
#endif
      ptr->size=s; //********************
   }
   else 
   {
#ifdef DEBUG_1
      cout<<"Someting bad happened in readBlock\n";
#endif
      ptr->type=NAP_ERROR;
      _lasterror=NAP_BAD_RECV_DATA;
      ptr->size=0;
   }
   return ptr;
}

int NapsterConnection::writeBlock(int type,const QString &data)
{
   NapBlock blk;

   int s;

   // fix for the endianess problem
   blk.size=SHORT_TO_NAP(data.length());
   blk.type=SHORT_TO_NAP(type);

   s=writeComm((char *)&blk,4);
   if(s!=-1) 
   {
      // send the actual data
      if(data.length()>0)
	 s=writeComm(data,data.length());
   }
   else  _lasterror=NAP_NO_WRITE;

   return s;
}
/*
   int NapsterConnection::writeBlock(int type,const char *data,int size)
   {
   NapBlock blk;

   int s;

// fix for the endianess problem
blk.size=SHORT_TO_NAP(size);
blk.type=SHORT_TO_NAP(type);

s=writeComm((char *)&blk,4);
if(s!=-1) 
{
// send the actual data
if(size>0)
s=writeComm(data,size);
}
else  _lasterror=NAP_NO_WRITE;

return s;
}
 */
// ---------------------------------------------------------------------
bool NapsterConnection::setupListener(int _port)
{
   struct sockaddr_in server;
   int len=1;
   int local;

   if(_listener==0) 
   {
      local = socket(AF_INET, SOCK_STREAM, 0);
      if (local < 0) 
      {
#ifdef DEBUG_1
	 cerr<<"connection listener socket error!\n"<<flush;
#endif
	 _lasterror=NAP_NO_SOCKET;
	 return false;
      }

      server.sin_family = AF_INET;
      server.sin_addr.s_addr = htonl(INADDR_ANY);
      server.sin_port = htons(_port);

      setsockopt(local, SOL_SOCKET, SO_REUSEADDR, &len, sizeof(len));

      if (bind(local, (struct sockaddr *)&server, sizeof(server)) < 0) {
#ifdef DEBUG_1
	 cerr<< "bind error in connection listener\n"<<flush;
#endif
	 std::close(local);
	 local=-1;
	 _lasterror=NAP_NO_BIND;
	 return false;
      }

      listen(local, 0);   // send number of allowed connections *********************************
   }
   _listener = new KSocket(local);
   return true;
}

// get current buffer - probally dangerous to use this
// or at least the results contained in it may be unpredictable
const char *NapsterConnection::getBuffer()
{
   return _buffer;
}

const NAPBLOCKPTR NapsterConnection::getLastBlock() const
{
   NAPBLOCKPTR blk;

   blk=(NAPBLOCKPTR)_buffer;
   if(blk->type!=NAP_ERROR || blk->size>0)
      return blk;

   return 0;
}

bool NapsterConnection::share(const SongInfo *s)
{
   if(!s) return false;

   // CONVERT TO WINDOWS PATH!!!!!!
   QString str=QString("\"") + s->filename +QString("\"") + " "
      + s->md5 + " " + QString().setNum(s->size) + " " +
      QString().setNum(s->bitrate) + " " + QString().setNum(s->freq)
      + " " + QString().setNum(s->seconds);
   //  str=str.stripWhiteSpace();

#ifdef DEBUG_1
   cerr<<"sending shared: "<<str<<endl<<flush;
#endif
   // since a lot of shares can be sent at a time, make sure
   // we have sent every thing in the send buffer before we send 
   // more data
   cerr << "Wait send...";

   fd_set fdsw;
//   struct timeval tm;

//   tm.tv_sec=0;
//   tm.tv_usec=500;

   FD_ZERO(&fdsw);

   FD_SET(_napster->socket(),&fdsw);
   select(_napster->socket()+1,NULL,&fdsw,NULL,0 /*&tm*/);
   cerr << "ok\n"; 
   
   return writeBlock(NAP_ADDTOSONGLIST_REQ,str)!=-1;
}

void NapsterConnection::sendSearch(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   //   int l=strlen(name);

   if(writeBlock(NAP_SEARCH_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
} 
void NapsterConnection::sendHotlistUser(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_ADDTOHOTLIST,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendRemoveHotlistUser(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_DELETEFROMHOTLIST,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendBrowseUser(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_BROWSE_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendWhoisUser(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_WHOIS_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendChannellist(bool showall)
{
   _lasterror=NAP_OK;

   if(writeBlock(NAP_CHANLIST_REQ,"")==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendChannelMessage(const char *chan,const char *msg)
{
   _lasterror=NAP_OK;

   if(!chan || !msg) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   QString m = QString(chan) + " " + msg;

   if(writeBlock(NAP_SENDCHAN_MSG,m)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendJoinChannel(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_JOINCHAN_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendPartChannel(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_PARTCHAN_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
}

void NapsterConnection::sendUserMessage(const char *user,const char *msg)
{
   _lasterror=NAP_OK;

   if(!user || !msg) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   QString m = QString(user) + " " + msg;

   if(writeBlock(NAP_USER_MSG,m)==-1)
      _lasterror=NAP_NO_WRITE;
}

void NapsterConnection::sendQueueFull(const char *user,const char *song,int max)
{
   _lasterror=NAP_OK;

   if(!user || !song) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   QString m = QString(user) + " \"" + song + "\"" + QString().setNum(max);

   if(writeBlock(NAP_QUEUE_LIMIT,m)==-1)
      _lasterror=NAP_NO_WRITE;

}
void NapsterConnection::sendUploadAllowed(const char *user,const char *song)
{
   _lasterror=NAP_OK;

   if(!user || !song) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   QString m = QString(user) + " \"" + song + "\"";

   if(writeBlock(NAP_UPLOAD_ALLOWED,m)==-1)
      _lasterror=NAP_NO_WRITE;
}

void NapsterConnection::sendDownloadRequest(const char *user,
      const char *song)
{
   _lasterror=NAP_OK;

   if(!user || !song) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   QString m = QString(user) + " \"" + song + "\"";

   if(writeBlock(NAP_DOWNLOAD_REQ,m)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendDownloadRequest2(const char *user,
      const char *song)
{
   _lasterror=NAP_OK;

   if(!user || !song) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   QString m = QString(user) + " \"" + song + "\"";

   if(writeBlock(NAP_DOWNLOAD_REQ_NEW,m)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendIgnoreUser(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_ADDTOIGNORELIST_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendUnignoreUser(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_REMOVEFROMIGNORELIST_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendVersionRequest()
{
   _lasterror=NAP_OK;

   if(writeBlock(NAP_SERVERVERSION_REQ,"")==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendPingRequest(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_PING_REQ,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendPong(const char *name)
{
   _lasterror=NAP_OK;

   if(!name) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   if(writeBlock(NAP_PING_RESULT,name)==-1)
      _lasterror=NAP_NO_WRITE;
}
void NapsterConnection::sendKillUser(const char *user,const char *reason)
{
   _lasterror=NAP_OK;

   if(!user) 
   {
      _lasterror=NAP_BAD_SEND_DATA;
      return;
   }

   QString m = QString(user);
   if(reason) m =  m + " " + reason;

   if(writeBlock(NAP_KILL_USER,m)==-1)
      _lasterror=NAP_NO_WRITE;

}

void NapsterConnection::sendIncUploads()
{
   _lasterror=NAP_OK;

   if(writeBlock(NAP_UPLOAD_STARTED,"")==-1)
      _lasterror=NAP_NO_WRITE;

}
void NapsterConnection::sendIncDownloads()
{
   _lasterror=NAP_OK;

   if(writeBlock(NAP_DOWNLOAD_STARTED,"")==-1)
      _lasterror=NAP_NO_WRITE;

}
void NapsterConnection::sendDecUploads()
{
   _lasterror=NAP_OK;

   if(writeBlock(NAP_UPLOAD_FINISHED,"")==-1)
      _lasterror=NAP_NO_WRITE;

}
void NapsterConnection::sendDecDownloads()
{
   _lasterror=NAP_OK;

   if(writeBlock(NAP_DOWNLOAD_FINISHED,"")==-1)
      _lasterror=NAP_NO_WRITE;

}
