#ifndef KNAPSTER2_H
#define KNAPSTER2_H

//#include <qvariant.h>
#include <kmainwindow.h>
#include <kurl.h>
#include <qlist.h>
#include "napsterconnection.h"
#include <qdatetime.h>
//class QVBoxLayout; 
//class QHBoxLayout; 
//class QGridLayout; 
//class QButtonGroup;
//class QFrame;
//class QPushButton;
//class QTabWidget;
//class QWidgetStack;
//class QWidget;

class KRecentFilesAction;
class KAction;

class KNAP_ButtonTabbar;
class KNAP_TransferPanel;
class SongInfo;
class KNAP_Channellist;

class KNAP_Ping
{
  public:
     KNAP_Ping(const char *u)
     {
        user = u;
	time.start();
     }
     QString user;
     QTime time;
};

typedef QList<KNAP_Ping> PingList; 

//class NapsterConnection;

class Knapster2 : public KMainWindow
{
    Q_OBJECT
private slots:
    void menuConnect();
    void menuNapigator();
    void menuChannels();
    void menuCreateChannel();
    void menuPreferences();
    void menuRecent(const KURL &);

    void napsterMessage(NAPBLOCKPTR);
    void napsterClosed();
    void napsterTransferStarted(KSocket *sock,SongInfo *song,bool dload);

    void timerUpdate();

    void chatCommand(const char *);
public:
    Knapster2(const char* name = 0);
    ~Knapster2();
private:
    NapsterConnection *connection;
    
    KRecentFilesAction *recent;
    KAction *connmenu;
    
    KNAP_ButtonTabbar *MainFrame;

    bool processeddata;
    int timeoutcount;
    
    QWidget* tab_0;
    QWidget* tab_1;
    QWidget* tab_2;
    QWidget* tab_3;
    QWidget* tab_4;
    QWidget* tab_5;
    QWidget* tab_6;
    QWidget* tab_7;

    KNAP_TransferPanel *downloadpanel;
    KNAP_TransferPanel *uploadpanel;

    KNAP_Channellist *channellist;

    PingList pinglist;

    void setupMenus();
    void setupTabs();

    void showServerStats(NAPBLOCKPTR n);

    // after connection - this func is run
    void postConnect();

    void startDownload(SongInfo *si);
   
    void addPing(const char *u); 
    KNAP_Ping *findPing(const char *user);
    void processPing(const char *data);
    
    // parsing funcs

    SongInfo * parseSearchBuffer(char *buff);
    SongInfo * parseBrowseBuffer(char *buff);
    SongInfo * parseDownloadBuffer(char *buff);
    SongInfo * parseDownloadErrorBuffer(char *buff);
    SongInfo * parseRemoteQueueBuffer(char *buff);
};

#endif // KNAPSTER2_H
