#ifndef KNAP_PLAYLIST_H
#define KNAP_PLAYLIST_H

#include <qframe.h>

class KListBox;
class QListBoxItem;

class KNAP_PlayList
 : public QFrame
{
   Q_OBJECT
signals:
   void play(const char *song);
private slots:
   void removeCurrentItem();
   void setPlaylistPos(QListBoxItem *);
public slots:
   void addSong(const char *);
   void clearPlaylist();
   void savePlaylist(const char *);
   void loadPlaylist(const char *);

   void loadPlaylist();
   void savePlaylist();
   void addSong();
public:   
  KNAP_PlayList(QWidget *parent=0,const char *name=0);
  ~KNAP_PlayList();

   const char *getNextSong();
   const char *getPrevSong();
   const char *getCurrSong();

   void setSongPos(int p);
   int getSongPos() { return songpos; }
   void resetSongPos() { songpos=0; }
private:
  KListBox *list;
  int songpos;
};

#endif // KNAP_PLAYLIST_H

