#include "knap_playlist.h"
#include <klistbox.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kfiledialog.h>

#include <qfile.h>
#include <qtextstream.h>

#include <iostream>

#include "support_funcs.h"

KNAP_PlayList::KNAP_PlayList(QWidget *parent,const char *name)
   : QFrame(parent,name)
{
  songpos = 0;

   
  QGridLayout *grid;
  
  setFrameStyle( QFrame::Panel | QFrame::Sunken );

  grid = new QGridLayout(this,2,1,5,5);
  
  list = new KListBox(this,name);
  grid->addWidget(list,0,0);
  connect(list,SIGNAL( executed ( QListBoxItem *) ),
	this,SLOT(setPlaylistPos( QListBoxItem *) )); 

   // the controls
   QButtonGroup * control = new QButtonGroup( this, "control" );
   control->setTitle( "" /*i18n( ""  )*/ );
   control->setFrameShape( QButtonGroup::NoFrame );
   control->setColumnLayout(0, Qt::Vertical );
   control->layout()->setSpacing( 0 );
   control->layout()->setMargin( 0 );                                                 

   QHBoxLayout *controlLayout = new QHBoxLayout( control->layout() );
   controlLayout->setAlignment( Qt::AlignTop );
   controlLayout->setSpacing( 0 );
   controlLayout->setMargin( 0 );                                                     

   grid->addWidget(control,1,0);  

   QPushButton * addbtn = new QPushButton(i18n("Add"),control,"add");
   controlLayout->addWidget(addbtn);
   connect(addbtn,SIGNAL( clicked() ),this, SLOT( addSong() ));

   QPushButton * rembtn = new QPushButton(i18n("Remove"),control,"rem");
   controlLayout->addWidget(rembtn);
   connect(rembtn,SIGNAL( clicked() ),this, SLOT( removeCurrentItem() ));

   QPushButton * savebtn = new QPushButton(i18n("Save"),control,"save");
   controlLayout->addWidget(savebtn);
   connect(savebtn,SIGNAL( clicked() ),this, SLOT( savePlaylist() ));
   
   QPushButton * loadbtn = new QPushButton(i18n("Load"),control,"load");
   controlLayout->addWidget(loadbtn);
   connect(loadbtn,SIGNAL( clicked() ),this, SLOT( loadPlaylist() ));
   
   QPushButton * clearbtn = new QPushButton(i18n("Clear"),control,"clear");
   controlLayout->addWidget(clearbtn);
   connect(clearbtn,SIGNAL( clicked() ),this, SLOT( clearPlaylist() ));
}
KNAP_PlayList::~KNAP_PlayList()
{

}
void KNAP_PlayList::addSong(const char *song)
{
   cerr << "add song called " << song << endl;
  list->insertItem(song);
}
void KNAP_PlayList::clearPlaylist()
{
   list->clear();
   songpos = 0;
}
// TODO: this should actual save files as paths from this directory where possible
// ie: as relative to file
void KNAP_PlayList::savePlaylist(const char *filename)
{
   QFile f(filename);
   if ( f.open(IO_WriteOnly) ) 
   {    // file opened successfully
      QTextStream t( &f );        // use a text stream
      QString s;
      uint n = 0;
      while ( n < list->count() ) 
      {        // until end of file...
	 s = list->text(n);
	 t << s << endl;
	 n++;
      }
      f.close();
   }
}
void KNAP_PlayList::loadPlaylist(const char *filename)
{
   QFile f(filename);
   if ( f.open(IO_ReadOnly) ) 
   {  // file opened successfully
      QTextStream t( &f );        // use a text stream
      QString s;
      QString path = getFilePath(filename,true);
      int n = 1;
      while ( !t.eof() ) 
      {  // until end of file...
	 s = t.readLine();       // line of text excluding the '\n'

	 // if not a comment, we will add the file
	 if(s.length()>0 && s[0]!='#')
	 {
	   // add base to filename if it is required
	   if(s[0]!='/')
	   {
	     s = makeFullFilePath(path,s);
	   }
	   addSong(s);
	 }
      }
      f.close();
   }
}
void KNAP_PlayList::removeCurrentItem()
{
   int i = list->currentItem();
   if(i!=-1) 
   {
      list->removeItem(i);

      if(i<songpos) songpos--;
   }
}
const char * KNAP_PlayList::getNextSong()
{
   if(songpos<(int)list->count()) songpos++;

   if(songpos==list->count()) return 0;

   return getCurrSong();
}

const char * KNAP_PlayList::getPrevSong()
{
   if(songpos>=0) songpos--;
   if(songpos==-1) return 0; // end of prevs

   return getCurrSong();
}
const char * KNAP_PlayList::getCurrSong()
{
   static QString item; 
   item = list->text(songpos);
   if(item.isNull()) return 0;

   return item.ascii();
}
void KNAP_PlayList::setSongPos(int p)
{
   if(p<-1) p = -1;
   if(p>(int)list->count()) p = (int)list->count();

   songpos = p;
}

void KNAP_PlayList::loadPlaylist()
{
   QString name = KFileDialog::getOpenFileName("::KNAP_Playlist", /*QString::null,*/
	 "*.m3u",this,i18n("Load Playlist"));
   if(name.isNull()==false)
      loadPlaylist(name);
}
void KNAP_PlayList::savePlaylist()
{
   QString name = KFileDialog::getSaveFileName("::KNAP_Playlist", /*QString::null,*/
	 "*.m3u",this,i18n("Save Playlist"));
   if(name.isNull()==false)
      savePlaylist(name);
}
void KNAP_PlayList::addSong()
{
   QStringList names = KFileDialog::getOpenFileNames("::KNAP_Playlist", /*QString::null,*/
	 "*.mp3",this,i18n("Add Files"));

   for ( QStringList::Iterator it = names.begin(); it != names.end(); ++it ) 
   {
      addSong((*it).ascii()); 
   }
   return;
}

void KNAP_PlayList::setPlaylistPos(QListBoxItem *item)
{
  if(!item) return;
  int p = list->index(item);
  
  setSongPos(p);

  const char *s = getCurrSong();

  if(s) emit play(s);
}
