#include <klocale.h>
#include <kapp.h>

#include "knap_connectdlg.h"
#include "napsterconnection.h"
#include "support_funcs.h"

#include <qframe.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "knap_preferences.h"

#include <iostream>

/* 
 *  Constructs a KNAP_ConnectDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 *
 *  NOTE: this assumes that valid data has been entered in prefs.
 */
KNAP_ConnectDlg::KNAP_ConnectDlg( const SongList &songs,const QStringList &hotlistusers,
      QWidget* parent, const char* name,const char *besthost)

 : QDialog( parent, name, true ), EZThread()
{
    status = STAT_CONNECTING;
    started = false;

//    prefs = KNAP_Preferences::getPreferences();
    
    connection = new NapsterConnection(parent);

    if(connection==0)
    {
      cerr <<"KNAP_ConnectDlg::KNAP_ConnectDlg(): NO MEM!!!\n";
    }
    
    cerr <<"KNAP_ConnectDlg::KNAP_ConnectDlg(): " << besthost << endl;
    if(besthost) connection->parseBestHostString(besthost);
    cerr <<"KNAP_ConnectDlg::KNAP_ConnectDlg(): continues\n";

    songlist = songs;
    songs_sent = 0;
 
    hotlist = hotlistusers;
    
    if ( !name )
	setName( "KNAP_ConnectDlg" );
    resize( 337, 170 ); 
    setCaption( i18n( "Connecting"  ) );

    KNAP_ConnectDlgLayout = new QGridLayout( this ); 
    KNAP_ConnectDlgLayout->setSpacing( 6 );
    KNAP_ConnectDlgLayout->setMargin( 11 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, 
	  QSizePolicy::Minimum, QSizePolicy::Expanding );
    KNAP_ConnectDlgLayout->addItem( spacer, 3, 2 );

    statustext = new QLabel( this, "statustext" );
    statustext->setText( i18n( "Connecting ..."  ) );
    statustext->setFrameShape( QLabel::WinPanel );
    statustext->setFrameShadow( QLabel::Sunken );

    KNAP_ConnectDlgLayout->addMultiCellWidget( statustext, 0, 0, 0, 3 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, 
	  QSizePolicy::Expanding, QSizePolicy::Minimum );
    KNAP_ConnectDlgLayout->addItem( spacer_2, 5, 0 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, 
	  QSizePolicy::Expanding, QSizePolicy::Minimum );
    KNAP_ConnectDlgLayout->addItem( spacer_3, 5, 3 );

    progressbar = new QProgressBar( this, "progressbar" );
    progressbar->setProgress( 0 );
    progressbar->setIndicatorFollowsStyle( FALSE );
    progressbar->setCenterIndicator( TRUE );
    progressbar->setFrameShape( QProgressBar::Panel );
    progressbar->setFrameShadow( QProgressBar::Sunken );

    KNAP_ConnectDlgLayout->addMultiCellWidget( progressbar, 2, 2, 0, 3 );

    cancelbtn = new QPushButton( this, "cancelbtn" );
    cancelbtn->setText( i18n( "&Cancel"  ) );
    cancelbtn->setDefault( TRUE );

    KNAP_ConnectDlgLayout->addMultiCellWidget( cancelbtn, 5, 5, 1, 2 );

    QFrame* line = new QFrame( this, "line" );
    line->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    KNAP_ConnectDlgLayout->addMultiCellWidget( line, 4, 4, 0, 3 );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, 
	  QSizePolicy::Minimum, QSizePolicy::Expanding );
    KNAP_ConnectDlgLayout->addItem( spacer_4, 1, 1 );

    // signals and slots connections
    connect( cancelbtn, SIGNAL( clicked() ), this, SLOT( reject() ) );

    // set up timer for checking status
  QTimer *timer=new QTimer(this);
  if(timer) 
  {
     connect(timer,SIGNAL(timeout()),this,SLOT(timeout()));

     timer->start(750); // update every 3/4 second
  }
  
  // TODO list of names or a list of songs?
  //songlist = jhjkg

  kapp->processEvents(5000);

  cerr << "KNAP_ConnectDlg::KNAP_ConnectDlg(): completed\n";
    run();
}
void KNAP_ConnectDlg::show()
{
   cerr << "KNAP_ConnectDlg::show()\n";
//   run();
   cerr << "KNAP_ConnectDlg::show() after run()\n";
//   kapp->processEvents(5000);
//   sleep(2);
   QDialog::show();
   cerr << "KNAP_ConnectDlg::show() ended\n";
//   sleep(2);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KNAP_ConnectDlg::~KNAP_ConnectDlg()
{
    // no need to delete child widgets, Qt does it all for us
   kill();

   down();
     // delete connection if it was not taken.
     if(connection) delete connection;
   up();
}

void KNAP_ConnectDlg::showEvent(QShowEvent *ev)
{
  cerr << " KNAP_ConnectDlg::showEvent(): ...\n"; 
//  if(ev->spontaneous()) cerr << " KNAP_ConnectDlg::showEvent(): Spontanius****\n";
  QDialog::showEvent(ev);

//  run();
}

void KNAP_ConnectDlg::run_method()
{
// sleep(5); // delay a little

 QString server = "server.napster.com";
 
 if(connection->haveBestHost()==false)
 {  
down();    
   status = STAT_FINDINGBESTHOST;
up();   
   cerr << "finding best host...\n";
 
   //if(connection->getBestHost("server.napster.com")==false)
   if(prefs.server != "") server = prefs.server;
   else server="server.napster.com";

   if(connection->getBestHost(server)==false)
   {
     cerr << "couldnt get best host\n"; 
down();
     status = STAT_NOBESTHOST;
up();
     return;
   }
 }
// connection->parseBestHostString("192.168.0.2:8888");
 
 cerr<<"connection to server...\n";
down();
 status = STAT_CONNECTING;
up();

 int port = 6699;
 if(prefs.port>=0) port = prefs.port;

 if(prefs.firewall==true) port = 0;
 
 if(connection->open(port)==false)
 {
    cerr << "couldnt connect\n"; 
down();
    status = STAT_NOCONNECT;
up();
    return;
 }
down(); 
 status = STAT_LOGGINGON;
up();
 cerr <<"logging on\n";

 if(!connection->login(prefs.username,prefs.password,prefs.email,prefs.connectionspeed,prefs.newuser)) 
 {
down();
    status = STAT_NOLOGON;
up();
    cerr << "no logon :(\n";
    return;
 } 
 cerr << "sendig shared files\n";
down();
 status = STAT_SENDINGSHARES;
up();
 SongInfo song; 
 cerr << "numsongs = " << songlist.count() << endl;
 
 SongList::Iterator it;
 for( it = songlist.begin(); it != songlist.end(); ++it )
 {
    song = (*it);
    //song->loadMD5();  // only load md5 if shared
    song.filename = toDosName(song.filename);

    if(song.shared) 
    {
       connection->share(&song);

       cerr << "sending song: " << song.filename << endl;
    }
 }

 // send hotlist
 cerr << "sending hotlist\n";
down();
 status = STAT_SENDINGHOTLIST;
up();
 for( QStringList::Iterator it = hotlist.begin(); it != hotlist.end(); ++it )
 {
    connection->sendHotlistUser(*it);
 }
 cerr << "finished login process\n";
 // now send the share list :)
down();
 status = STAT_DONE;
up(); 
}
void KNAP_ConnectDlg::timeout()
{
   int maxallowed =0; 
   int minallowed =0; 
   QString ext_error="";
   Status s;
  
   if(!started)
   {
     cerr << "Starting thread now...\n"; 
     started = true;
     //run();
     return;
   }
   
   down();
    s = status;
    if(connection) ext_error = connection->getLastErrorStr();
   up();
   
   if(!progressbar || !statustext) return;
   
   switch(s)
   {
      case STAT_FINDINGBESTHOST:
	 statustext->setText(i18n("Finding best host..."));
	 maxallowed = 20;
	 minallowed = 0;
	 break;	
      case STAT_CONNECTING:
	 statustext->setText(i18n("Connecting to server..."));
	 maxallowed = 35;
	 minallowed = 20;
	 break;	
      case STAT_LOGGINGON:
	 statustext->setText(i18n("Logging on to server..."));
	 maxallowed = 50;
	 minallowed = 35;
	 break;	

      case STAT_SENDINGSHARES:
	 statustext->setText(i18n("Sending shared files list..."));
	 maxallowed = 90;
	 minallowed = 50;

	 // we have 50% to play with
	 minallowed = 50 + (int)(40.0 * songs_sent / songlist.count());

	 break;
      case STAT_SENDINGHOTLIST:
	 statustext->setText(i18n("Sending hotlist..."));
	 maxallowed = 100;
	 minallowed = 90;
	 break;
      case STAT_DONE:
	 // everything done ... close dialog
	 maxallowed = 100;
	 minallowed = 100;
	 close();
	 break;


      case STAT_NOBESTHOST:
	 statustext->setText(i18n("Error: couldnt get best host"));
	 return;
	 break; 
      case STAT_NOCONNECT:
	 if(ext_error.length()>0)
	 {
            ext_error = "Error: " + ext_error;
	 }
	 else 
	    ext_error = i18n("Error: couldnt connect to server");
	 statustext->setText(ext_error);
	 return;
	 break; 
      case STAT_NOLOGON:
         if(ext_error.length()>0)
         {
             ext_error = "Error: " + ext_error;
         }
         else   
	    ext_error = i18n("Error: couldnt logon to server");
	 
	 statustext->setText(ext_error);
	 return;
	 break; 

      default:
	 break;
   }

   if(progressbar->progress()<minallowed)
      progressbar->setProgress(minallowed);
   else if((s != STAT_SENDINGSHARES) && progressbar->progress()<maxallowed) 
      progressbar->setProgress(progressbar->progress()+1);

}
/*
 * canncelconnect()
 * delete the socket
 */

NapsterConnection *KNAP_ConnectDlg::getConnection()
{
   NapsterConnection *temp=0;

   down();

   if(connection!=0 && connection->isOpen() && status == STAT_DONE) 
   {
      // we have the connection - take from here
      temp = connection;
      connection = 0;

      // we connected - was it also a new connection?
      if(prefs.newuser == true)
      {
        prefs.newuser = false;
	prefs.save();
      }
   }
   up();

   return temp;
}
