/***************************************************************************
                          songinfo.h  -  description
                             -------------------
    begin                : Wed Dec 8 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SONGINFO_H
#define SONGINFO_H

#include <qstring.h>

/**
  *@author John Donoghue
  */

class NapsterTransfer;
class KSocket;

class SongInfo
{
public:
  QString filename;
  QString md5;
  long size;
  int bitrate;
  int freq;
  long songnum;
  QString user;
  unsigned long ip;
  int port;

  unsigned long seconds;

  bool shared;

  int speed;

  long read;
  long rate;
  long status;
  long bps;

  // ignore messages about this song
  bool ignore;

  NapsterTransfer *dload;
public:
  static SongInfo *loadSongInfo(const char *name,bool getall=false);

	SongInfo(const char *filename="",const char *id="",long size=0,int bitrate=0,int freq=0,
       long snum=0,const char *user="",unsigned long ip=0,int port=0,int speed=0);
	~SongInfo();

  // need copy/=
  SongInfo(const SongInfo &s);
  // SongInfo & operator(SongInfo &);
};

#endif