/***************************************************************************
                          napsterupload.cpp  -  description
                             -------------------
    begin                : Fri Feb 4 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napsterupload.h"

#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <arpa/tftp.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/un.h>

#include <signal.h>

#include <stdio.h>
#include <stdlib.h>


#include <qfile.h>

#include <iostream.h>

NapsterUpload::NapsterUpload(long ip,int port,const char *filename,const char *user,
         int speed,const char *dest)
: NapsterTransfer(ip,port,filename,user,speed,dest)
{
}

NapsterUpload::~NapsterUpload()
{
//  if(_file!=-1) close(_file);
  if(_sock!=-1) close(_sock);
}

bool NapsterUpload::start(int _listen,long sz)
{
  // set that we are initialising
   _status=DL_INIT;

  // create the thread and start us up
  _sock=_listen;

  // no lock needed yet - not threaded yet
  _readsize=sz;

#ifdef DEBUG_1
  cerr<<"$$$$$$$$$$$$$$$ created thread for "<<_filename<<endl<<flush;
#endif
  // sleep(1)

  pthread_create(&_id,NULL,thread_task,(void *)this);

  return true;
}

void *NapsterUpload::thread_task(NapsterUpload *ul)
{
  QFile file;
  QString tmp;
  int sz;

#ifdef DEBUG_1
  cerr<<"starting upload thread\n"<<flush;
#endif
  if(!ul) return NULL;

  ul->down();
    ul->_status=DL_INIT;
  ul->up();

  // open the file
  file.setName(ul->_filename);
  file.open(IO_ReadOnly);

  if(!file.isOpen()) {

     send(ul->_sock,"FILE NOT FOUND",14,0);

     ul->down();
       ul->_status=DL_NOLOCALFILE;
     ul->up();
//     close(_sock);
     return NULL;
  }
  // go to asked place
  file.at(ul->_readsize);

  ul->down();
    ul->_totalsize=file.size();
  ul->up();

  #ifdef DEBUG_1
     cerr<<"sending file size "<<ul->_totalsize<<endl<<flush;
  #endif

  tmp = QString().setNum(ul->_totalsize);

  send(ul->_sock,tmp,tmp.length(),0);

  ul->down();
    ul->_status=DL_DOWNLOADING;
    time(&ul->_starttime); // set the start time
  ul->up();

//  if(!ul || !dl->init()) {
//    if(dl) {
//        dl->down();
//          dl->_status=DL_NOCONNECT;
//        dl->up();
//    }
//#ifdef DEBUG_1
//    cerr<<"init error\n"<<flush;
//#endif
//    return NULL;
//  }

//??????????????????????????????????

  while(!ul->_terminate && !file.atEnd())
  {
    // read file and send data         if() return false;

      sz = file.readBlock(ul->_buffer,1024);
      if(sz>0) {
         ul->down();
             ul->_readsize+=sz;
         ul->up();
         send(ul->_sock,ul->_buffer,sz,0);
      }
  }

  if(ul->_sock!=-1) close(ul->_sock);

  ul->_sock=-1;

  ul->down();
    if(ul->_terminate) ul->_status=DL_KILLED;
    else if(ul->_status==DL_NOLOCALFILE) {} // error has been set already
    else if (ul->_readsize>=ul->_totalsize) ul->_status=DL_FINISHED;
    else  ul->_status=DL_ERROR;    // only partial upload????
  ul->up();

#ifdef DEBUG_1
  cerr<<"finished upload thread\n"<<flush;
#endif

//******************
// done in delete
// _msgsock=-1;

  return NULL;
}
