/***************************************************************************
                          knapter_cmd.cpp  -  description
                             -------------------
    begin                : Sat Jan 15 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/** the startConsoleCommand for console commands enetered in the cmd box
   of the cmd window.

   ** seperated to here to keep file sizes smaller
*/


#include "knapster.h"
#include "consolepanel.h"
//#include "searchpanel.h"
#include "support_funcs.h"
#include "propertiesdlg.h"


#include <qdatetime.h>

#include <cstring>

void Knapster::startConsoleCommand(const char *str)
{

  if(strncmp(str,"/clear",5)==0) {
    //str+=5;
    console->clear();
    return;
  }
  else if(strncmp(str,"/help",5)==0) {
    writeConsole("Commands are: ");
    writeConsole(" /clear : clear the console\n");
    writeConsole(" /version : get the server version\n");

    writeConsole(" /msg <user> <message>: send a message to a user");

    writeConsole(" /ping <user> : ping a user");
    writeConsole(" /whois <user> : get info about a user\n");

    writeConsole(" /list        : list the available channels");
    writeConsole(" /join <chan> : join the channel");
    writeConsole(" /part <chan> : leave the channel");
    writeConsole(" /chan <chan> <msg> : send a message to a channel");
    writeConsole(" /users <chan>: list the users on channel <chan>");


    return;
  }

  if(!connection.isConnected()) {
    writeConsole("Unable to run command - Not connected");
    return;
  }

  if(strncmp(str,"/whois",6)==0) {
    str+=6;
    sendWhois(str);
  }
  else if(strncmp(str,"/version",8)==0) {
    connection.version();
  }

  else if(strncmp(str,"/ping",5)==0) {
    str+=5;
    while(*str==' ') str++;
    addPingItem(str);
  }
  else if(strncmp(str,"/join",5)==0) {
    str+=5;
    connection.join(str);
  }
  else if(strncmp(str,"/part",5)==0) {
    str+=5;
    connection.part(str);
  }
  else if(strncmp(str,"/list",5)==0) {
    connection.list();
    writeConsole("Listing channels...");
  }
  else if(strncmp(str,"/msg",4)==0) {
    str+=4;
    QString work,user,msg;

    work=str;

    user=extractString(work);
    msg=work;

    if(!msg.isNull()) {
      connection.sendUserMessage(user,msg);
    }
  }
  else if(strncmp(str,"/users",6)==0) {
    str+=6;
    writeConsole("Listing users...");
    connection.users(str);
  }
  else if(strncmp(str,"/chan",5)==0) {
    str+=5;
    QString work,chan,msg;

    work=str;

    chan=extractString(work);
    msg=work;

    if(!msg.isNull()) {
      connection.sendChanMessage(chan,msg);
    }
  }

#ifdef DEBUG_3
  // for testing and working out what to send
  else if(strncmp(str,"/raw ",5)==0) {
    str+=5;
    writeConsole(QString("** sending ") +str);
    int val;
    val=atoi(str);
    while(*str!=' ' && *str!='\0') str++;
    if(*str==' ') str++;
    cerr<<"TEST: val is: "<<val<<" test: "<<str<<endl<<flush;
    connection.writeBlock(val,str,strlen(str));
  }
#endif
  else {
    writeConsole(QString("Unknown cmd given: ") + str );
  }
  return;
}


// parse a search block data for the song info and create a temp SOngInfo from it
// returns NULL on an invalid one
SongInfo * Knapster::parseSearchBuffer(char *buff)
{
  static SongInfo si;

  QString tmp;
  QString work=buff;

  si.filename=extractString(work);
  si.md5=extractString(work);
  tmp=extractString(work);
  if(!tmp.isNull()) si.size=atol(tmp);

  tmp=extractString(work);
  if(!tmp.isNull()) si.bitrate=atoi(tmp);
  tmp=extractString(work);
  if(!tmp.isNull()) si.freq=atoi(tmp);
  tmp=extractString(work);
  if(!tmp.isNull()) si.songnum=atol(tmp);

  si.user=extractString(work);
  tmp=extractString(work);
  if(!tmp.isNull()) si.ip=atol(tmp);
  tmp=extractString(work);
  if(!tmp.isNull()) si.speed=atoi(tmp);

  if(tmp.isNull()) return NULL; //warped data???


  return &si;
}

// parse a browse block data for the song info and create a temp SOngInfo from it
// returns NULL on an invalid one
SongInfo * Knapster::parseBrowseBuffer(char *buff)
{
  static SongInfo si;

  QString tmp;
  QString work=buff;

  si.user=extractString(work);
  si.filename=extractString(work);
  si.md5=extractString(work);

  tmp=extractString(work);
  if(!tmp.isNull()) si.size=atol(tmp);

  tmp=extractString(work);
  if(!tmp.isNull()) si.bitrate=atoi(tmp);
  tmp=extractString(work);
  if(!tmp.isNull()) si.freq=atoi(tmp);

  tmp=extractString(work);
  if(!tmp.isNull()) si.songnum=atol(tmp);

  if(tmp.isNull()) return NULL; //warped data???

  return &si;
}

// parse a browse block data for the song info and create a temp SOngInfo from it
// returns NULL on an invalid one
SongInfo * Knapster::parseDownloadBuffer(char *buff)
{
  static SongInfo si;

  QString tmp;
  QString work=buff;

  si.user=extractString(work);
  tmp=extractString(work);
  if(!tmp.isNull()) si.ip=atol(tmp);
  tmp=extractString(work);
  if(!tmp.isNull()) si.port=atoi(tmp);

  si.filename=extractString(work);

  si.md5=extractString(work);

  tmp=extractString(work);
  if(!tmp.isNull()) si.speed=atoi(tmp);

  if(tmp.isNull()) return NULL; //warped data???

  return &si;
}

// parse a remote queue block data for the song info and create a temp
//SOngInfo from it
// returns NULL on an invalid one
SongInfo * Knapster::parseRemoteQueueBuffer(char *buff)
{
  static SongInfo si;

  QString tmp;
  QString work=buff;

  si.user=extractString(work);
  si.filename=extractString(work);

  tmp=extractString(work);
  if(!tmp.isNull()) si.speed=atoi(tmp);

// digit ??? - what is it from

//  tmp=extractString(work);
//  if(!tmp.isNull()) si.port=atoi(tmp);
  if(tmp.isNull()) return NULL; //warped data???

  return &si;
}


void Knapster::processWhoisResult(char *data)
{

  QString tmp;
  QString work=data;

  tmp=extractString(work);
  writeConsole(QString("Username:   ") + tmp);

  tmp=extractString(work);
  writeConsole(QString(" Class:     ") + tmp);

  tmp=extractString(work);
  // time in seconds that the user has been on
  tmp=convertSecondsToDurationString(tmp.toLong());
  writeConsole(" Logged on for: " + tmp);

  tmp=extractString(work);
  writeConsole(QString(" Channels:  ") + tmp);

  tmp=extractString(work);
  writeConsole(QString(" Status:    ") + tmp);

  tmp=extractString(work);
  writeConsole(QString(" shared:    ") + tmp);

  tmp=extractString(work);
  writeConsole(QString(" downloads: ") + tmp);

  tmp=extractString(work);
  writeConsole(QString(" uploads:   ") + tmp);

  tmp=extractString(work);
  if(!tmp.isNull()) {
    int v=atoi(tmp);
    writeConsole(QString(" Speed:   ") + convertSpeed(v));
  }
  tmp=extractString(work);
  writeConsole(QString(" client:    ") + tmp);

  return;
}

void Knapster::processWhoisOffline(char *data)
{

  QString tmp;
  QString work=data;

  tmp=extractString(work);
  writeConsole(QString("Username:   ") + tmp);

  tmp=extractString(work);
  writeConsole(QString(" Class:      ") + tmp);


  // last logon
  tmp=extractString(work);

  unsigned int s = tmp.toLong(); // assume time_t is a uint at the moment
  QDateTime lastlogon;

  lastlogon.setTime_t(s);

  writeConsole(" Last logged on: " + lastlogon.toString() );

  writeConsole(QString(" Status:     Offline"));

  return;
}

void Knapster::processChanMessage(char *data)
{

  QString chan,user;
  QString work=data;

  chan=extractString(work);
  user=extractString(work);

  writeConsole(QString("[") + chan + "] " + user + " said: " + work);

  return;
}
void Knapster::processChanUserJoined(char *data)
{

  QString chan,user;
  QString work=data;

  chan=extractString(work);
  user=extractString(work);

  writeConsole(QString("[") + chan + "] " + user + " has joined - " + work);

  return;
}
void Knapster::processChanUserLeft(char *data)
{

  QString chan,user;
  QString work=data;

  chan=extractString(work);
  user=extractString(work);

  writeConsole(QString("[") + chan + "] " + user + " has left -" + work);

  return;
}

void Knapster::processUserMessage(char *data)
{

  QString user;
  QString work=data;

  user=extractString(work);

  writeConsole(user + " said: " + work);

  return;
}

// convert s seconds into a duration - take into account minutes
// and hours and create a string as appropriate
QString Knapster::convertSecondsToDurationString(long s)
{
  QString str;

  str= QString().setNum(s%60) + "s";
  if(s) {
    s/=60;
    if(s) {
       str= QString().setNum(s%60) + "m :" + str;
       s/=60;
    }
    if(s) {
       str= QString().setNum(s) + "h, " + str;
    }
  }

  return str;
}
void Knapster::processUploadRequest(char *data)
{
  // tell them to connect ( if we have enough connections to let them )
  Preferences p = PropertiesDlg::readPrefs();

  int i=strlen(data);

  if(uploadlist.count()<p.maxuploads || p.maxuploads==0)
      connection.writeBlock(NAP_UPLOAD_ALLOWED,data,i);
  else // not allowed
      connection.writeBlock(NAP_UPLOAD_ALLOWED+1,data,i); //????????????

  return;
}


void Knapster::processPingResult(char *data)
{

  PingItem *pi;
  int ms;

  for(pi=pinglist.first();pi!=NULL;pi=pinglist.next()) {
    if(pi->user.find(data)==0) {

        // found -> print and remove
        ms=pi->time.msecsTo(QTime::currentTime());

        writeConsole("Pingtime for " + pi->user + " was "
            + QString().setNum(ms) + " ms" );

        pinglist.remove(pi);

        break;
    }
  }
  // what about pings that never come back????

}
void Knapster::addPingItem(const char *user)
{
   writeConsole(QString("Pinging user ") + user );
   pinglist.append(new PingItem(user));
   connection.ping(user);
}
void Knapster::sendWhois(const char *user)
{
   writeConsole(QString("Whois user...") + user);
   connection.whois(user);
}