/***************************************************************************
                          searchpanel.h  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEARCHPANEL_H
#define SEARCHPANEL_H

#include <qwidget.h>

class ExtComboBox;
class QComboBox;
class QLineEdit;
class QListView;
class QListViewItem;
class QPoint;
class KSocket;
class QPopupMenu;
class QPushButton;

class SongInfo;

/**the search panel, including the  results list and the search type etc.

  *@author John Donoghue
  */

class SearchPanel : public QWidget  {
   Q_OBJECT

signals:
  // signal for return pressed in thye search text box
  void search(int,const char *);
  // signal for selection of download from popup menu
  void download(QListViewItem *);
  // signal when ping selected from popup
  void ping(const char *);
  void whois(const char *);
public slots:
  // clear the listview
  void clearSearch();

private slots:
  // internal slots
  void calcSearch();
  void popupSearch ( QListViewItem *, const QPoint &, int );
  void popupSearchDownload();

  void popupPing();
  void popupWhois();

  void popupShowPath();

  void searchComboActivated(int);
  void optionComboActivated(int);
public: 
	SearchPanel(QWidget *parent=0, const char *name=0);
	virtual ~SearchPanel();

  void addSearchItem(SongInfo *song /*,bool showsearchpath=false*/);

  bool showSearchPath() const;
  void setShowSearchPath(bool yes);
  void setMultiSelect(bool yes);
private:
  void setExtraOptionsEnabled(bool enable);
  QComboBox *createCompareValueCB(const char *name);

private:
  QPopupMenu *searchpopupmenu;
//  QLineEdit *searchtext;
//  QComboBox *searchtext;
  ExtComboBox *searchtext;

  QComboBox *searchoption;
  QListView *searchlistview;
  QPushButton *searchbutton;

  QComboBox *speedoption;
  QComboBox *speedtext;

  QComboBox *bitrateoption;
  QComboBox *bitratetext;

  QComboBox *freqoption;
  QComboBox *freqtext;

  QLineEdit *resultstext;

  bool showsearchpath;
  bool multiselect;
};

#endif
