/***************************************************************************
                          librarypanel.h  -  description
                             -------------------
    begin                : Wed Jan 26 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LIBRARYPANEL_H
#define LIBRARYPANEL_H

#include <qwidget.h>

class QListView;
class QListViewItem;
class QPoint;
class QLabel;
class QPopupMenu;
class SongInfo;

/**the mp3 library panel for the mp3 library tab
  *@author John Donoghue
  */

class LibraryPanel : public QWidget
{
   Q_OBJECT

signals:
  void play(const char *);
  void rescan();

private slots:
  void popupMenu( QListViewItem *, const QPoint &, int);
  void popupPlay();
  void buttonRescan();

public slots:
  // clear the listview
  void clear();

public: 
	LibraryPanel(QWidget *parent=0, const char *name=0);
	virtual ~LibraryPanel();

  int addDir(const char *name,bool shared=false,int depth=1);
//   addFile(name);
// removeFile
  bool showLibraryPath() const;
  void setShowLibraryPath(bool yes);

  SongInfo *findSongInfo(const char *name, bool getall=false);

  SongInfo *getSong(int v);

  QStrList getAllSongNames();

private:
  void addItem(const QString &name,int bitrate,int freq,long size,bool shared);
private:
  QListView *sharedlistview;
  QPopupMenu *sharedpopupmenu;
  QLabel *stats;

  bool showsharedpath;
  int sharedcount;

  double totalgig;

};

#endif