/***************************************************************************
                          librarypanel.cpp  -  description
                             -------------------
    begin                : Wed Jan 26 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "librarypanel.h"
#include "support_funcs.h"

#include <qlistview.h>
#include <qlayout.h>
#include <qpopupmenu.h>
#include <qlabel.h>
#include <kapp.h>
#include <qpushbutton.h>
#include <qregexp.h>
#ifdef KDE2
#include <klocale.h>
#endif /* KDE2 */

//#include "searchpanel.h"
#include "songinfo.h"



#include <iostream.h>

#include <qdir.h>
#include <qfile.h>

LibraryPanel::LibraryPanel(QWidget *parent, const char *name )
: QWidget(parent,name)
{
  showsharedpath=false;
  sharedcount=0;
  totalgig = 0.0;

  QGridLayout *grid=new QGridLayout(this,2,2,5,5);

  stats=new QLabel("",this,"stats");
  grid->addWidget(stats,0,0);

  QPushButton *rescanbutton=new QPushButton(i18n("Rescan"),this,"rescanbutton");
  rescanbutton->setMaximumSize( rescanbutton->sizeHint() );
  connect(rescanbutton,SIGNAL(clicked()),this,SLOT(buttonRescan()));
  grid->addWidget(rescanbutton,0,1);

  sharedlistview=new QListView(this);
  sharedlistview->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  grid->addMultiCellWidget(sharedlistview,1,1,0,1);

  sharedlistview->addColumn(i18n("file"),200);
  sharedlistview->setColumnWidthMode(0,QListView::Manual);

  sharedlistview->addColumn(i18n("bitrate"),80);
  sharedlistview->setColumnWidthMode(1,QListView::Manual);
  sharedlistview->addColumn(i18n("frequency"),80);
  sharedlistview->setColumnWidthMode(2,QListView::Manual);
  sharedlistview->addColumn(i18n("size"),80);
  sharedlistview->setColumnWidthMode(3,QListView::Manual);
  sharedlistview->addColumn(i18n("shared"),80);
  sharedlistview->setColumnWidthMode(4,QListView::Manual);

  // create the popup menu for the downloadlist view
  sharedpopupmenu=new QPopupMenu();
  if(sharedpopupmenu) {
    sharedpopupmenu->insertItem(i18n("Play/Stop"),this,SLOT(popupPlay())) ;
  }
  connect(sharedlistview,SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
       this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));

}

LibraryPanel::~LibraryPanel()
{
// if sharedpopupmenu
}

void LibraryPanel::popupPlay()
{
  QListViewItem *selecteditem=sharedlistview->currentItem();

  if(selecteditem) {
     QString filename = selecteditem->text(0);
     filename.replace(QRegExp("~"),QDir::homeDirPath());
     emit play(filename.data());   //--- FULL PATHNAME
  }
}
void LibraryPanel::clear()
{
  sharedlistview->clear();
  sharedcount=0;
  totalgig = 0.0;
}

void LibraryPanel::popupMenu( QListViewItem *i, const QPoint &pos, int col)
{
  /* select the item we are currently over */


  QListViewItem *selecteditem=i; //sharedlistview->itemAt(pos);
  //currentItem();
  if(sharedpopupmenu && selecteditem) {
     sharedlistview->setSelected(selecteditem,true);
     sharedpopupmenu->exec(QCursor::pos());
  }
}

void LibraryPanel::addItem(const QString &name,int bitrate,int freq,long size,bool shared)
{
  QString s_filename;
  char buffer[30];

  if(!showsharedpath) s_filename=getFileName(name);
  else  s_filename=name;
  s_filename.replace(QRegExp(QDir::homeDirPath()),"~"); 

  QListViewItem *i;

  // put the item in the listview
  // field 6 is invisible & holds the FULL path name of the song

  i=new QListViewItem(sharedlistview,
        s_filename,
        QString().setNum(bitrate),
        QString().setNum(freq),
        convertSize(size),
        shared == true ? "Yes" : "No",
        name);

  if(shared) sharedcount++;

  totalgig += ((double)size/(1024.0*1024.0*1024.0));

  sprintf(buffer,i18n("%.2f Gig"),totalgig);

  QString statstr;
  statstr.sprintf(i18n(" total: %d songs, %d shared, %s"),
	sharedlistview->childCount(),sharedcount,buffer);

  stats->setText(statstr);

  return;
}


// find the song if it exists in the list and return some info
//
SongInfo *LibraryPanel::findSongInfo(const char *fname, bool getall)
{
  static SongInfo asong;

  QListViewItem *it=sharedlistview->firstChild();

  while(it) {
     if(strcmp(fname,it->text(0))==0) {
       // found it
       if(!getall) {
         asong.filename=fname;
         asong.bitrate = QString(it->text(1)).toInt();
         asong.freq = QString(it->text(2)).toInt();
         asong.size = QString(it->text(3)).toLong();

         if(strcmp(it->text(4),"Yes")==0) asong.shared=true;
         else asong.shared=false;

         return &asong;
       }
       else { // load it in
          SongInfo *nsong = SongInfo::loadSongInfo(fname,true);
          if(nsong) {
             if(strcmp(it->text(4),"Yes")==0) nsong->shared=true;
             else nsong->shared=false;
          }
          return nsong;
       }
     }
     it=it->nextSibling();
  }
  return NULL;
}
int LibraryPanel::addDir(const char *name,bool shared,int depth)
{
  if(!name) return 0;
  SongInfo *si;
  QDir dir;
  int cnt=0;

  dir.setPath(name);
  if(!dir.exists()) return 0;

#ifdef DEBUG_2
        cout<<"enter dir: "<<name<<" depth was "<<depth<<endl;
#endif

  dir.setFilter( QDir::Dirs | QDir::Files | QDir::NoSymLinks | QDir::Readable );
  dir.setNameFilter("*.mp3");
  dir.setMatchAllDirs(true);

  const QFileInfoList *list = dir.entryInfoList();
  QFileInfoListIterator it( *list );      // create list iterator
  QFileInfo *fi;                          // pointer for traversing

  while ( (fi=it.current()) ) {           // for each file...

    // this may take a while so allow events to continue
    kapp->processEvents(500);

    if(fi->isDir()) {
      // if its not a .. and we want to enter this dir - do it
      if(depth!=1 && fi->fileName()!="." && fi->fileName()!="..") {
        cnt += addDir(fi->absFilePath(),shared,(depth == 0 ? 0 : depth-1));
      }
    }
    else {
      si=findSongInfo(fi->absFilePath());
      if(si==NULL) {
        si=SongInfo::loadSongInfo(fi->absFilePath());
        if(si) {
          addItem(fi->absFilePath(),si->bitrate,si->freq,si->size,shared);
          cnt++;
        }
      }
    }
    ++it;                               // goto next list element
  }

  return cnt;
}

void LibraryPanel::buttonRescan()
{
  emit rescan();
}

SongInfo *LibraryPanel::getSong(int v)
{
  SongInfo *asong;
  int curr=0;
  // invalid index
  if(v<0 || v>=sharedlistview->childCount()) return NULL;

  QListViewItem *it=sharedlistview->firstChild();

  while(it) {
     if(curr==v) {
       // found it
//       asong.filename=QString(it->text(0));
//       asong.bitrate = QString(it->text(1)).toInt();
//       asong.freq = QString(it->text(2)).toInt();
//       asong.size = QString(it->text(3)).toLong();

       asong = SongInfo::loadSongInfo(it->text(0),true);
       if(asong) {
         if(strcmp(it->text(4),"Yes")==0) asong->shared=true;
         else asong->shared=false;
       }
       return asong;
     }
     curr++;
     it=it->nextSibling();
  }
  return NULL;
}

QStrList LibraryPanel::getAllSongNames()
{
  QStrList slist;
  QListViewItem *it=sharedlistview->firstChild();

  while(it) {
     slist.append(it->text(0));
     it=it->nextSibling();
  }
  return slist;
}
