/***************************************************************************
                          propertiesdlg.h  -  description
                             -------------------
    begin                : Wed Dec 8 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROPERTIESDLG_H
#define PROPERTIESDLG_H

#include <qtabdialog.h>

#include <qstrlist.h>
//#ifdef KDE2
#include <qlistbox.h>
//#endif
#include <qlistview.h>

/**the properties dialog for setting the 
knapster properties
  *@author John Donoghue
  */

class QComboBox;
class QLineEdit;
class QCheckBox;
//class KTabListBox;
class QListView;
class KColorButton;

class Preferences
{
public:
 QString username;
 QString password;
 QString email;
 int speed;
 int port;
 bool newuser;

 QString serveraddr;

 QString downloaddir;
 QString uploaddir;
 int maxuploads;
 int downloadtimeout;
 bool beep;
 int maxdownloads;

 bool clearsearch;
 bool showpath;
 bool multiselect;
 QString mp3player;

 //lib paths
 QStrList pathlist;

 int winw;
 int winh;

 // search box settings


 // console settings for color
 QColor normalcol,infocol,messagecol,errorcol;
// QColor backgroundcol;
};

class PropertiesDlg : public QTabDialog  {
 Q_OBJECT

 // user tab
 QLineEdit *username,*password,*email;
 QComboBox *speed;
 QLineEdit *port;
 QCheckBox *newuser;

 // server tab
 QLineEdit *serveraddr;

 // up/down load tab
 QLineEdit *downloaddir,*maxuploads,*maxdownloads,*downloadtimeout;
 QCheckBox *beep;

 // Misc tab
 // clear on new search
 QCheckBox *clearsearch;
 QCheckBox *showpath;
 QCheckBox *multiselect;
 QLineEdit *mp3player;

 // lib tab
//#ifdef KDE2
 QListView *uploadpathlist;
//#else
// KTabListBox *uploadpathlist;
//#endif /* KDE2 */
 QLineEdit *addpathdir;
 QComboBox *shared;
 QLineEdit *shareddepth;

 // console color tab
 KColorButton *normalcol,*infocol,*messagecol,*errorcol;
// KColorButton *backgroundcol;

private slots:
 void browseUpload();
 void browseDownload();
 void addPath();
 void delPath();

 void setPrefs();

private:
 void setupTabs();
 void getPrefs();

public:
	PropertiesDlg(QWidget *parent);
	virtual ~PropertiesDlg();

  // static func to read in current pref values
  static Preferences readPrefs();
  static QString expandFileName(const QString &name);
};

#endif
