/***************************************************************************
                          propertiesdlg.cpp  -  description
                             -------------------
    begin                : Wed Dec 8 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "propertiesdlg.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qsize.h>
#include <qcombo.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <kapp.h>
#include <kcolorbtn.h>

#ifdef KDE2
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#endif /* KDE2 */

#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>

// constructor - create a modal proerties dlg
PropertiesDlg::PropertiesDlg(QWidget *parent)
 : QTabDialog(parent,"Properties",true)
{
  setCaption(i18n("Properties"));
  // we want all 3 buttons
  setOkButton(i18n("OK"));
  setCancelButton(i18n("Cancel"));
  setApplyButton(i18n("Apply"));

  // setup the tabs
  setupTabs();

  // populat the tabs with the required data
  getPrefs();

  // connect the setprefs function to the apply button
  connect(this,SIGNAL(applyButtonPressed()),this,SLOT(setPrefs()));
}

// deconstructor
PropertiesDlg::~PropertiesDlg()
{
}

void PropertiesDlg::setupTabs()
{
  int maxw_sz;

  // tab1 - user -------------------
  const int rows1 =6;
  const int cols1 =3;


  QWidget *frame=new QWidget(this);

  QGridLayout *grid=new QGridLayout(frame,rows1,cols1,5,5);

  QLabel *l1=new QLabel(i18n("Username "),frame);
  grid->addWidget(l1,0,0);
  maxw_sz =  l1->sizeHint().width();

  username = new QLineEdit(frame, "username" );
  username->setMaxLength(30);          // is there a real limit ?????
  grid->addMultiCellWidget(username,0,0,1,2);

  QLabel *l2=new QLabel(i18n("Password "),frame);
  grid->addWidget(l2,1,0);
  maxw_sz =  maxw_sz > l2->sizeHint().width() ? maxw_sz : l2->sizeHint().width();

  password = new QLineEdit(frame, "password" );
  password->setMaxLength(30);
  // hide password info
  password->setEchoMode(QLineEdit::Password);

  grid->addMultiCellWidget(password,1,1,1,2);

  QLabel *l3=new QLabel(i18n("Email "),frame);
  grid->addWidget(l3,2,0);
  maxw_sz =  maxw_sz > l3->sizeHint().width() ? maxw_sz : l3->sizeHint().width();

  email = new QLineEdit(frame, "email" );
  email->setMaxLength(46);
  grid->addMultiCellWidget(email,2,2,1,2);

  l1->setMaximumWidth(maxw_sz);
  l2->setMaximumWidth(maxw_sz);
  l3->setMaximumWidth(maxw_sz);

  newuser= new QCheckBox(i18n("Logon as new user"),frame,"newuser");
  grid->addMultiCellWidget(newuser,3,3,0,2);
  newuser->setMaximumHeight(newuser->sizeHint().height());

  addTab(frame,i18n("&User"));

  // tab for the server  --------------------------
  frame=new QWidget(this);

  grid=new QGridLayout(frame,4,3,5,5);

  l1=new QLabel(i18n("Napster Server "),frame);
  grid->addWidget(l1,0,0);
  maxw_sz =  l1->sizeHint().width();

  serveraddr = new QLineEdit(frame, "serveraddr" );
  serveraddr->setMaxLength(40);
  grid->addMultiCellWidget(serveraddr,0,0,1,2);

  QWidget *l5=new QLabel(i18n("Download port "),frame);
  grid->addWidget(l5,1,0);
  maxw_sz =  maxw_sz > l5->sizeHint().width() ? maxw_sz : l5->sizeHint().width();

  port = new QLineEdit(frame, "port" );
  port->setMaxLength(5);          // is there a real limit ?????
  grid->addWidget(port,1,1);

  QWidget *l4=new QLabel(i18n("Connection speed "),frame);
  grid->addWidget(l4,2,0);
  maxw_sz =  maxw_sz > l4->sizeHint().width() ? maxw_sz : l4->sizeHint().width();

  speed=new QComboBox(false,frame,"speed");
  speed->insertItem(i18n("Unknown"));
  speed->insertItem(i18n("14.4K"));
  speed->insertItem(i18n("28.8K"));
  speed->insertItem(i18n("34.6K"));
  speed->insertItem(i18n("56.7K"));
  speed->insertItem(i18n("64K ISDN"));
  speed->insertItem(i18n("128K ISDN"));
  speed->insertItem(i18n("Cable"));
  speed->insertItem(i18n("DSL"));
  speed->insertItem(i18n("T1"));
  speed->insertItem(i18n("T3+"));
  grid->addWidget(speed,2,1);

  QSize sz(maxw_sz,speed->sizeHint().height());

  port->setMaximumSize(sz);
  l5->setMaximumSize(sz);
  l1->setMaximumSize(sz);
  speed->setMaximumSize(speed->sizeHint());

  addTab(frame,i18n("&Connection"));

  //----- fix the height of username/password email so same as the other tabs
  email->setMaximumHeight(sz.height());
  username->setMaximumHeight(sz.height());
  password->setMaximumHeight(sz.height());

  // tab for up/downloads -------------
  const int rows2 =6;
  const int cols2 =4;

  frame=new QWidget(this);

  grid=new QGridLayout(frame,rows2,cols2,5,5);

  l1=new QLabel(i18n("Download directory "),frame);
  grid->addWidget(l1,0,0);
  maxw_sz =  l1->sizeHint().width();

  downloaddir = new QLineEdit(frame, "dload" );
  grid->addMultiCellWidget(downloaddir,0,0,1,2);

  QPushButton *downloadbutton = new QPushButton(i18n("Browse..."),frame,"dl_browse");
  connect(downloadbutton,SIGNAL(clicked()),this,SLOT(browseDownload()));
  downloadbutton->setMaximumSize(downloadbutton->sizeHint());
  grid->addWidget(downloadbutton,0,3);

  l2=new QLabel(i18n("Max download connections "),frame);
  grid->addWidget(l2,1,0);
  maxw_sz =  maxw_sz > l2->sizeHint().width() ? maxw_sz : l2->sizeHint().width();

  maxdownloads = new QLineEdit(frame, "downloads" );
  maxdownloads->setMaxLength(3);
  grid->addWidget(maxdownloads,1,1);

  l3=new QLabel(i18n("download timeout (mins) "),frame);
  grid->addWidget(l3,2,0);
  maxw_sz =  maxw_sz > l3->sizeHint().width() ? maxw_sz : l3->sizeHint().width();

  downloadtimeout = new QLineEdit(frame, "downloadtimeout" );
  downloadtimeout->setMaxLength(1);
  grid->addWidget(downloadtimeout,2,1);

  beep= new QCheckBox(i18n("Beep on download finish"),frame,"dloadfinish");
  grid->addMultiCellWidget(beep,3,3,0,3);
  beep->setMaximumHeight(beep->sizeHint().height());

  l4=new QLabel(i18n("Max upload connections "),frame);
  grid->addWidget(l4,4,0);
  maxw_sz =  maxw_sz > l4->sizeHint().width() ? maxw_sz : l4->sizeHint().width();

  maxuploads = new QLineEdit(frame, "uploads" );
  maxuploads->setMaxLength(3); // up to 999 should be enough ???? comments anyone ??????
  grid->addWidget(maxuploads,4,1);

  QSize sz2(maxw_sz,downloadbutton->sizeHint().height());

  l1->setMaximumSize(sz2);
  l2->setMaximumSize(sz2);
  l3->setMaximumSize(sz2);
  l4->setMaximumSize(sz2);

  addTab(frame,i18n("Up/Down&loads"));

  // tab for misc
  const int rows3 =3;
  const int cols3 =5;

  frame=new QWidget(this);

  grid=new QGridLayout(frame,rows3,cols3,5,5);

  l1=new QLabel(i18n("Normal Text"),frame);
  grid->addWidget(l1,0,0);
  maxw_sz =  l4->sizeHint().width();

  l2=new QLabel(i18n("Info Text"),frame);
  grid->addWidget(l2,0,3);
  maxw_sz =  maxw_sz > l2->sizeHint().width() ? maxw_sz : l2->sizeHint().width();

  l3=new QLabel(i18n("Message Text"),frame);
  grid->addWidget(l3,1,0);
  maxw_sz =  maxw_sz > l3->sizeHint().width() ? maxw_sz : l3->sizeHint().width();

  l4=new QLabel(i18n("Error Text"),frame);
  grid->addWidget(l4,1,3);
  maxw_sz =  maxw_sz > l4->sizeHint().width() ? maxw_sz : l4->sizeHint().width();

//  l5=new QLabel(i18n("Background"),frame);
//  grid->addWidget(l5,2,0);
//  maxw_sz =  maxw_sz > l5->sizeHint().width() ? maxw_sz : l5->sizeHint().width();

  l1->setMaximumWidth(maxw_sz);
  l2->setMaximumWidth(maxw_sz);
  l3->setMaximumWidth(maxw_sz);
  l4->setMaximumWidth(maxw_sz);
//  l5->setMaximumWidth(maxw_sz);

  normalcol = new KColorButton(frame);
  grid->addWidget(normalcol,0,1);
  infocol = new KColorButton(frame);
  grid->addWidget(infocol,0,4);
  messagecol = new KColorButton(frame);
  grid->addWidget(messagecol,1,1);
  errorcol = new KColorButton(frame);
  grid->addWidget(errorcol,1,4);
//  backgroundcol = new KColorButton(frame);
//  grid->addWidget(backgroundcol,2,1);

  normalcol->setMaximumSize(normalcol->sizeHint());
  infocol->setMaximumSize(normalcol->sizeHint());
  messagecol->setMaximumSize(normalcol->sizeHint());
  errorcol->setMaximumSize(normalcol->sizeHint());
//  backgroundcol->setMaximumSize(normalcol->sizeHint());

  addTab(frame,i18n("&Console Colors"));

  // tab3 - Misc options --------------------
  const int rows4 =5;
  const int cols4 =3;

  frame=new QWidget(this);

  grid=new QGridLayout(frame,rows4,cols4,5,5);

  // clear on new search
  clearsearch= new QCheckBox(i18n("Clear searchlist on new search"),frame,"clearsearch");
  grid->addMultiCellWidget(clearsearch,0,0,0,2);
  clearsearch->setMaximumHeight(clearsearch->sizeHint().height());

  showpath= new QCheckBox(i18n("Show full file path in search list"),frame,"showpath");
  grid->addMultiCellWidget(showpath,1,1,0,2);
  showpath->setMaximumHeight(showpath->sizeHint().height());

  multiselect= new QCheckBox(i18n("Allow multiselect in search list"),frame,"multiselect");
  grid->addMultiCellWidget(multiselect,2,2,0,2);
  multiselect->setMaximumHeight(multiselect->sizeHint().height());

  l1=new QLabel(i18n("mp3 player command "),frame);
  l1->setMaximumWidth(l1->sizeHint().width());
  grid->addWidget(l1,3,0);

  mp3player = new QLineEdit(frame, "mp3player" );
  grid->addMultiCellWidget(mp3player,3,3,1,2);
  mp3player->setMaximumHeight(sz.height());

  addTab(frame,i18n("Misc"));

  // tab for the mp3 lib paths  --------------------------
  frame=new QWidget(this);

  grid=new QGridLayout(frame,8,5,5,5);

  uploadpathlist=new QListView(frame,"uploadlistview");
  uploadpathlist->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  grid->addMultiCellWidget(uploadpathlist,0,3,0,4);

  uploadpathlist->addColumn(i18n("Path"));
  uploadpathlist->addColumn(i18n("Shared"));
  uploadpathlist->addColumn(i18n("recurse depth"));                             

  l1=new QLabel(i18n("path "),frame);
  grid->addWidget(l1,4,0);
  maxw_sz =  l1->sizeHint().width();

  addpathdir = new QLineEdit(frame, "lib_path" );
  grid->addMultiCellWidget(addpathdir,4,4,1,3);

  QPushButton *pathbutton = new QPushButton(i18n("Browse..."),frame,"path_browse");
  connect(pathbutton,SIGNAL(clicked()),this,SLOT(browseUpload()));
  pathbutton->setMaximumHeight(pathbutton->sizeHint().height());
  grid->addWidget(pathbutton,4,4);

  l2=new QLabel(i18n("shared "),frame);
  maxw_sz =  maxw_sz > l2->sizeHint().width() ? maxw_sz : l2->sizeHint().width();

  l2->setMaximumWidth(maxw_sz);
  grid->addWidget(l2,5,0);

  shared=new QComboBox(false,frame,"shared");
  shared->insertItem(i18n("Yes"));
  shared->insertItem(i18n("No"));
  grid->addWidget(shared,5,1);
  shared->setMaximumSize(shared->sizeHint());

  l3=new QLabel(i18n("directory depth "),frame);
  l3->setAlignment(AlignRight|AlignVCenter);

  grid->addWidget(l3,5,2);

  shareddepth = new QLineEdit(frame, "dirdepth" );
  shareddepth->setMaxLength(1); // up to 9 enough
  grid->addWidget(shareddepth,5,3);

  shareddepth->setMaximumWidth(shareddepth->sizeHint().width());

  QPushButton *addbutton = new QPushButton(i18n("Insert"),frame,"insert");
  grid->addWidget(addbutton,6,3);
  connect(addbutton,SIGNAL(clicked()),this,SLOT(addPath()));
  maxw_sz =  addbutton->sizeHint().width();

  QPushButton *delbutton = new QPushButton(i18n("Delete"),frame,"delete");
  grid->addWidget(delbutton,6,4);
  maxw_sz =  maxw_sz > delbutton->sizeHint().width() ?
        maxw_sz : delbutton->sizeHint().width();
  connect(delbutton,SIGNAL(clicked()),this,SLOT(delPath()));

  maxw_sz =  maxw_sz > pathbutton->sizeHint().width() ?
     maxw_sz : pathbutton->sizeHint().width();

  addbutton->setMaximumWidth(maxw_sz);
  addbutton->setMaximumSize(addbutton->sizeHint());
  delbutton->setMaximumSize(addbutton->sizeHint());

  addTab(frame,i18n("Library paths"));
}

// got a press of the browse upload button
void PropertiesDlg::browseUpload()
{
  QString s = QFileDialog::getExistingDirectory(0,this,"browse");

  if ( !s.isEmpty() )
  {
     addpathdir->setText(s);
  }
}

// got a press of the add button in library paths tab
void PropertiesDlg::addPath()
{
  QString path;
  QString depth_str;
  int depth;

  path = addpathdir->text();
  if(path.length()>0) {

     depth_str = shareddepth->text();
     if(depth_str.length()>0 && depth_str[0]>='0' && depth_str[0]<='9') {
       depth=depth_str.toInt();
     }
     else depth=1; // default = only this dir

#ifdef KDE2
     uploadpathlist->insertItem(new QListViewItem(uploadpathlist, 
         path,
         ((shared->currentItem()==0) ? "Yes" : "No"),
         QString().setNum(depth)));
#else
     (void)new QListViewItem(uploadpathlist,
         path,
         ((shared->currentItem()==0) ? "Yes" : "No"),
         QString().setNum(depth));
#endif /* KDE2 */
  }
}
void PropertiesDlg::delPath()
{
  if(uploadpathlist->currentItem()) {

#ifdef KDE2 // is this a kde method???
     uploadpathlist->removeItem(uploadpathlist->currentItem());
#else
     delete uploadpathlist->currentItem();
#endif
  }
}

// got a press of the browse download button
void PropertiesDlg::browseDownload()
{
  QString s = QFileDialog::getExistingDirectory(0,this,"browse");

  if ( !s.isEmpty() )
  {
     downloaddir->setText(s);
  }
}

// got the apply/ok button press
// save the prefs
//
void PropertiesDlg::setPrefs()
{
#ifdef KDE2
  KConfig *config = KGlobal::config();  
#endif

#ifdef KDE2
  config->setGroup("userinfo");
  config->writeEntry("username",username->text());
  config->writeEntry("password",password->text());
  config->writeEntry("email",email->text());
  config->writeEntry("speed",speed->currentItem());
  config->writeEntry("port",port->text() ? QString(port->text()).toInt() : 6699);

  config->setGroup("server");
  config->writeEntry("serveraddr",serveraddr->text());

  config->setGroup("downupload");
  config->writeEntry("downloaddir",downloaddir->text());
  config->writeEntry("maxuploads",maxuploads->text() ? QString(maxuploads->text()).toInt() : 0 );
  config->writeEntry("maxdownloads",maxdownloads->text() ? QString(maxdownloads->text()).toInt() : 0 );
  config->writeEntry("downloadtimeout",downloadtimeout->text() ? QString(downloadtimeout->text()).toInt() : 5 );
  config->writeEntry("beeponfinish",beep->isChecked());
 
  config->setGroup("misc");
  config->writeEntry("clearsearch",clearsearch->isChecked());
  config->writeEntry("showpath",showpath->isChecked());
  config->writeEntry("multiselect",multiselect->isChecked());
 
  config->writeEntry("mp3player",mp3player->text());                 

  config->writeEntry("normalcol",normalcol->color());
  config->writeEntry("infocol",infocol->color());
  config->writeEntry("messagecol",messagecol->color());
  config->writeEntry("errorcol",errorcol->color());
//  config->writeEntry("backgroundcol",backgroundcol->color());


#else
  // tab1
  kapp->getConfig()->writeEntry("username",username->text());
  kapp->getConfig()->writeEntry("password",password->text());
  kapp->getConfig()->writeEntry("email",email->text());
  kapp->getConfig()->writeEntry("speed",speed->currentItem());
  kapp->getConfig()->writeEntry("port",port->text() ? QString(port->text()).toInt() : 6699);
  kapp->getConfig()->writeEntry("newuser",newuser->isChecked());

  // server tab
  kapp->getConfig()->writeEntry("serveraddr",serveraddr->text());

  // tab2
  kapp->getConfig()->writeEntry("downloaddir",downloaddir->text());
  kapp->getConfig()->writeEntry("maxuploads",maxuploads->text() ? QString(maxuploads->text()).toInt() : 0 );
  kapp->getConfig()->writeEntry("maxdownloads",maxdownloads->text() ? QString(maxdownloads->text()).toInt() : 0 );
  kapp->getConfig()->writeEntry("downloadtimeout",downloadtimeout->text() ? QString(downloadtimeout->text()).toInt() : 5 );
  kapp->getConfig()->writeEntry("beeponfinish",beep->isChecked());

  // tab3
  kapp->getConfig()->writeEntry("clearsearch",clearsearch->isChecked());
  kapp->getConfig()->writeEntry("showpath",showpath->isChecked());
  kapp->getConfig()->writeEntry("multiselect",multiselect->isChecked());

  kapp->getConfig()->writeEntry("mp3player",mp3player->text());

  // console tab
  kapp->getConfig()->writeEntry("normalcol",normalcol->color());
  kapp->getConfig()->writeEntry("infocol",infocol->color());
  kapp->getConfig()->writeEntry("messagecol",messagecol->color());
  kapp->getConfig()->writeEntry("errorcol",errorcol->color());
//  kapp->getConfig()->writeEntry("backgroundcol",backgroundcol->color());


#endif /* KDE2 */

  //  libpaths
  QStrList paths;

  QListViewItem *tmp_item = uploadpathlist->firstChild();
  while (tmp_item) {
    paths.append( tmp_item->text(0) + QString("|") +
                  tmp_item->text(1) + QString("|") +
                  tmp_item->text(2));
    tmp_item = tmp_item->nextSibling();
  }
#ifdef KDE2
  config->writeEntry("mp3paths",paths);
#else
  kapp->getConfig()->writeEntry("mp3paths",paths);
#endif


}

// set up the widgets with the pref values
void PropertiesDlg::getPrefs()
{
  Preferences p=readPrefs();

  // tab1
  username->setText(p.username);
  password->setText(p.password);
  email->setText(p.email);
  speed->setCurrentItem(p.speed);
  port->setText( QString().setNum(p.port));
  newuser->setChecked(p.newuser);

  // server tab
  serveraddr->setText( p.serveraddr );

  // tab2
  downloaddir->setText(p.downloaddir);
  maxuploads->setText( QString().setNum(p.maxuploads));
  downloadtimeout->setText( QString().setNum(p.downloadtimeout));
  maxdownloads->setText( QString().setNum(p.maxdownloads));
  beep->setChecked(p.beep);

  // console prefs
  normalcol->setColor(p.normalcol);
  infocol->setColor(p.infocol);
  messagecol->setColor(p.messagecol);
  errorcol->setColor(p.errorcol);
//  backgroundcol->setColor(p.backgroundcol);

  // tab3
  clearsearch->setChecked(p.clearsearch);
  showpath->setChecked(p.showpath);
  multiselect->setChecked(p.multiselect);

  mp3player->setText(p.mp3player);

  // mp3 paths
  QString tmp_path = p.pathlist.first();
  while (tmp_path) {
    QString s1, s2, s3;
#ifdef KDE2
    int pos = tmp_path.find(QChar('|'));
#else
    int pos = tmp_path.find('|');
#endif //KDE2
    s1 = tmp_path.left(pos);
    tmp_path.remove(0, pos+1);
#ifdef KDE2
    pos = tmp_path.find(QChar('|'));
#else
    pos = tmp_path.find('|');
#endif // KDE2
    s2 = tmp_path.left(pos);
    s3 = tmp_path.remove(0, pos+1);

//    uploadpathlist->insertItem(new QListViewItem(uploadpathlist, s1, s2, s3));
    (void)new QListViewItem(uploadpathlist, s1, s2, s3);

    tmp_path=p.pathlist.next();
  }
}

// read prefs from file - static so they can be gotten without
// need of the dialog
Preferences PropertiesDlg::readPrefs()
{
   Preferences p;
#ifdef KDE2
   KConfig *config = KGlobal::config();
#endif /* KDE2 */

#ifdef KDE2
   config->setGroup("userinfo");
   p.username=config->readEntry("username");
   p.password=config->readEntry("password");
   p.email=config->readEntry("email");
   p.speed=config->readNumEntry("speed",0);
   p.port=config->readNumEntry("port",6699);
   p.newuser=config->readBoolEntry("newuser",false);
 
   // check for space that shouldn't be in the username/passowrd
   p.username=p.username.stripWhiteSpace();
   p.password=p.password.stripWhiteSpace();
   p.email=p.email.stripWhiteSpace();
 
   // server
   config->setGroup("server");
   p.serveraddr=config->readEntry("serveraddr","208.184.216.223");
   p.serveraddr=p.serveraddr.stripWhiteSpace();
   if(p.serveraddr.length()==0) p.serveraddr="208.184.216.223";
 
   // up/down load
   config->setGroup("downupload");
   p.downloaddir=config->readEntry("downloaddir","~/");
   p.maxuploads=config->readNumEntry("maxuploads",0);
   p.beep=config->readBoolEntry("beeponfinish",true);
   p.maxdownloads=config->readNumEntry("maxdownloads",0);
   p.downloadtimeout=config->readNumEntry("downloadtimeout",5);

   // expand the dirs if required
   p.downloaddir=expandFileName(p.downloaddir);

   // console cols
   p.normalcol=config->readColorEntry("normalcol",&black);
   p.infocol=config->readColorEntry("infocol",&blue);
   p.messagecol=config->readColorEntry("messagecol",&green);
   p.errorcol=config->readColorEntry("errorcol",&red);
//   p.backgroundcol=config->readColorEntry("backgroundcol",&white);

   // Misc
   config->setGroup("misc");
   p.clearsearch=config->readBoolEntry("clearsearch",true);
   p.showpath=config->readBoolEntry("showpath",false);
   p.multiselect=config->readBoolEntry("multiselect",true);
   p.mp3player=config->readEntry("mp3player","mpg123");
 
   // pathlist
   config->readListEntry("mp3paths",p.pathlist);
 
   // window stuff
   config->setGroup("window");
   p.winw=kapp->config()->readNumEntry("winw",-1);
   p.winh=kapp->config()->readNumEntry("winh",-1);           
#else
   // user
   p.username=kapp->getConfig()->readEntry("username");
   p.password=kapp->getConfig()->readEntry("password");
   p.email=kapp->getConfig()->readEntry("email");
   p.speed=kapp->getConfig()->readNumEntry("speed",0);
   p.port=kapp->getConfig()->readNumEntry("port",6699);
   p.newuser=kapp->getConfig()->readBoolEntry("newuser",false);

   // check for space that shouldn't be in the username/passowrd
   p.username=p.username.stripWhiteSpace();
   p.password=p.password.stripWhiteSpace();
   p.email=p.email.stripWhiteSpace();

   // server
   p.serveraddr=kapp->getConfig()->readEntry("serveraddr","server.napster.com");
   //"208.184.216.223");

   p.serveraddr=p.serveraddr.stripWhiteSpace();
   if(p.serveraddr.length()==0) p.serveraddr="208.184.216.223";

   // up/down load
   p.downloaddir=kapp->getConfig()->readEntry("downloaddir","~/");
   p.maxuploads=kapp->getConfig()->readNumEntry("maxuploads",0);
   p.beep=kapp->getConfig()->readBoolEntry("beeponfinish",true);
   p.maxdownloads=kapp->getConfig()->readNumEntry("maxdownloads",0);
   p.downloadtimeout=kapp->getConfig()->readNumEntry("downloadtimeout",5);

   // expand the dirs if required
   p.downloaddir=expandFileName(p.downloaddir);

   // console cols
   p.normalcol=kapp->getConfig()->readColorEntry("normalcol",&black);
   p.infocol=kapp->getConfig()->readColorEntry("infocol",&blue);
   p.messagecol=kapp->getConfig()->readColorEntry("messagecol",&green);
   p.errorcol=kapp->getConfig()->readColorEntry("errorcol",&red);
//   p.backgroundcol=kapp->getConfig()->readColorEntry("backgroundcol",&white);

   // Misc
   p.clearsearch=kapp->getConfig()->readBoolEntry("clearsearch",true);
   p.showpath=kapp->getConfig()->readBoolEntry("showpath",false);
   p.multiselect=kapp->getConfig()->readBoolEntry("multiselect",true);
   p.mp3player=kapp->getConfig()->readEntry("mp3player","mpg123");

   // pathlist
   kapp->getConfig()->readListEntry("mp3paths",p.pathlist);

   // window stuff
   p.winw=kapp->getConfig()->readNumEntry("winw",-1);
   p.winh=kapp->getConfig()->readNumEntry("winh",-1);
#endif /* KDE2 */

   return p;
}

// function to expand ~user/ filepaths
// NOTE: Unix paths expected
QString PropertiesDlg::expandFileName(const QString &name)
{
  QString path,user;
  struct passwd *pass;
  int p;

  if(name.length()==0) return name;
  if(name[0]!='~') return name; // nothing to expand

  p=name.find("/");
  if(p==-1) {
    user=name;
    path="";
  }
  else {
    if(p>1) user=name.mid(1,p-1); // we had ~user/path

    path=name.mid(p,name.length()-(p));
  }
  if(p>1) pass=getpwnam(user);
  else {
    // we had ~/path -> need to get the current user's data
    uid_t id=getuid();
    pass=getpwuid(id);
  }

  if(pass) {
     user=pass->pw_dir;
  }

  // rebuild -> if we didn't get the userdir -> I guess opening file
  // later will fail - oh well

  return user + path;
}
