/***************************************************************************
                          napsterupload.cpp  -  description
                             -------------------
    begin                : Fri Feb 4 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napsterupload.h"

#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <arpa/tftp.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/un.h>

#include <signal.h>

#include <stdio.h>
#include <stdlib.h>


#include <qfile.h>

#include <iostream.h>

#include "support_funcs.h"


static void sigpipe_handler(int)
{
  cerr<<"upload sigpipe caught!!\n"<<flush;
  return;
}

NapsterUpload::NapsterUpload(long ip,int port,const char *filename,const char *user,
         int speed,const char *dest)
: NapsterTransfer(ip,port,filename,user,speed,dest)
{
}

NapsterUpload::~NapsterUpload()
{
  if(_sock!=-1) close(_sock);
}

bool NapsterUpload::start(int _listen,long sz)
{
  // set that we are initialising
   _status=DL_INIT;

  // create the thread and start us up
  _sock=_listen;

  // no lock needed yet - not threaded yet
  _readsize=sz;

#ifdef DEBUG_1
  cerr<<"$$$$$$$$$$$$$$$ created thread for "<<_filename<<endl<<flush;
#endif

  // create the upload thread
  pthread_create(&_id,NULL,thread_task,(void *)this);
  pthread_detach(_id);

  return true;
}

// the actual workhorce - the thread func
void *NapsterUpload::thread_task(NapsterUpload *ul)
{

  // catch sigpipe signals
  // TODO: test that this will not do anything too drastic
//  signal(SIGPIPE,SIG_IGN);
  signal(SIGPIPE,sigpipe_handler);


#ifdef DEBUG_1
  cerr<<"starting upload thread\n"<<flush;
#endif
  if(!ul) return NULL;

  // set that we are initialising
  ul->down();
    ul->_status=DL_INIT;
  ul->up();

  if(ul->_sock!=-1) ul->upload();
  else ul->upload_new();

  if(ul->_sock!=-1) close(ul->_sock);

  ul->_sock=-1;

  // finsihed - determine reason
  ul->down();
    if(ul->_terminate) ul->_status=DL_KILLED;
    else if(ul->_status==DL_NOLOCALFILE
      || ul->_status==DL_NOCONNECT) { } // error has been set already
    else if (ul->_readsize>=ul->_totalsize) ul->_status=DL_FINISHED;
    else  ul->_status=DL_ERROR;    // only partial upload????
  ul->up();

#ifdef DEBUG_1
  cerr<<"finished upload thread\n"<<flush;
#endif

  return NULL;
}

bool NapsterUpload::upload()
{
  QFile file;
  QString tmp;
  int sz,len;

#ifdef DEBUG_1
  cerr<<"in upload process (normal)\n"<<flush;
#endif


  // open the file
  file.setName(_filename);
  file.open(IO_ReadOnly);

  if(!file.isOpen())
  {
#ifdef DEBUG_1
  cerr<<"upload: no file found of name: "<<_filename<<"\n"<<flush;
#endif

     len = send(_sock,"FILE NOT FOUND",15,0);

     down();
       _status=DL_NOLOCALFILE;
     up();

     return false;
  }
  // go to asked place
  file.at(_readsize);

  down();
    _totalsize=file.size();
  up();

  #ifdef DEBUG_1
     cerr<<"sending file size "<<_totalsize<<endl<<flush;
  #endif

  tmp = QString().setNum(_totalsize);

  len = send(_sock,tmp,tmp.length(),0);
  if(len<=0)
  {
    down();
      _status=DL_ERROR;
    up();
    return false;
  }

  // start the actual dload
  down();
    _status=DL_DOWNLOADING;
    time(&_starttime); // set the start time
  up();

  while(!_terminate && !file.atEnd())
  {
      // read file and send data         if() return false;

      sz = file.readBlock(_buffer,1024);
      if(sz>0) {
         down();
             _readsize+=sz;
         up();
         len = send(_sock,_buffer,sz,0);
         if(len<=0)
         {
            down();
              _status=DL_ERROR;
            up();
            return false;
         }
      }
  }
  return true;
}

bool NapsterUpload::upload_new()
{
  fd_set fdsr;
  struct timeval tm;
  int timeout = 0;

  QFile file;
  QString tmp;
  int sz,len;


  if(_terminate) return true;


#ifdef DEBUG_1
  cerr<<"in upload process (new)\n"<<flush;
#endif


  // open the file
  file.setName(_filename);
  file.open(IO_ReadOnly);

  if(!file.isOpen())
  {
#ifdef DEBUG_1
  cerr<<"upload: no file found of name: "<<_filename<<"\n"<<flush;
#endif

     // what now !!
     down();
       _status=DL_NOLOCALFILE;
     up();

     return false;
   }

   down();
     _totalsize=file.size();
   up();


   // have to connect now
   _sock=socket(AF_INET,SOCK_STREAM,0);
   if(_sock==-1) {
#ifdef DEBUG_1
       cerr<<"ul2: no socket!!\n"<<flush;
#endif
     down();
       _status=DL_NOCONNECT;
     up();

     return false;
   }

   if(connect(_sock,(sockaddr *)&_sockaddr,sizeof(struct sockaddr /*_sockaddr*/))<0) {
#ifdef DEBUG_1
       cerr<<"ul2: Can't connect to upload addr\n"<<flush;
#endif
     down();
       _status=DL_NOCONNECT;
     up();

     return false;
   }

   do {
      if(_terminate) return false; // got a terminate

      FD_ZERO(&fdsr);
      FD_SET(_sock,&fdsr);

      tm.tv_sec=1;
      tm.tv_usec=0;

      timeout++;
/*
      if(_timeoutval>0 && timeout>=60*_timeoutval)
      {
        // no data has been read for _timeoutval mins for the header
#ifdef DEBUG_1
         cerr<<"ul2: init timeout occured "<<endl<<flush;
#endif
        down();
           _status=DL_TIMEOUT;
        up();

        return false;
      }
*/
   }
   while(select(_sock+1,&fdsr,NULL,NULL,&tm)<=0);

   char c;
   if(recv(_sock,&c,1,0)<=0)
   {
     // recieve error -> should have been some data
     down();
       _status=DL_NOCONNECT;
     up();

     return false;
   }

   // now tell em what we're sending
   if(send(_sock,"SEND",4,0)<0)
   {
      // should really be some type of write error
      down();
        _status=DL_NOCONNECT;
      up();

      return false;
   }
   if(_terminate) return true;

   QString what = QString(_user) + " \"" + toDosName(_filename) +"\" "
       + QString().setNum(file.size());
   if(send(_sock,what,what.length(),0)<0)
   {
      down();
        _readsize = -1;
      up();
      return false;
   }
#ifdef DEBUG_!
  cerr<<"ul2: filesize was: "<< file.size() <<endl<<flush;
#endif

   // now we should get where to start from -> or a message
   do {
      if(_terminate) return false; // got a terminate

      FD_ZERO(&fdsr);
      FD_SET(_sock,&fdsr);

      tm.tv_sec=1;
      tm.tv_usec=0;

      timeout++;
/*
      if(_timeoutval>0 && timeout>=60*_timeoutval)
      {
        // no data has been read for _timeoutval mins for the header
#ifdef DEBUG_1
         cerr<<"ul2: init timeout occured "<<endl<<flush;
#endif
        down();
           _status=DL_TIMEOUT;
        up();

        return false;
      }
*/
   }
   while(select(_sock+1,&fdsr,NULL,NULL,&tm)<=0);

   sz=recv(_sock,_buffer,1024,0);
   if(sz>=0) _buffer[sz]='\0';
   else {
     down();
      _readsize = -1;
     up();
      return false;
   }
   // start where we were requested to start
#ifdef DEBUG_1
   cerr<<"ul2: recieved size of " << _buffer << endl<<flush;
#endif
   if(strstr(_buffer,"NOT") || strstr(_buffer,"INVALID"))
   {
#ifdef DEBUG_1
     cerr<<"ul2: upload wasn't wanted: " << _buffer << endl<<flush;
#endif
     return false;
   }

   down();
     _readsize=atoi(_buffer);;
     file.at(_readsize);
   up();

  // start the actual dload
  down();
    _status=DL_DOWNLOADING;
    time(&_starttime); // set the start time
  up();

  while(!_terminate && !file.atEnd())
  {
      // read file and send data         if() return false;

      sz = file.readBlock(_buffer,1024);
      if(sz>0) {
         down();
             _readsize+=sz;
         up();
         len = send(_sock,_buffer,sz,0);
         if(len<=0)
         {
            down();
              _status=DL_ERROR;
            up();
            return false;
         }
      }
  }

  return true;
}

