/***************************************************************************
                          napsterconnection.cpp  -  description
                             -------------------
    begin                : Sun Dec 5 1999
    copyright            : (C) 1999-2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napsterconnection.h"
#include "napsterdownload.h"

#include "support_funcs.h" // for inet_aton if required

#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <arpa/tftp.h>

#include <stdio.h>
#include <string>
#include <cstring>

#include "../config.h" // for "VERSION"

#include <iostream.h>

// to use with knapster, needs some kde event processing
// done when waiting
//#define KDE_INTERACTION


#ifdef KDE_INTERACTION
 #include <kapp.h>
#endif

// some machines dont seem to know this constant
#ifndef INADDR_NONE
 #define INADDR_NONE -1
#endif

static char * int2str(int val)
{
  static char str[100];
  int p=0;
  int div;

  do {
    div = val % 10;
    val = val / 10;
    str[p]='0' + div;
    p++;
  } while(val!=0 && p<100);

  if(p)
    for(int i=0;i<p/2;i++) {
      div=str[i];
      str[i]=str[p-i-1];
      str[p-i-1]=div;
    }
    str[p]='\0';

  return(str);
}

const char *NapsterConnection::errorstr[]=
{
     "Ok","Timeout","Bad port number","Bad IP number",
     "Cannot connect to host",
     "Read error","Write error",
     "Server is busy","Could not connect to server to get best host",
     "Bad data received","Trying to send bad data",
     "Could not login - incorrect user/password??",
     "Could not download","Could not open socket",
     "Could not create binded listener socket",
     "Could not create a new user - perhaps this name is already in use",
     "Invalid username/password for new user - use a different name/password.",
      "Unknown error"
};

const char *NapsterConnection::getLastErrorStr() const
{
  if(_lasterror<0 || _lasterror>NAP_LAST) return errorstr[NAP_LAST];
  return errorstr[_lasterror];
}


NapsterConnection::NapsterConnection()
{
  _connected=false;
  _havehost=false;

  _napster=-1;
  _local=-1;
  _buffer[0]='\0';

  _lasterror=NAP_OK;

  // setup default addr/port
  memset(&_sockaddr,0,sizeof(_sockaddr));
  _sockaddr.sin_family=AF_INET;
  _sockaddr.sin_port=htons(SERVER_PORT);
  _sockaddr.sin_addr.s_addr = INADDR_NONE;
}
NapsterConnection::~NapsterConnection()
{
   Disconnect();
}

// connect with with user details
// an auto connect
bool NapsterConnection::Connect(const char *username,const char *password,const char *email,int speed,int port,bool new_user)
{
#ifdef DEBUG_1
  cout<<"trying to connect...with "<<username<<" "<<password<<endl;
#endif
  _lasterror=NAP_OK;

  if(!getBestHost()) {
#ifdef DEBUG_1
    cout<<"can't get best host\n"<<flush;
#endif
    return false;
  }
  if(!Connect(port)) return false;

  // now try to connect to it
  return Login(username,password,email,speed,new_user);
}

// assumes getBestHost was called
bool NapsterConnection::Connect(int port)
{
  Disconnect();

  _lasterror=NAP_OK;

  localportnum=port; // save the listen port for doing logins

  setupListener(port);

  _napster = socket(AF_INET,SOCK_STREAM,0);
  if(_napster==-1) {
    _lasterror=NAP_NO_SOCKET;
    return false;
  }

#ifdef KDE_INTERACTION
  kapp->processEvents(1000);
#endif

  if(connect(_napster,(sockaddr *)&_sockaddr,sizeof(struct sockaddr))<0) {
    close(_napster);
    _napster=-1;
#ifdef DEBUG_1
    cerr<<"Can't connect!\n"<<flush;
#endif
    _lasterror=NAP_NO_CONNECT;
    return(false);
  }
#ifdef DEBUG_1
  cerr<<"connected to "<<getIPAddressString()<<endl;
#endif
  return true;
}

// disconnect
void NapsterConnection::Disconnect()
{
  // close the listener
  if(_local!=-1) close(_local);
  _local=-1;

  if(_napster!=-1) close(_napster);
  _napster=-1;
  _connected=false;
}

int NapsterConnection::getSocket() const
{
  return _napster;
}
int NapsterConnection::getListener() const
{
  return _local;
}

bool NapsterConnection::getBestHost(const char *server)
{
  int sock;
  struct hostent *hent;

  _havehost=false;

  _lasterror=NAP_OK;

  sock=socket(AF_INET,SOCK_STREAM,0);
  if(sock==-1) {
    _lasterror=NAP_NO_SOCKET;
    return false;
  }

  // find the best host by querying the main napster server

  memset(&_sockaddr,0,sizeof(_sockaddr));

  if(!inet_aton(server,&_sockaddr.sin_addr)) {
    hent=gethostbyname(server);
    if(hent) {
       memcpy(&_sockaddr.sin_addr,hent->h_addr,hent->h_length);

       server = inet_ntoa(_sockaddr.sin_addr);
#ifdef DEBUG_1
       cout<<"besthostis "<<server<<endl<<flush;
#endif

    }
    if(!inet_aton(server,&_sockaddr.sin_addr)) {
#ifdef DEBUG_1
      cout<<"error: no main server address\n"<<flush;
#endif
      _lasterror=NAP_BAD_IP;
      return false;
    }
  }
  _sockaddr.sin_family = AF_INET;
  _sockaddr.sin_port = htons(SERVER_PORT);

#ifdef KDE_INTERACTION
  kapp->processEvents(1000);
#endif

  if(connect(sock,(sockaddr *)&_sockaddr,sizeof(struct sockaddr))<0) {
      // no coonect
#ifdef DEBUG_1
      cout<<"Can't connect!\n"<<flush;
#endif
      _lasterror=NAP_NOSERVER_CONNECT;
      return(false);
  }
#ifdef DEBUG_1
  cout<<"connected to "<<getIPAddressString()<<endl<<flush;
#endif

#ifdef KDE_INTERACTION
  kapp->processEvents(1000);
#endif

  // get the best host info
  int sz;
  // TODO add timeout if can't connect
  fd_set fdsr;
  struct timeval tm;

  tm.tv_sec=0;
  tm.tv_usec=500;

  FD_ZERO(&fdsr);
  FD_SET(sock,&fdsr);
  while((sz = select(sock+1,&fdsr,NULL,NULL,&tm))==0)
  {
#ifdef KDE_INTERACTION
    kapp->processEvents(1000);
#endif

    tm.tv_sec=0;
    tm.tv_usec=500;

    FD_ZERO(&fdsr);
    FD_SET(sock,&fdsr);

  }

  if((sz=recv(sock,_buffer,256,0))<=0) {
     close(sock);
#ifdef DEBUG_1
     cout<<"Can't get best host info!\n"<<flush;
#endif
     _lasterror=NAP_NO_READ;
     return false;
  }
  _buffer[sz]='\0';
  close(sock);

// *********** NEED TO ALSO HANLE busy and wait *************************
#ifdef DEBUG_1
  cout<<"read data for host was '"<<_buffer<<"'\n";
#endif

  if(strncmp(_buffer,"busy",4)==0 || strncmp(_buffer,"wait",4)==0)
  {
#ifdef DEBUG_1
     cout<<"server is busy!!!!\n"<<flush;
#endif
     _lasterror=NAP_SERVER_BUSY;
     return false;
  }
#ifdef DEBUG_1
  cerr<<"retrieved server string of: "<<_buffer<<endl<<flush;
#endif
  if(!parseBestHostString(_buffer)) return false;



  return true;
}

bool NapsterConnection::parseBestHostString(char *str)
{
  // get the address to connect to ( the best host )
  char *ip, *p;

  _havehost=false;

  if(str==NULL) return false;

  ip = str;
  p = strchr(str,':');
  if(p==NULL) {
#ifdef DEBUG_1
    cout<<"best host info invalid\n"<<flush;
#endif
    _lasterror=NAP_BAD_RECV_DATA;
    return false;
  }
  p[0] = '\0';
  p ++;

  memset(&_sockaddr,0,sizeof(_sockaddr));
  if(!inet_aton(ip,&_sockaddr.sin_addr)) {
#ifdef DEBUG_1
     cout<<"error: no server address found\n"<<flush;
#endif
     _lasterror=NAP_BAD_IP;
     return false;
  }
  _sockaddr.sin_family = AF_INET;
  _sockaddr.sin_port = htons(atoi(p));

#ifdef DEBUG_1
  cerr<<"*** port is at "<<atoi(p)<<endl;
#endif

  _havehost=true;

  return true;
}

bool NapsterConnection::Login(const char *username,const char *password,const char *email,int conn,bool new_user)
{
  _lasterror=NAP_OK;

  if(_napster==-1) {
    _lasterror=NAP_NO_CONNECT;
     return false;
  }
  string tmp;
  int len;

  if(new_user) {
#ifdef DEBUG_1
    cout<<"creating new user...\n"<<flush;
#endif
    tmp = username;

    len=tmp.length();

    writeBlock(NAP_CREATEUSER_REQ,tmp.c_str(),len);

    // now its time to logon
#ifdef DEBUG_1
    cout<<"new user logging on...\n"<<flush;
#endif

    tmp=username + string(" ") + password + string(" ") + int2str(localportnum) +
        " \"knapster" VERSION "\" " + int2str(conn) + string(" ") + email;

    len=tmp.length();

    writeBlock(NAP_NEWUSERLOGIN_REQ,tmp.c_str(),len);

    // now get the response
#ifdef DEBUG_1
    cout<<"Wait for server response\n"<<flush;
#endif

#ifdef SOLARIS_TESTING
  // try waiting for some data
  fd_set fdsr;

  FD_ZERO(&fdsr);
  FD_SET(_napster,&fdsr);
  int sv = select(_napster+1,&fdsr,NULL,NULL,NULL);
  cout<<"sel value was: "<<sv<<endl<<flush;
#endif

    NAPBLOCKPTR ptr;

    ptr=readBlock();

//---- test data for solaris-------------
#ifdef SOLARIS_TESTING
    if(ptr->type == 0) {
       cout<<"No data read for login resonse - lasterr was"
           <<(int)_lasterror<<endl<<flush;
       ptr = readBlock();
    }
    cout<<"test resp: err="<<(int)_lasterror<<"["<<ptr->type
       <<"] "<<" ["<<ptr->size<<"] "<<ptr->data<<endl<<flush;
#endif
//----------------------------

#ifdef DEBUG_1
    cout<<"resp: ["<<ptr->type<<"] "<<" ["<<ptr->size<<"] "<<ptr->data<<endl<<flush;
#endif

    if(ptr->type==NAP_CREATEUSER_ERROR) {
      _lasterror=NAP_NO_CREATEUSER;
      return false;
    }

    if(ptr->type==NAP_CREATEUSER_INVALIDNAME) {
       _lasterror=NAP_BAD_USERNAME;
       return false;
    }

    if(ptr->type==NAP_ERROR) {
#ifdef DEBUG_1
      cout<<"login error: "<<ptr->data<<endl<<flush;
#endif
      _lasterror=NAP_NO_LOGIN;

      _connected=false;

      return false;
    }
  }
  else {
    // now its time to logon as normal user
#ifdef DEBUG_1
    cout<<"logging on...\n"<<flush;
#endif

    tmp=username + string(" ") + password + string(" ") + int2str(localportnum) +
        " \"knapster" VERSION "\" " + int2str(conn);

    len=tmp.length();

    writeBlock(NAP_LOGIN_REQ,tmp.c_str(),len);

    // now get the response
#ifdef DEBUG_1
    cout<<"Wait for server response\n"<<flush;
#endif

    NAPBLOCKPTR ptr;

    ptr=readBlock();

#ifdef DEBUG_1
    cout<<"resp: ["<<ptr->type<<"] "<<" ["<<ptr->size<<"] "<<ptr->data<<endl<<flush;
#endif

    if(ptr->type==NAP_ERROR) {
#ifdef DEBUG_1
      cout<<"login error: "<<ptr->data<<endl<<flush;
#endif
      _lasterror=NAP_NO_LOGIN;

      _connected=false;

      return false;
    }
  }
  // wow!! - we finally did it
  _connected=true;

  return true;
}


string NapsterConnection::getIPAddressString() const
{
  string s;
  s=inet_ntoa(_sockaddr.sin_addr);
  return(s);
}

int NapsterConnection::getIPPort() const
{
  return ntohs(_sockaddr.sin_port);
  // _sockaddr.sin_port = htons
}


// read the comms port -> ret -1 on error and -2 on timeout
// otherwise ret num of chars read
int NapsterConnection::readComm(char *xbuffer,int size)
{
  int s=0;

#ifdef KDE_INTERACTION
  kapp->processEvents(1000);
#endif

  _lasterror=NAP_OK;

  if(_napster==-1) {
     _lasterror=NAP_NO_CONNECT;
    return(-1);
  }

  // using recv not read since we want full records not
  // just whatever we can get??
  s=recv(_napster,xbuffer,size,0);

  return(s);
}
int NapsterConnection::writeComm(const char *astring,int size)
{
  int s;

  _lasterror=NAP_OK;

#ifdef KDE_INTERACTION
  kapp->processEvents(1000);
#endif

  if(_napster==-1) {
    _lasterror=NAP_NO_CONNECT;

    return(-1);
  }
  s=send(_napster,astring,size,0);
  return s;
}

NAPBLOCKPTR NapsterConnection::readBlock(bool waitfordata)
{
  int s;
  NAPBLOCKPTR ptr;

  ptr=(NAPBLOCKPTR)_buffer;

  ptr->type=NAP_ERROR;
  ptr->size=0;

  if(_napster==-1) {
      _lasterror=NAP_NO_CONNECT;

      return ptr;
  }
// --- test that reads will get valid data

  // TODO - force it to wait for data if waitfordata is true


  if(!waitfordata)
  {
    s = recv(_napster,_buffer,2048,MSG_PEEK);
    if(s<4)
    {
       /* not even the start of the header yet */
        ptr->size=0;
        ptr->type=NAP_ERROR;

       _lasterror = NAP_NO_READ;
       return ptr;
    }
    ptr->size=NAP_TO_SHORT(ptr->size); // make sure its in the right endian

    if(ptr->size<2048)
    {
//       s = ptr->size;
//       if(recv(_napster,_buffer,4+s,MSG_PEEK)<(4+s))
       if((ptr->size + 4) > s)
       {
         // not enough to read yet

         ptr->size=0;
         ptr->type=NAP_ERROR;

         _lasterror = NAP_NO_READ;
         return ptr;
       }
    }
  }

//--------------
  if((s = readComm(_buffer,4))<=0) { // error or no data
      _lasterror=NAP_NO_READ;
#ifdef DEBUG_1
      cout<<"read err1: "<<s<<endl<<flush;
#endif
      return ptr;
  }

  ptr->size=NAP_TO_SHORT(ptr->size); // make sure its in the right endian
  ptr->type=NAP_TO_SHORT(ptr->type);

  if((short int)ptr->size < 0) {
    //cout<<"size error\n";
    ptr->type=NAP_ERROR;
    _lasterror=NAP_BAD_RECV_DATA;
#ifdef DEBUG_1
    cout<<"read err2: "<<ptr->size<<endl<<flush;
#endif
    ptr->size=0;
  }
  else if(ptr->size<2024) {      // ******** may be > 1024 ?????????????????

    s=readComm(ptr->data,ptr->size );

    ptr->data[s]='\0';

    _lasterror=NAP_OK;
#ifdef DEBUG_1
    cout<<"read data: ("<<s<<") "<<ptr->data<<endl<<flush;
#endif
    ptr->size=s; //********************
  }
  else {
#ifdef DEBUG_1
     cout<<"Someting bad happened in readBlock\n";
#endif
     ptr->type=NAP_ERROR;
     _lasterror=NAP_BAD_RECV_DATA;
     ptr->size=0;
  }
  return ptr;
}


int NapsterConnection::writeBlock(int type,const char *data,int size)
{
  NapBlock blk;

  int s;

  // fix for the endianess problem
  blk.size=SHORT_TO_NAP(size);
  blk.type=SHORT_TO_NAP(type);

  s=writeComm((char *)&blk,4);
  if(s!=-1) {
    // send the actual data
    if(size>0)
      s=writeComm(data,size);
  }
  else  _lasterror=NAP_NO_WRITE;

  return s;
}

bool NapsterConnection::search_user(const char *user)
{
  _lasterror=NAP_OK;

  if(!user) {
     _lasterror=NAP_BAD_SEND_DATA;
     return false;
  }

  int l;

  l=strlen(user);

  return (writeBlock(NAP_BROWSE_REQ,user,l)!=-1);
}


bool NapsterConnection::search(const char *name)
{
  _lasterror=NAP_OK;

  if(!name) {
      _lasterror=NAP_BAD_SEND_DATA;
      return false;
  }

  int l=strlen(name);

  return (writeBlock(NAP_SEARCH_REQ,name,l)!=-1);
}

bool NapsterConnection::download(const char *name,const char *user)
{
  _lasterror=NAP_OK;

  if(!name || !user) {
      _lasterror=NAP_BAD_SEND_DATA;

    return false;
  }
  string query= string(user) + string(" \"") + name + string("\"");

  int l;

  l=query.length();

#ifdef DEBUG_1
  cerr<<"send cmd: "<<query<<endl<<flush;
#endif

  return (writeBlock(NAP_DOWNLOAD_REQ,query.c_str(),l)!=-1);
}


NapsterDownload *NapsterConnection::startDownload(long ip,int port,const char *filename,
     const char *user,int speed,const char *dest)
{
  NapsterDownload *dload=NULL;

  _lasterror=NAP_OK;

  dload=new NapsterDownload(ip,port,filename,user,speed,dest);

  return dload;
}


bool NapsterConnection::setupListener(int _port)
{
   struct sockaddr_in server;
   int len=1;

   if(_local==-1) {
     _local = socket(AF_INET, SOCK_STREAM, 0);
     if (_local < 0) {
#ifdef DEBUG_1
      cerr<<"connection listener socket error!\n"<<flush;
#endif
      _lasterror=NAP_NO_SOCKET;
      return false;
     }

     server.sin_family = AF_INET;
     server.sin_addr.s_addr = htonl(INADDR_ANY);
     server.sin_port = htons(_port);

     setsockopt(_local, SOL_SOCKET, SO_REUSEADDR, &len, sizeof(len));

     if (bind(_local, (struct sockaddr *)&server, sizeof(server)) < 0) {
#ifdef DEBUG_1
      cerr<< "bind error in connection listener\n"<<flush;
#endif
      close(_local);
      _local=-1;
      _lasterror=NAP_NO_BIND;
      return false;
     }

     listen(_local, 0);   // send number of allowed connections *********************************
   }
   return true;
}

// get current buffer - probally dangerous to use this
// or at least the results contained in it may be unpredictable
const char *NapsterConnection::getBuffer()
{
  return _buffer;
}

bool NapsterConnection::whois(const char *u)
{
  if(!u) return false;

  QString str=u;
  str=str.stripWhiteSpace();

#ifdef DEBUG_1
      cerr<< "doing whois on: "<<str<<endl<<flush;
#endif

  writeBlock(NAP_WHOIS_REQ,str,str.length());

  return true;
}

bool NapsterConnection::ping(const char *u)
{
  if(!u) return false;

  QString str=u;
  str=str.stripWhiteSpace();

#ifdef DEBUG_1
      cerr<< "doing ping on: "<<str<<endl<<flush;
#endif

  writeBlock(NAP_PING_REQ,str,str.length());

  return true;
}
bool NapsterConnection::list()
{
#ifdef DEBUG_1
      cerr<< "doing list\n"<<flush;
#endif
  writeBlock(NAP_CHANLIST_REQ,"",0);

  return true;
}

bool NapsterConnection::sendUserMessage(const char *user,const char *message)
{
  if(!user || !message) return false;

  QString str,msg;

  str=user;
  str=str.stripWhiteSpace();

  msg=message;
  msg=msg.stripWhiteSpace();

  str=str + " " + msg;
#ifdef DEBUG_1
      cerr<< "send msg: "<<str<<endl<<flush;
#endif

  writeBlock(NAP_USER_MSG,str,str.length());

  return true;
}

bool NapsterConnection::join(const char *u)
{
  if(!u) return false;

  QString str=u;
  str=str.stripWhiteSpace();

#ifdef DEBUG_1
      cerr<< "doing join on: "<<str<<endl<<flush;
#endif

  writeBlock(NAP_JOINCHAN_REQ,str,str.length());

  return true;
}
bool NapsterConnection::part(const char *u)
{
  if(!u) return false;

  QString str=u;
  str=str.stripWhiteSpace();

#ifdef DEBUG_1
      cerr<< "doing part on: "<<str<<endl<<flush;
#endif

  writeBlock(NAP_PARTCHAN_REQ,str,str.length());

  return true;
}
bool NapsterConnection::users(const char *u)
{
  if(!u) return false;

  QString str=u;
  str=str.stripWhiteSpace();

#ifdef DEBUG_1
      cerr<< "doing users request on: "<<str<<endl<<flush;
#endif

  writeBlock(NAP_CHANUSERS_REQ,str,str.length());

  return true;
}

bool NapsterConnection::sendChanMessage(const char *chan,const char *message)
{
  if(!chan || !message) return false;

  QString str,msg;

  str=chan;
  str=str.stripWhiteSpace();

  msg=message;
  msg=msg.stripWhiteSpace();

  str=str + " " + msg;
#ifdef DEBUG_1
      cerr<< "send chanmsg: "<<str<<endl<<flush;
#endif

  writeBlock(NAP_SENDCHAN_MSG,str,str.length());

  return true;
}

bool NapsterConnection::download_started_signal()
{
  return writeBlock(NAP_DOWNLOAD_STARTED,NULL,0)!=-1;
}
bool NapsterConnection::download_finished_signal()
{
  return writeBlock(NAP_DOWNLOAD_FINISHED,NULL,0)!=-1;
}
bool NapsterConnection::upload_started_signal()
{
  return writeBlock(NAP_UPLOAD_STARTED,NULL,0)!=-1;
}
bool NapsterConnection::upload_finished_signal()
{
  return writeBlock(NAP_UPLOAD_FINISHED,NULL,0)!=-1;
}

bool NapsterConnection::version()
{
  return writeBlock(NAP_SERVERVERSION_REQ,NULL,0)!=-1;
}

bool NapsterConnection::share(const SongInfo *s)
{
  if(!s) return false;

  // CONVERT TO WINDOWS PATH!!!!!!
  QString str=QString("\"") + s->filename +QString("\"") + " "
    + s->md5 + " " + QString().setNum(s->size) + " " +
    QString().setNum(s->bitrate) + " " + QString().setNum(s->freq)
    + " " + QString().setNum(s->seconds);
//  str=str.stripWhiteSpace();

#ifdef DEBUG_1
  cerr<<"sending shared: "<<str<<endl<<flush;
#endif

  return writeBlock(NAP_ADDTOSONGLIST_REQ,str,str.length())!=-1;
}

