/***************************************************************************
                          knapster.h  -  description
                            -------------------
    begin                : Mon Dec  6 23:50:46 CST 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNAPSTER_H
#define KNAPSTER_H

#include <kapp.h>
#include <ktmainwindow.h>
#include <kprocess.h>


#include "napsterconnection.h"
#include "songinfo.h"
#include <qlist.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qstrlist.h>

#include <qdatetime.h>

#include "extlistbox.h"

#include "../config.h"   // for version etc


// class to hold info about pending pings that have been sent to the server
class PingItem
{
public:
  PingItem(const QString &n)
  {
     user=n;
     time.start(); // set to current time
  }

  QString user;
  QTime time;
};

class QMultiLineEdit;
class QComboBox;
class QLineEdit;
class QListView;
class QListViewItem;
class QPoint;
class KSocket;
class QPopupMenu;
class SearchPanel;
class ConsolePanel;
class DownloadPanel;
class LibraryPanel;
class UploadPanel;

//class KTabCtl;
class ExtTab;

//class KHTMLView;

class Knapster : public KTMainWindow
{
  Q_OBJECT

  private slots:
    // menu slots
    void menuConsoleClear();
    void menuLogon();
    void menuRelogon();
    void menuProperties();

    // open recent
    void menuOpenRecent(int);

    // on app closedown
    void closeDown();

    // search slot - for the search win
    void startSearch(int,const char *);
    void searchDownload(QListViewItem *it);

    // slot for the ConsolePanel command entry
    void startConsoleCommand(const char *str);

    // slot for capture of napster pending reads & close
    void napsterRead(KSocket *);
    void napsterClose(KSocket *);

    // download slots
    void downloadTerminate(QListViewItem *);
    void downloadTerminateAndDelete(QListViewItem *);
    void playsong_dl(const char *);

    // upload slots
    void uploadTerminate(QListViewItem *);


    // timer slot to update the download list info
    void timeout();

    // other slots
    void addPingItem(const char *user);
    void sendWhois(const char *user);

    // playsong from mp3 library
    void playsong(const char *);

  public slots:
    // load the mp3 paths from the prefs
    void loadMP3LibraryPaths();

  private:
    NapsterConnection connection;

    // listener for the napster connection
    KSocket *listener;

    // the external mp3 player process
    KProcess player;

    // the open previous connection popup
    QPopupMenu *prevconnect_menu;
    QStrList recentConnection;

    // the tab widget
    ExtTab *tab;

    // tab1
    ConsolePanel *console;

    // tab2
    SearchPanel *searchpanel;

    // tab3
    DownloadPanel *downloadpanel;
    QList<SongInfo> downloadlist;
    int dloadval;

    // tab4
    UploadPanel *uploadpanel;
    QList<SongInfo> uploadlist;

    // tab5
    LibraryPanel *librarypanel;

    // list of pending pings sent to the server
    QList<PingItem> pinglist;

    // shared song names
    QStrList songnames;
    int songpos; // pos in the list we are at in sending to the server
  public:
    /** constructor */
    Knapster(const char *name=0);
    /** destructor */
    virtual ~Knapster();

  private:
    void addRecentConnection(const QString &conn);

    void setupMenus();
    void setupTabs();

    void writeConsole(char *s,ExtListBox::LineType type=ExtListBox::None);
    void writeConsole(QString s,ExtListBox::LineType type=ExtListBox::None);

    void addSearchItem(SongInfo *tmpinfo);
    void addDownloadItem(SongInfo *tmpinfo);
    void delDownloadItem(SongInfo *tmpinfo);

    // only usedfor when other person is behind a firewall and we
    // have to connect to them
    void addUploadItem(SongInfo *tmpinfo);

    void showServerStats(NAPBLOCKPTR);

    QString convertSecondsToDurationString(long s);

    bool checkForConnections();
    bool processDownloadConnection(int sock);
    bool processUploadConnection(int sock);

    bool startDownload(SongInfo *song);

    SongInfo *parseSearchBuffer(char *buff);
    SongInfo *parseBrowseBuffer(char *buff);
    SongInfo *parseDownloadBuffer(char *buff);
    SongInfo *parseRemoteQueueBuffer(char *buff);

    void processWhoisResult(char *data);
    void processWhoisOffline(char *data);
    void processUploadRequest(char *data);

    void processChanMessage(char *data);
    void processChanUserJoined(char *data);
    void processChanUserLeft(char *data);

    void processUserMessage(char *data);

    void processPingResult(char *data);

    bool parsePathItem(const QString &str,QString &path,bool *share,int *depth);

    void updateDownloadList();
    void updateUploadList();

    void sendSharedSongs();
};

#endif
