/***************************************************************************
                          extlistview.cpp  -  description
                             -------------------
    begin                : Thu Jun 1 2000
    copyright            : (C) 2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "extlistview.h"

#include <kapp.h>
#include <stdlib.h>

#ifdef KDE2
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#endif /* KDE2 */

#include <qheader.h>

#include <iostream.h>

/*
 * class for a list view that saves its widths to the prefs under the name
 * given to the widget
 */

ExtListView::ExtListView(QWidget *parent, const char *name )
: QListView(parent,name)
{
  // load the widths
  loadWidths();
}
ExtListView::~ExtListView()
{
  // save the widths before we die
  saveWidths();
}

// function that does the saving
bool ExtListView::saveWidths()
{
  QHeader *head =header();
  QStrList widthlist;
  int cols,i;

#ifdef KDE2
   KConfig *config = KGlobal::config();
#endif /* KDE2 */

  // we can't save if there is no header or name to save under
  if(head==NULL || name()==NULL) return false;

  cols = head->count();

  for(i=0;i<cols;i++)
  {
    widthlist.append( QString().setNum(columnWidth(i)) );
  }

#ifdef KDE2
  config->writeEntry(name(),widthlist);
#else
  kapp->getConfig()->writeEntry(name(),widthlist);
#endif

  return true;
}

// function that does the loading
bool ExtListView::loadWidths()
{
  QHeader *head =header();
  QStrList widthlist;
  int readcols;
  unsigned int cols,i;
  char *s;

#ifdef KDE2
   KConfig *config = KGlobal::config();
#endif /* KDE2 */

  // we can't load if there is no header or name to save under
  if(head==NULL || name()==NULL) return false;

  cols = head->count();

#ifdef KDE2
  readcols = config->readListEntry(name(),widthlist);
#else
  readcols = kapp->getConfig()->readListEntry(name(),widthlist);
#endif

  for(i=0;i<widthlist.count();i++)
  {
    s = widthlist.at(i);
    if(i<cols && s!=NULL)
     setColumnWidth(i,atoi(s));
  }

  return true;
}