/***************************************************************************
                          extlistbox.cpp  -  description
                             -------------------
    begin                : Thu Jun 8 2000
    copyright            : (C) 2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "extlistbox.h"
#include <qframe.h>
#include <qpainter.h>
#include <qapp.h>

// TODO - implement dbl click to have a default action depending on
// type of message

/*
 * items that hold the text displayed, also has the color and the type of
 * text - needed for changing color latter and for handling dbl clicks
 */

class ExtListBoxItem
: public QListBoxText
{
public:
  ExtListBoxItem( const char *s, ExtListBox::LineType t,const QColor &c=black)
  : QListBoxText()
  {
     setColor(c);
     type = t;
     setText( s );
  }
  void setColor(const QColor &c)
  {
    col = c;
  }
  ExtListBox::LineType getType() { return type; }

protected:
  // our paint to handle the diff colors
  virtual void paint( QPainter *p )
  {
    p->setPen(col);
    p->setBrush(blue);
    QListBoxText::paint(p);
  }

private:
  // our data
  QColor col;
  ExtListBox::LineType type;
};


/*
 * extlistbox - our color list box for holding the log output of the console
 * handles items of certain types
 * currently:
 *
 * error,info,none,message
 *
 * allows the color to be set for each type
 */
ExtListBox::ExtListBox(QWidget *parent, const char *name )
: QListBox(parent,name)
{
  // set default colors
  errorcol = red;
  infocol = blue;
  normalcol = black;
  messagecol = black;
}
// decontructor
ExtListBox::~ExtListBox()
{
}

/* insert a line of a certain type at the end of the list
 * if no type is given, the default normal is used
 */
void ExtListBox::insertLine(QString s,LineType lt)
{
   insertItem(new ExtListBoxItem(s,lt,getTypeColor(lt)));

   setBottomItem(count()-1);
}
/*
 * clear the list of all data
 */
void ExtListBox::clear()
{
   QListBox::clear();
   // make sure it repaints the borders
   repaint();
}

/*
 * private func to get the color associated with acertain type
 */
QColor ExtListBox::getTypeColor(LineType lt) const
{
  QColor col;

  switch(lt)
  {
    case Error:
      col = errorcol;
      break;
    case Info:
      col = infocol;
      break;
    case Message:
      col = messagecol;
      break;
    default:  // def - assume must be no color
      col = normalcol;
   }
   return col;
}

/*
 * function to set the color for each known message type
 */
void ExtListBox::setCols(
   const QColor &norm,const QColor &info,const QColor &msg,
   const QColor &err)
{
   unsigned int i;
   ExtListBoxItem *lbi;

   normalcol = norm;
   infocol = info;
   messagecol = msg;
   errorcol = err;

   // rechange existing items to the correct color
   for(i =0; i < count(); i++)
   {
      /* we are assuming no idiot has put stuff in of anyother type here */
      lbi = (ExtListBoxItem *)item(i);
      if(lbi) lbi->setColor(getTypeColor(lbi->getType()));
   }
   repaint();
   return;
}