/***************************************************************************
                          extlineedit.cpp  -  description
                             -------------------
    begin                : Mon Feb 28 2000
    copyright            : (C) 2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "extlineedit.h"

#include <qkeycode.h>


ExtLineEdit::ExtLineEdit(QWidget *parent, const char *name )
: QLineEdit(parent,name)
{
  // init the pos's of the line cursors
  num = 0;
  pos = 0;
  top = 0;

  // we want the return press so that we know when to save the data
  connect(this,SIGNAL(returnPressed()),this,SLOT(retPressed()));
}
ExtLineEdit::~ExtLineEdit()
{
}

/*
 * reimplement keyPress so we can catch the cursor keys
 */
void ExtLineEdit::keyPressEvent ( QKeyEvent * e )
{
  if(e->key() == Key_Up) {
    setText(getPrev());
    e->accept();
  }
  else if(e->key() == Key_Down)  {
    setText(getNext());
    e->accept();
  }
//  else if(e->key() == Key_Left || e->key()==Key_Right) {
//    QLineEdit::keyPressEvent(e);
//  }
  else {
    QLineEdit::keyPressEvent(e);
  }
  return;
}

// we got a ret press - save the current text
void ExtLineEdit::retPressed()
{

  // is there room to fit it ??
  if(num<10) {

      prev[top] =  text();
      pos = top;

      top = (top + 1) % 10;
      prev[top]="";

      pos = top;
      num++;
  }
  else {
    // full of strings over write over the start(top) one

    prev[top] = text();

    pos = top;

    top = (top + 1) % 10;
    prev[top]="";
  }
}

// get the previous stored string and reset line cursor to next prev
//
QString ExtLineEdit::getPrev()
{
  int oldpos = pos;

  if(num<10 && pos==0) pos=num;
  else if(pos) pos = (pos - 1) % 10;
  else pos = num-1;

  return prev[oldpos];
}
// get the next stored string and reset line cursor to next next
//
QString ExtLineEdit::getNext()
{
  if(num && num<10) pos = (pos + 1)% (num+1);
  else if(num) pos = (pos + 1)% (num);

  if(pos>=num) return QString("");
  else return prev[pos];
}



