 #include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <arpa/tftp.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

#include <pthread.h>

#include <iostream.h>
#include <string>

#define SERVER_ADDRESS "192.168.0.2"
#define SERVER_PORT 8875
#define TRANSACTION_PORT 8886
#define USER_PORT 6695

#define NAP_ERROR         0

#define NAP_LOGIN_REQ     2
#define NAP_LOGINRESPONSE 3
#define NAP_CREATEUSER    7

#define NAP_SEARCH_REQ   200
#define NAP_SEARCHRESULT 201
#define NAP_SEARCHCOMPLETE 202

// num files/songs etc on server
#define NAP_FILECOUNT 214

#define NAP_REMOTEQUEUEFULL 620

#define NAP_SYSTEM_MSG 621

#define NAP_DOWNLOAD_REQ 203
#define NAP_DOWNLOADRESULT 204

#define NAP_DOWNLOAD_REQ_NEW 500


#define MAX_BUFFER 2048

typedef struct _NapBlock {
  short size;
  short type;
  char data[2];
} NapBlock, *NAPBLOCKPTR;


static char * int2str(int val)
{
  static char str[100];
  int p=0;
  int div;
  do { //while(val!=0 && p<100) {
    div = val % 10;
    val = val / 10;
    str[p]='0' + div;
    p++;
  } while(val!=0 && p<100);

  if(p)
    for(int i=0;i<p/2;i++) {
      div=str[i];
      str[i]=str[p-i-1];
      str[p-i-1]=div;
    }
    str[p]='\0';

  return(str);
}



class NapServer;

class Connection {
  friend class NapServer;
  int _sock;
  bool _logged_on;
  char _buffer[MAX_BUFFER];
public:
  Connection(int s)
  {
     _sock=s;
     _logged_on=false;
  }
  ~Connection()
  {
    if(_sock!=-1) close(_sock);
    cout<<"closed a connection\n"<<flush;
  }
  NAPBLOCKPTR readBlock()
  {
    int s;
    NAPBLOCKPTR ptr;

    ptr=(NAPBLOCKPTR)_buffer;

    ptr->type=NAP_ERROR;
    ptr->size=0;

    if(_sock==-1) {
      // _lasterror=NAP_NO_CONNECT;

      return ptr;
    }
    //cout<<"trying for a block\n";

    if(recv(_sock,_buffer,4,0)<=0) { // error or no data
      //_lasterror=NAP_NO_READ;
      return ptr;
    }

//    cout<<"** length = " << int2str(ptr->size);
//    cout<< " command = "<< int2str(ptr->type) <<endl;

    if(ptr->size < 0) {
      cout<<"size error\n";
      ptr->type=NAP_ERROR;
      //_lasterror=NAP_BAD_RECV_DATA;
      ptr->size=0;
      //ptr->size = 256 - abs(ptr->size);
    }
    else if(ptr->size<MAX_BUFFER-1) {      // **************************** may be > 1024 ?????????????????

      s=recv(_sock,ptr->data,ptr->size,0);

      ptr->data[s]='\0';
//      _lasterror=NAP_OK;

    }
    else {
      cout<<"Someting bad happened in readBlock\n";
      ptr->type=NAP_ERROR;
      //_lasterror=NAP_BAD_RECV_DATA;
      ptr->size=0;
    }
    return ptr;
  }
  int writeBlock(int type,const char *data,int size)
  {
    //char chunk[4];
    NapBlock blk;

    int s;

    // ADD FIX FOR Big endian machines here !!!!!!!!!!!!!
    blk.size=size;
    blk.type=type;

    s=send(_sock,(char *)&blk,4,0);
    if(s!=-1) {
      // send the actual data
      s=send(_sock,data,size,0);
    }
    //else  _lasterror=NAP_NO_WRITE;

    return s;
  }
  int readRaw(char *buff,int size)
  {
    return recv(_sock,buff,size,0);
  }
  int writeRaw(char *buff,int size)
  {
    return send(_sock,buff,size,0);
  }

};

class NapServer {
private:
  struct sockaddr_in serveraddr;
  int serverlistener;
  int transactionlistener;
  bool ok;

  int fakeuser;
public:
  NapServer()
  {
    ok=false;
    fakeuser=-1;
    serverlistener=-1;
    transactionlistener=-1;

    int len;

    serverlistener= socket(AF_INET, SOCK_STREAM, 0);
    if(serverlistener==-1) {
      perror("No server socket");
      return;
    }
    setsockopt(serverlistener, SOL_SOCKET, SO_REUSEADDR, &len, 4);

    transactionlistener= socket(AF_INET, SOCK_STREAM, 0);
    if(transactionlistener==-1) {
      perror("No transaction socket");
      return;
    }
    setsockopt(transactionlistener, SOL_SOCKET, SO_REUSEADDR, &len, 4);

    memset(&serveraddr,0,sizeof(serveraddr));
    serveraddr.sin_family = AF_INET;
    serveraddr.sin_port = htons(SERVER_PORT);
    serveraddr.sin_addr.s_addr = inet_addr(SERVER_ADDRESS);

    if (bind(serverlistener, (struct sockaddr *) &serveraddr, sizeof (serveraddr)) == -1) {
      perror("no server connection");
      return;
    }

    listen(serverlistener, 100);  // max downloads at a time 100!!

    memset(&serveraddr,0,sizeof(serveraddr));
    serveraddr.sin_family = AF_INET;
    serveraddr.sin_port = htons(TRANSACTION_PORT);
    serveraddr.sin_addr.s_addr = inet_addr(SERVER_ADDRESS);

    if (bind(transactionlistener, (struct sockaddr *) &serveraddr, sizeof (serveraddr)) == -1) {
      perror("no transaction connection");
      return;
    }

    listen(transactionlistener, 100);  // max downloads at a time 100!!

    setupFakeUser();

    ok=true;
  }
  ~NapServer()
  {
    if(serverlistener!=-1) close(serverlistener);
    if(transactionlistener!=-1) close(transactionlistener);
    if(fakeuser!=-1) close(fakeuser);

  }
  bool isOK() const { return ok; }
  void run()
  {
    struct sockaddr_in saddr;
    socklen_t n;
    fd_set fdsr;
    int f,s;

    while(1) {
      FD_ZERO(&fdsr);
      FD_SET(serverlistener,&fdsr);
      FD_SET(transactionlistener,&fdsr);
      if(fakeuser!=-1) {
         FD_SET(fakeuser,&fdsr);
         s= (fakeuser>serverlistener) ? fakeuser : serverlistener;
      }
      else s= serverlistener;

      s= (s>transactionlistener) ? s : transactionlistener;

      n=sizeof(saddr);

      s=select(s+1,&fdsr,NULL,NULL,NULL);

      cout<<endl<<"after select\n"<<flush;

      if(s<1) break; // nothing!!!!
      if(FD_ISSET(serverlistener,&fdsr)) {
        f=accept(serverlistener,(struct sockaddr *)&saddr,&n);
        if(f!=-1) {
          cout<<"made server connection from "<< translateIPAddressString(&saddr) <<
             " to port "<<ntohs(saddr.sin_port)<<endl<<flush;

           saddr.sin_port = htons(TRANSACTION_PORT);
           saddr.sin_addr.s_addr = inet_addr(SERVER_ADDRESS);

           string str = translateIPAddressString(&saddr) + ":";
                  str += int2str(TRANSACTION_PORT);
                  str+="\n";

           send(f,str.c_str(),str.length()+1,0);
           close(f);
        }
      }
      if(FD_ISSET(transactionlistener,&fdsr)) {

        f=accept(transactionlistener,(struct sockaddr *)&saddr,&n);
        if(f!=-1) {
          // make a new thread of control
          cout<<"made transaction connection from "<< translateIPAddressString(&saddr) <<
             " to port "<<ntohs(saddr.sin_port)<<endl<<flush;

          pthread_t _id;
          Connection *c=new Connection(f);
          if(!c) {
             cout<<"no connection allocated\n"<<flush;
          }
          else pthread_create(&_id,NULL,server_task,(void *)c);
        }
      }
      if(fakeuser!=-1 && FD_ISSET(fakeuser,&fdsr)) {

        f=accept(fakeuser,(struct sockaddr *)&saddr,&n);
        if(f!=-1) {
          // make a new thread of control
          cout<<"made fakeuser connection from "<< translateIPAddressString(&saddr) <<
             " to port "<<ntohs(saddr.sin_port)<<endl<<flush;

          send(f,"1",1,0);    // whats it for??

          pthread_t _id1;
          Connection *c=new Connection(f);
          if(!c) {
             cout<<"no fu connection allocated\n"<<flush;
          }
          else pthread_create(&_id1,NULL,fakeuser_task,(void *)c);
        }

      }

    }
    cout<<"closing server\n";
  }
  // the connected task
  static void *server_task(Connection *conn)
  {
    NAPBLOCKPTR p;
    int n=1;
//    fd_set fdsr;

    if(!conn) return NULL;

    while(n>0) {
//      FD_ZERO(&fdsr);
//      FD_SET(conn->_sock,&fdsr);
      // wait for the data
//      n=select(conn->_sock+1,&fdsr,NULL,NULL,NULL);
//      if(n>0) {
        p=conn->readBlock();

        cout<<"read["<<p->type<<"] ("<<p->size<<" bytes) ";
        if(p->type!=NAP_ERROR) cout<<p->data;
        cout<<endl<<flush;

        if(p->type==NAP_ERROR) n=0;
        //else n=p->size;

        switch(p->type)
        {
          case NAP_LOGIN_REQ:
            // send ok - dont care if valid
            conn->writeBlock(NAP_LOGINRESPONSE,"login ok",8);
            conn->writeBlock(NAP_SYSTEM_MSG,"Johns server tester",19);
            conn->writeBlock(NAP_FILECOUNT,"1 2 3",5);
            break;
          case NAP_SEARCH_REQ:
          {
            string str=string("\"a.mp3\" 00001 20000 128 44100 001 jade ");
              str += inet_addr(SERVER_ADDRESS);
              str += " 1";

            conn->writeBlock(NAP_SEARCHRESULT,str.c_str(),str.length());

            str=string("\"b.mp3\" 00002 20000 128 44100 101 jade ");
              str += inet_addr(SERVER_ADDRESS);
              str += " 2";

            conn->writeBlock(NAP_SEARCHRESULT,str.c_str(),str.length());

            conn->writeBlock(NAP_SEARCHCOMPLETE,"",0);
          }
            break;
          case NAP_DOWNLOAD_REQ_NEW:
          {
            // XXXXX At the moment this will only happen for the file 'Aqua'
             pthread_t _id1;

             pthread_create(&_id1,NULL,fakeupload_task,(void *)NULL);


          }
            break;
          case NAP_DOWNLOAD_REQ:
          {
            char *c;

            c=strchr(p->data,'\"');
            if(c) c++;

            string str=string("jade "); // "\"a name here\" 00001 20000 128 44100 001 jade ");
              str += int2str(inet_addr(SERVER_ADDRESS));  //inet_addr(SERVER_ADDRESS);
              str += " ";

            if(c && strncmp(c,"b",1)==0) {
                 str += int2str(USER_PORT);

                 str += " \"b.mp3\" 0001100 1";
            }
            else {
              str += int2str(0); // do a test for the new download type

              str += " \"a.mp3\" 0001100 1";
            }
            conn->writeBlock(NAP_DOWNLOADRESULT,str.c_str(),str.length());

          }
            break;
          default:
            break;
        }

//      }
    }
    cout<<"read 0 bytes -> closing\n"<<flush;

    delete conn;

    return NULL;
  }

  string translateIPAddressString(struct sockaddr_in *a) const
  {
    char buff[20];
    string s;

    if(!a) return string("Invalid");

    sprintf(buff,"%d.%d.%d.%d",
          (a->sin_addr.s_addr>>0)&0xff,
          (a->sin_addr.s_addr >>8)&0xff,
  	  (a->sin_addr.s_addr >>16)&0xff,
          (a->sin_addr.s_addr >>24)&0xff);

    s=buff;
    return(s);
  }
  // fake user stuff --------------------------------------------------------------------
  bool setupFakeUser()
  {
    int len;

    fakeuser= socket(AF_INET, SOCK_STREAM, 0);
    if(fakeuser==-1) {
      perror("No fakeuser socket");
      return false;
    }
    setsockopt(fakeuser, SOL_SOCKET, SO_REUSEADDR, &len, 4);

    memset(&serveraddr,0,sizeof(serveraddr));
    serveraddr.sin_family = AF_INET;
    serveraddr.sin_port = htons(USER_PORT);
    serveraddr.sin_addr.s_addr = inet_addr(SERVER_ADDRESS);

    if (bind(fakeuser, (struct sockaddr *) &serveraddr, sizeof (serveraddr)) == -1) {
      perror("no kakeuser connection");
      return false;
    }
    listen(fakeuser, 100);  // max downloads at a time 100!!

    return true;
  }
  static void *fakeuser_task(Connection *conn)
  {
    char buffer[2048];
    int n;
    cout<<"in faker user connection task\n"<<flush;
    // action
    n=conn->readRaw(buffer,3);
    if(n>=0) {
      buffer[n]='\0';
      cout<<"read user data: "<<buffer<<endl<<flush;
    }
    // what to get if we haven't got it yet!!
    n=conn->readRaw(buffer,2000);
    if(n>=0) {
      buffer[n]='\0';
      cout<<"read user data: "<<buffer<<endl<<flush;


      // work out what they want
      char *name,*endstr;

      name=buffer;

      name=strchr(name,'\"');
      if(name) {
        name++;
        endstr=strchr(name,'\"');
      }
      if(endstr) *endstr='\0';

      if(name && endstr) cout<<"requested to download: '"<<name<<"'\n"<<flush;
      int f=open(name,O_RDONLY);
      if(f!=-1) {
         // send the header - size + other stuff + -1 to signify start of mp3
         //long sz;

         sprintf(buffer,"%ld crap here%c",lseek(f,0,SEEK_END),(char)-1);
         lseek(f,0,SEEK_SET);

         conn->writeRaw(buffer,strlen(buffer));


         // ignore the first -1 if there is one
         n=read(f,buffer,1);
         if(n>0 && buffer[0]!=-1) conn->writeRaw(buffer,1);
         else if(buffer[0]!=-1) cout<<"skipped -1\n"<<flush;

         int i=0;
         // r/w alternately
         while((n=read(f,buffer,2048))>0) {
           conn->writeRaw(buffer,n);
           i++;
           i=i%20;
           if(i==0) sleep(1);  // slow it down so we can see better
         }
      }
      else cerr<<"No file opened!!!!!\n"<<flush;
    }

    delete conn;

    return NULL;
  }
  //--- fake upload ---------------------------------
  static void * fakeupload_task(void *whocares)
  {
    struct sockaddr_in tmpaddr;
    Connection *conn;

    // connect to upload the song
    memset(&tmpaddr,0,sizeof(tmpaddr));
    tmpaddr.sin_family = AF_INET;
    tmpaddr.sin_port = htons(6699);
    tmpaddr.sin_addr.s_addr = inet_addr(SERVER_ADDRESS);


    cout<<"in fake upload task\n"<<flush;

    int uload= socket(AF_INET, SOCK_STREAM, 0);
    if(uload==-1) {
      perror("No uload socket");
      return NULL;
    }
    conn=new Connection(uload);
    if(!conn) {
      cerr<<"No new conn made!!!\n"<<flush;
      close(uload);
      return NULL;
    }
    cout<<"about to connect...\n"<<flush;

    if(connect(uload,(sockaddr *)&tmpaddr,sizeof(tmpaddr))<0) {
       delete conn; // this handles killing the file
       cout<<"Can't connect to uload!\n"<<flush;
       return NULL;
    }
    // now send header
    char buffer[2048];
    conn->readRaw(buffer,1); //????????????????????????????????

    cout<<"Done fake uload stuff------------\n"<<flush;

    int n=conn->writeRaw("ABCD",4);

    if(n<0) cerr<<"bad error in upload\n"<<flush;
    else {
      cerr<<"sending upload header\n"<<flush;
      char *str="jade \"a.mp3\" 20000 more crap here";
      n=conn->writeRaw(str,strlen(str));

      // find out where to start from
      conn->readRaw(buffer,100); //????????????????????????????????
      cout<<"start from pos "<<atoi(buffer)<<endl<<flush;
      // now send the data

      int f=open("a.mp3",O_RDONLY);
      if(f!=-1) {
         // send the header - size + other stuff + -1 to signify start of mp3
         //long sz;

         //sprintf(buffer,"%ld crap here%c",lseek(f,0,SEEK_END),(char)-1);
         //lseek(f,0,SEEK_SET);

         //conn->writeRaw(buffer,strlen(buffer));


         // ignore the first -1 if there is one
//         n=read(f,buffer,1);
//         if(n>0 && buffer[0]!=-1) conn->writeRaw(buffer,1);
//         else if(buffer[0]!=-1) cout<<"skipped -1\n"<<flush;
         cerr<<"sending upload data\n"<<flush;

         int i=0;
         // r/w alternately
         while((n=read(f,buffer,2048))>0) {
           conn->writeRaw(buffer,n);
           i++;
           i=i%20;
           if(i==0) sleep(1);  // slow it down so we can see better
         }
         cerr<<"finished upload\n"<<flush;

      }
      else cerr<<"No file opened!!!!!\n"<<flush;
    }

    delete conn;

    return NULL;
  }

};

//---------------------------------------------------------------------
int main()
{
  NapServer s;

  if(!s.isOK()) { cout<<"Couldn't init the server!!\n"; }
  else
    s.run();

  return 0;
}
 