/***************************************************************************
                          napsterdownload.cpp  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napsterdownload.h"

#include "support_funcs.h"

#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <arpa/tftp.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/un.h>

#include <signal.h>

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

NapsterDownload::NapsterDownload(long ip,int port,const char *filename,const char *user,
         int speed,const char *dest)
: NapsterTransfer(ip,port,filename,user,speed,dest)
{
   _file=-1;
   _sock=-1;

   _header_pos=0;
   _gotheader=false;


  _listener=-1;

#ifdef DEBUG_1
   cout<<"dl connection is for port: "<<port<<endl<<flush;
#endif

}
bool NapsterDownload::init()
{
  if(_terminate) return true;

  int l;
//  long size;

  if(_listener==-1) {    // old type download

     _sock=socket(AF_INET,SOCK_STREAM,0);
     if(_sock==-1) {
#ifdef DEBUG_1
       cerr<<"dl: no socket!!\n"<<flush;
#endif
       return false;
     }

     if(connect(_sock,(sockaddr *)&_sockaddr,sizeof(struct sockaddr /*_sockaddr*/))<0) {
#ifdef DEBUG_1
       cerr<<"dl: Can't connect to download addr\n"<<flush;
#endif
       return false;
     }
     // get rid of that stupid byte that is there
     char c;
     recv(_sock,&c,1,0);

     // calc resume pos
  down();
     _readsize = getFileSize(_destname);
  up();

     QString   s = QString(_user) + QString(" \"") + _filename + QString("\" ")
           + QString().setNum(_readsize); // size ( for resumes )

     l=s.length();
#ifdef DEBUG_1
     cerr<<"** will send GET: " << s  <<endl<<flush;
#endif
     send(_sock, "GET", 3, 0);

     l = send(_sock, s, l, 0);

     if(l<0) return false;
#ifdef DEBUG_1
     cerr<<"doing it baby!!!!!\n"<<flush;
#endif
  }
  else {
     _sock=_listener; // we already have the connection
  }

  _connected=true;

  return true;
}

NapsterDownload::~NapsterDownload()
{
  if(_file!=-1) close(_file);
  if(_sock!=-1) close(_sock);
}

bool NapsterDownload::processDownload()
{
  if(!_connected) {
#ifdef DEBUG_1
   cerr<<"Not connected idiot\n"<<flush;
#endif
   return false;
  }

  bool val=false;

  if(!_gotheader) val = header();
  else val = data();

#ifdef DEBUG_4
  usleep(100);
#endif

  return val;
}

bool NapsterDownload::header_new()
{
  long startfrom=0;

  // open the file
  setDownloadName(_destname);
  if(_file==-1) {
#ifdef DEBUG_1
      cerr<<"couldn't open file "<<_destname<<endl<<flush;
#endif
      down();
        _status=DL_NOLOCALFILE;
      up();

      return false;
  }


  if(_file!=-1) {
      struct stat statbuff;
      if(fstat(_file,&statbuff)==0) {
        startfrom=statbuff.st_size;
#ifdef DEBUG_1
        cerr<<"resuming download of "<<_destname<<" at "<<startfrom<<endl<<flush;
#endif
        startfrom=lseek(_file,startfrom,SEEK_SET); // go to the end
        if(startfrom<0) startfrom=0;
      }
  }

  // send where to start from

  QString s;

  s = s.setNum(startfrom);


  send(_sock,s,s.length(),0); // send start pos

  down();
    _readsize=startfrom;  // ???

    time(&_starttime); // set the start time

    _gotheader=true; // mark header as finished
  up();

  return true;
}

bool NapsterDownload::header()
{
  int n;
  fd_set fdsr;
  struct timeval tm;

  // getting the header data still
  char c;

  if(_listener!=-1) return header_new();

  // wait for a byte or a terminate
  do {
    if(_terminate) return false; // got a terminate

    FD_ZERO(&fdsr);
    FD_SET(_sock,&fdsr);

    tm.tv_sec=1;
    tm.tv_usec=0;
  }
  while(select(_sock+1,&fdsr,NULL,NULL,&tm)<=0); // check if data or a terminate

  n = recv(_sock, &c, 1, 0);

  if(n<0) {
#ifdef DEBUG_1
      cout<<"hdr read error\n"<<flush;
#endif
      if(_header_pos!=-1) {
           _buffer[_header_pos]=0;
#ifdef DEBUG_1
       cerr<<"Got the errored header of: "<<_buffer<<endl<<flush;
#endif

      }
      return false;
  }
  if(n==0) {
#ifdef DEBUG_1
      cout<<"no data read in dload header\n"<<flush;
#endif
      return false;
  }

  // if end of size - end of the header??
  if(c<'0' || c>'9') {  // -1 (255)

#ifdef DEBUG_2
     if(c=='\0') cerr<<"********* end of header was a null!!!!\n"<<flush;
#endif
      // end of header
      _buffer[_header_pos]='\0';
      _gotheader=true;
      char *tmp;

#ifdef DEBUG_1
       cerr<<"Got the header of: "<<_buffer<<endl<<flush;
       cerr<<"HEX: [ ";
       for(int x=0;x<_header_pos;x++) cerr<<(int)_buffer[x]<<" ";
       cerr<<"]\n"<<flush;
#endif
      // get the size from the header
      tmp=_buffer;
//--------------------------------------------
//       if(strstr(tmp,"INVALID")==NULL) {
//           sendMsg(DL_ERROR);
//
//           return false;
//       }
// TODO : other errors?????????????????????
//--------------------------------------------

      // open the file
      setDownloadName(_destname,true); // also truncate the file
      if(_file==-1) {
#ifdef DEBUG_1
         cerr<<"couldn't open file "<<_destname<<endl<<flush;
#endif
        down();
           _status=DL_NOLOCALFILE;
        up();
        return false;
      }

      if(_file!=-1 && _readsize!=0) { // we have stuff in the file -> append
//      struct stat statbuff;
//      if(fstat(_file,&statbuff)==0) {
//        startfrom=statbuff.st_size;
        lseek(_file,_readsize,SEEK_SET); // go to the end
//      }
      }


      // this byte is data -> send there
      write(_file,&c,1); // the first byte

      down();
         _readsize++; // add to whats already read ( if any )
         _totalsize=atoi(_buffer);
#ifdef DEBUG_1
         cerr<<"total size of: "<<_totalsize<<endl<<flush;
#endif
         time(&_starttime); // set the start time
      up();
  }
  else {
    // part of the size header
    if(_header_pos!=-1) {
      _buffer[_header_pos]=c;
      _header_pos++;
    }
    if(c=='\0') _header_pos=-1; // ignore the restb of the header??

    // if we've got something 'INVALID' or 'NOT' -> an error -> no download will happen
  }

  return true;
}
bool NapsterDownload::data()
{
   int n;

  fd_set fdsr;
  struct timeval tm;

  do {
    if(_terminate) return false; // got a terminate

    FD_ZERO(&fdsr);
    FD_SET(_sock,&fdsr);

    tm.tv_sec=1;
    tm.tv_usec=0;
  }
  while(select(_sock+1,&fdsr,NULL,NULL,&tm)<=0); // check if data or a terminate

  n = recv(_sock, _buffer, 2048, 0);
  if (n==0) { // finished download  ( or closed connection )
     _connected=false;

     if(_sock!=-1) close(_sock);
     _sock=-1;
     if(_file!=-1) close(_file);
     _file=-1;
#ifdef DEBUG_1
     cerr<<"finished download sz: "<<_readsize << " of "<<_totalsize<<endl<<flush;
#endif
     return false;
   }
   else if(n<0) {
#ifdef DEBUG_1
     cerr<<"read error in download\n"<<flush;
#endif
     return false;
   }
   else {
     write(_file,_buffer,n);

     down();
       _readsize+=n;
       _status=DL_DOWNLOADING;
     up();
   }
   return true;
}

bool NapsterDownload::setDownloadName(const char *path,bool truncate)
{
  int flags=O_WRONLY|O_CREAT;


  if(_file!=-1) return false; // file has already been set

  if(truncate) flags|=O_TRUNC;

  _file=open(path,flags,0644);  // 0664 open and set to rw-rw-r-- ( octal )

  return (_file!=-1);
}

bool NapsterDownload::start(int _listen,long sz)
{
  // set that we are initialising
   _status=DL_INIT;

  // create the thread and start us up
  _listener=_listen;

  // no lock needed yet - not threaded yet
  _totalsize=sz;

#ifdef DEBUG_1
  cerr<<"$$$$$$$$$$$$$$$ created thread for "<<_filename<<endl<<flush;
#endif
  // sleep(1)

  pthread_create(&_id,NULL,thread_task,(void *)this);

  return true;
}
/*
bool NapsterDownload::cancel()
{
  down();
    if(_id) {
     _terminate=true;
     _id=0;

    }
    // in the case of no thread started yet
    if(_status==DL_QUEUED) _status=DL_KILLED;
  up();
  return true;
}
*/
void *NapsterDownload::thread_task(NapsterDownload *dl)
{
#ifdef DEBUG_1
  cerr<<"starting download thread\n"<<flush;
#endif

  if(dl) {
     dl->down();
       dl->_status=DL_INIT;
     dl->up();
  }
  if(!dl || !dl->init()) {
    if(dl) {
        dl->down();
          dl->_status=DL_NOCONNECT;
        dl->up();
    }
#ifdef DEBUG_1
    cerr<<"init error\n"<<flush;
#endif
    return NULL;
  }

  while(!dl->_terminate && dl->processDownload()) { }

  dl->down();
    if(dl->_terminate) dl->_status=DL_KILLED;
    else if(dl->_status==DL_NOLOCALFILE) {  } // error has been set already
    else if (dl->_readsize>=dl->_totalsize) dl->_status=DL_FINISHED;
    else  dl->_status=DL_ERROR;    // only partial download????
  dl->up();
#ifdef DEBUG_1
  cerr<<"finished download thead\n"<<flush;
#endif

//******************
// done in delete
//  close(_msgsock);
// _msgsock=-1;

  return NULL;
}