/***************************************************************************
                          knapster_connect.cpp  -  description
                             -------------------
    begin                : Wed Jan 26 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knapster.h"

#include "songinfo.h"
#include "napsterdownload.h"
#include "napsterupload.h"

#include "librarypanel.h"
#include "uploadpanel.h"

//#include "searchpanel.h"
#include "support_funcs.h"

#include "propertiesdlg.h"

#include <qfile.h>

#include <sys/types.h>
#include <sys/socket.h>

// function to check for a pending download/upload and make it if nessearry
// returns true if one was made
bool Knapster::checkForConnections()
{
  fd_set fdsr;
  int s;
  struct timeval tm;

  if(!connection.isConnected() || connection.getListener()==-1) return false;

  s=connection.getListener();

  FD_ZERO(&fdsr);
  FD_SET(s,&fdsr);

  tm.tv_sec=0;
  tm.tv_usec=1;

  s=select(s+1,&fdsr,NULL,NULL,&tm);
  if(s<=0) // timeout or error
      return false;

  // we have a pending connection
#ifdef DEBUG_1
  cerr<<"Someone wants to connect to us!!!!!!!\n"<<flush;
#endif

  struct sockaddr_in connaddr;
  s=sizeof(connaddr);

  int sock;
#ifdef KDE2
  sock = accept(connection.getListener(),(struct sockaddr *)&connaddr, (size_t *)&s);
#else
  sock = accept(connection.getListener(),(struct sockaddr *)&connaddr, (ksize_t *)&s);
#endif KDE2
  if(sock==-1) {
#ifdef DEBUG_1
     cerr<<"Couldn't accept new connection download!!!!!!\n"<<flush;     // BAD!!!
#endif
     return false;
  }
  // ************************************
  send(sock, "\n", 1, 0);         // ??????????????????????????
  // ************************************
  char buffer[8];
  int n;

  n=recv(sock,buffer,4,0);           // action GET or SEND
  if(n<=0) {
#ifdef DEBUG_1
     cerr<<"error reading c4dl 4 byte action\n"<<flush;
#endif
      close(sock);
      return false;
  }
  buffer[n]='\0';

#ifdef DEBUG_1
  cerr<<"checkfordownload: 4 byte action was "<<buffer<<endl<<flush;
#endif

  // a upload request
  if(strncmp("GET",buffer,3)==0) {
#ifdef DEBUG_1
    cerr<<"someone wants a file from us in dload func!!!!!! "<<endl<<flush;
#endif
    return processUploadConnection(sock);
  }

  // otherwise, assume a download
  return processDownloadConnection(sock);
}

bool Knapster::processDownloadConnection(int sock)
{
  char buffer[4096+2];
  int n;

  char *str;
  char *user=NULL;
  char *filename=NULL;
  long size=0;

  n=recv(sock,buffer,4096,0);
  if(n==-1) {
#ifdef DEBUG_1
     cerr<<"error reading new header\n"<<flush;
#endif
     close(sock);
     return false;
  }
  else if(n==0) {
#ifdef DEBUG_1
     cerr<<"connection closed whilst in new header\n"<<flush;
#endif
     close(sock);
     return false;
  }
  buffer[n]='\0';

#ifdef DEBUG_1
  cerr<<"got a incoming dl header of: "<<buffer<<endl<<flush;
#endif

  str=buffer;
  user=buffer;

  str=strchr(str,' '); // get end of uname
  if(str) {
    *str='\0';
    str++;
    str=strchr(str,'\"');    // get to start of filename
  }
  if(str) {
     str++;
     filename=str;
     str=strchr(str,'\"'); // get to the end of filename
  }
  if(str) {
    *str='\0';
    str+=2; // get to the zize
     size=atol(str);
  }

  if(!user || !filename | size==0) {
#ifdef DEBUG_1
     cerr<<"Invalid data given for dload2!\n"<<flush;
#endif
     close(sock);
     return false;
  }

  // find the download in the list

  NapsterTransfer *dload=NULL;
  SongInfo *sg;
  for(sg=downloadlist.first();sg!=NULL;sg=downloadlist.next()) {
    if(sg->dload && sg->filename.find(filename)==0) {
        // found it
        dload=sg->dload;
        break;
    }
  }

  // if we found it  - start it
  if(dload) {
     writeConsole("Starting download of " + QString(filename) + " from " + QString(user));

     dload->start(sock,size);

//     // tell server we are downloading a file
//     connection.download_started_signal();
     return true;
  }

  close(sock);
  return false;
}

bool Knapster::processUploadConnection(int sock)
{
  char buffer[4096+2];
  int n;

  char *str;
  char *user=NULL;
  char *filename=NULL;
  long startfrom=0;

  n=recv(sock,buffer,4096,0);
  if(n==-1) {
#ifdef DEBUG_1
     cerr<<"error reading new ul header\n"<<flush;
#endif
     close(sock);
     return false;
  }
  else if(n==0) {
#ifdef DEBUG_1
     cerr<<"connection closed whilst in ul header\n"<<flush;
#endif
     close(sock);
     return false;
  }
  buffer[n]='\0';

#ifdef DEBUG_1
  cerr<<"got a incoming ul header of: "<<buffer<<endl<<flush;
#endif

  str=buffer;
  user=buffer;

  str=strchr(str,' '); // get end of uname
  if(str) {
    *str='\0';
    str++;
    str=strchr(str,'\"');    // get to start of filename
  }
  if(str) {
     str++;
     filename=str;
     str=strchr(str,'\"'); // get to the end of filename
  }
  if(str) {
    *str='\0';
    str+=2; // get to the size currently read ( to continue from ???)
    startfrom=atol(str);
  }

  if(!user || !filename) {
#ifdef DEBUG_1
     cerr<<"Invalid data given for uload!\n"<<flush;
#endif
     close(sock);
     return false;
  }
  // send the size of the requested file
  // may also be FILE NOT FOUND
  //             INVALID REQUEST
  // maybe others?

  QString filepath =  filename;

  filepath =  toUnixName(filepath);
//SearchPanel::makeFullFilePath(
//         (PropertiesDlg::readPrefs()).uploaddir,filename);

#ifdef DEBUG_1
     cerr<<"to send file "<<filepath<<endl<<flush;
#endif


  // check that this file is an allowed share file
  if(librarypanel->isSharedSong(filepath)!=true) {
     writeConsole(
          QString("Warning someone tried to download unshared song ")
          + filepath);

     close(sock);
     return false;
  }


/////////// create thread here!!!!!!!!!!!!!1
  NapsterUpload *uload = new NapsterUpload(
     0, //long ip,
     0, //int port,
     filepath, //const char *filename,
     user, //const char *user,
     0, //int speed,
     NULL //const char *dest
  );
  if(!uload) {
#ifdef DEBUG_1
     cerr<<"no mem for uload"<<endl<<flush;
#endif

     close(sock);
     return false;
  }


  SongInfo *song = SongInfo::loadSongInfo(filepath);
  if(song && (song=new SongInfo(*song))!=NULL) {
     song->dload = uload;
     song->user = user;
     uploadlist.append(song);
     uploadpanel->addUploadItem(song);
  }

  uload->start(sock,startfrom);

  // notify the server that we have a upload in progress
  connection.upload_started_signal();

//  close(sock);
  return true;
}

void Knapster::sendSharedSongs()
{
  int i;
  if(songpos>=0 && connection.isConnected()) {
    for(i=0;songpos<songnames.count() && i<5; songpos++, i++) {
//      SongInfo *song = SongInfo::loadSongInfo(songnames.at(songpos),true);
      SongInfo *song = librarypanel->findSongInfo((const char *)songnames.at(songpos),true);

      if(song) {
        song->filename = toDosName(song->filename);
        if(song->shared)
           connection.share(song);
      }
    }
    if(songpos>=songnames.count()) songpos=-1;
  }

  return;
}
