/***************************************************************************
  kmplayerview.cpp  -  description
  -------------------
begin                : Sat Dec  7 16:14:51 CET 2002
copyright            : (C) 2002 by Koos Vriezen
email                : 
 ***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <math.h>

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qmetaobject.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qmultilineedit.h>
#include <qapplication.h>
#include <qiconset.h>
#include <qcursor.h>
#include <qpopupmenu.h>
#include <qslider.h>
#include <qlabel.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

static const int XKeyPress = KeyPress;
#undef KeyPress
static const int button_height = 11;

// application specific includes
#include "kmplayerview.h"
//#include "kmplayer.h"

#include <kstaticdeleter.h>
#include <kdebug.h>
#include <klocale.h>
#include <arts/kartsdispatcher.h>

typedef int (*QX11EventFilter) (XEvent*);
static QX11EventFilter oldFilter = 0;
extern QX11EventFilter qt_set_x11_event_filter (QX11EventFilter filter);

static int qxembed_x11_event_filter (XEvent* e) {
    switch (e->type) {
        case MapRequest: {
            //printf("maprequest 0x%x 0x%x\n", e->xmap.event, e->xmap.window);
            QWidget* w = QWidget::find (e->xmap.window);
            if (w && w->metaObject ()->inherits ("KMPlayerViewer")) {
                w->show ();
                return true;
            }
        }
    }
    if (oldFilter && oldFilter != (QX11EventFilter) qt_set_x11_event_filter)
        return oldFilter (e);
    return false;
}

class KMPlayerEventFiter {
public:
    KMPlayerEventFiter ();
    ~KMPlayerEventFiter ();
};

static KMPlayerEventFiter * kmplayer_event_filter = 0L;

KMPlayerEventFiter::KMPlayerEventFiter () {
    printf ("KMPlayerEventFiter::KMPlayerEventFiter\n");
    oldFilter = qt_set_x11_event_filter (qxembed_x11_event_filter);
}

KMPlayerEventFiter::~KMPlayerEventFiter () {
    printf ("KMPlayerEventFiter::~KMPlayerEventFiter\n");
    qt_set_x11_event_filter (oldFilter);
    kmplayer_event_filter = 0L;
}

static KStaticDeleter <KMPlayerEventFiter> eventFiterDeleter;

KArtsDispatcher dispatcher;
//-------------------------------------------------------------------------

static const char * stop_xpm[] = {
    "5 7 2 1",
    "       c None",
    ".      c #000000",
    "     ",
    ".....",
    ".....",
    ".....",
    ".....",
    ".....",
    "     "};

static const char * play_xpm[] = {
    "5 9 2 1",
    "       c None",
    ".      c #000000",
    ".    ",
    "..   ",
    "...  ",
    ".... ",
    ".....",
    ".... ",
    "...  ",
    "..   ",
    ".    "};

static const char * pause_xpm[] = {
    "7 9 2 1",
    "       c None",
    ".      c #000000",
    "       ",
    "..   ..",
    "..   ..",
    "..   ..",
    "..   ..",
    "..   ..",
    "..   ..",
    "..   ..",
    "       "};

static const char * forward_xpm[] = {
    "11 9 2 1",
    "       c None",
    ".      c #000000",
    ".     .    ",
    "..    ..   ",
    "...   ...  ",
    "....  .... ",
    "..... .....",
    "....  .... ",
    "...   ...  ",
    "..    ..   ",
    ".     .    "};

static const char * back_xpm[] = {
    "11 9 2 1",
    "       c None",
    ".      c #000000",
    "    .     .",
    "   ..    ..",
    "  ...   ...",
    " ....  ....",
    "..... .....",
    " ....  ....",
    "  ...   ...",
    "   ..    ..",
    "    .     ."};

static const char * config_xpm[] = {
    "11 8 2 1",
    "       c None",
    ".      c #000000",
    "           ",
    "           ",
    "...........",
    " ......... ",
    "  .......  ",
    "   .....   ",
    "    ...    ",
    "     .     "};


//-----------------------------------------------------------------------------

KMPlayerViewLayer::KMPlayerViewLayer (KMPlayerView * parent, QBoxLayout * b)
 : QWidget (parent), m_view (parent), m_box (b), m_fullscreen (false) {
    setEraseColor (QColor (0, 0, 0));
}

void KMPlayerViewLayer::fullScreen () {
    if (m_fullscreen) {
        showNormal ();
        reparent (m_view, 0, QPoint (0, 0), true);
        m_box->addWidget (this);
    } else {
        reparent (0L, 0, QPoint (0, 0), true);
        showFullScreen ();
    }
    m_fullscreen = !m_fullscreen;
    m_view->popupMenu ()->setItemChecked (KMPlayerView::menu_fullscreen, 
                                          m_fullscreen);
}

//-----------------------------------------------------------------------------

KMPlayerViewerHolder::KMPlayerViewerHolder (QWidget * pa, KMPlayerView * view)
 : QWidget (pa), m_view (view) {
    setEraseColor (QColor (0, 0, 0));
}

void KMPlayerViewerHolder::mouseMoveEvent (QMouseEvent * e) {
    if (e->state () == Qt::NoButton) {
        if (e->y () > height () - button_height)
            m_view->delayedShowButtons ();
        else
            m_view->buttonBar ()->hide ();
    }
}

void KMPlayerViewerHolder::resizeEvent (QResizeEvent *) {
    int x =0, y = 0;
    int w = width ();
    int h = height ();
    if (m_view->keepSizeRatio ()) {
        int hfw = m_view->viewer ()->heightForWidth (w);
        if (hfw > 0) {
            if (hfw > h)
                w = int ((1.0 * h * w)/(1.0 * hfw));
            else
                h = hfw;
        }
        x = (width () - w) / 2;
        y = (height () - h) / 2;
    }
    m_view->viewer ()->setGeometry (x, y, w, h);
    m_view->viewer ()->setMouseTrackingPos (height () - button_height);
}

//-----------------------------------------------------------------------------

static QPushButton * ctrlButton (QWidget * w, QBoxLayout * l, const char ** p) {
    QPushButton * b = new QPushButton (QIconSet (QPixmap(p)), QString::null, w);
    b->setMaximumSize (750, button_height);
    b->setFocusPolicy (QWidget::NoFocus);
    b->setFlat (true);
    l->addWidget (b);
    return b;
}
#include <arts/soundserver.h>
#include <arts/kartsserver.h>
#include <arts/kartsfloatwatch.h>
KMPlayerView::KMPlayerView (QWidget *parent, const char *name)
  : KMediaPlayer::View (parent, name),
    m_artsserver (KArtsServer().server()),
    delayed_timer (0),
    m_keepsizeratio (false),
    m_show_console_output (false),
    m_auto_hide_buttons (false),
    m_playing (false),
    m_inVolumeUpdate (false)
{
    //setBackgroundMode(Qt::NoBackground);
    QVBoxLayout * viewbox = new QVBoxLayout (this, 0, 0);
    m_layer = new KMPlayerViewLayer (this, viewbox);
    viewbox->addWidget (m_layer);
    QVBoxLayout * layerbox = new QVBoxLayout (m_layer, 0, 0);
    m_buttonbar = new QWidget (m_layer);
    KMPlayerViewerHolder * w1 = new KMPlayerViewerHolder (m_layer, this);
    m_viewer = new KMPlayerViewer (w1, this);
    //w1->setEraseColor (QColor (0, 0, 0));
    layerbox->addWidget (w1);
    layerbox->addWidget (m_buttonbar);

    QHBoxLayout * buttonbox = new QHBoxLayout (m_buttonbar, 1);
    m_buttonbar->setMaximumSize (2500, button_height);
    m_buttonbar->setEraseColor (QColor (0, 0, 0));
    m_backButton = ctrlButton (m_buttonbar, buttonbox, back_xpm);
    m_playButton = ctrlButton (m_buttonbar, buttonbox, play_xpm);
    m_forwardButton = ctrlButton (m_buttonbar, buttonbox, forward_xpm);
    m_stopButton = ctrlButton (m_buttonbar, buttonbox, stop_xpm);
    m_pauseButton = ctrlButton (m_buttonbar, buttonbox, pause_xpm);
    m_configButton = ctrlButton (m_buttonbar, buttonbox, config_xpm);
    m_playButton->setToggleButton (true);
    m_stopButton->setToggleButton (true);

    m_popupMenu = new QPopupMenu (m_layer);
    m_zoomMenu = new QPopupMenu (m_layer);
    m_zoomMenu->insertItem (i18n ("50%"), menu_zoom50);
    m_zoomMenu->insertItem (i18n ("100%"), menu_zoom100);
    m_zoomMenu->insertItem (i18n ("150%"), menu_zoom150);
    m_popupMenu->insertItem (i18n ("&Zoom"), m_zoomMenu, menu_zoom);
    m_popupMenu->insertItem (i18n ("&Full Screen"),
                             m_layer, SLOT (fullScreen()), 0, menu_fullscreen);
    m_popupMenu->insertSeparator ();
    if (!m_artsserver.isNull()) {
        QLabel * label = new QLabel (i18n ("Volume:"), m_popupMenu);
        m_popupMenu->insertItem (label);
        m_slider = new QSlider (0, 100, 10, 40, Qt::Horizontal, m_popupMenu);
        connect(m_slider, SIGNAL(valueChanged(int)), this,SLOT(setVolume(int)));
        m_svc = m_artsserver.outVolume();
        KArtsFloatWatch *watch = new KArtsFloatWatch(m_svc, "scaleFactor_changed", this);
        connect (watch, SIGNAL (valueChanged (float)), 
                 this, SLOT (updateVolume (float)));
        m_popupMenu->insertItem (m_slider, menu_volume);
        m_popupMenu->insertSeparator ();
    }
    m_popupMenu->insertItem (i18n ("&Configure KMPlayer ..."), menu_config); 

    QVBoxLayout * viewerbox = new QVBoxLayout (m_viewer, 0, 0);
    m_multiedit = new QMultiLineEdit (m_viewer, "ConsoleOutput");
    m_multiedit->setReadOnly (true);
    m_multiedit->setFamily ("courier");
    m_multiedit->setPaper (QBrush (QColor (0, 0, 0)));
    m_multiedit->setColor (QColor (0xB2, 0xB2, 0xB2));
    QPalette pal (QColor (64, 64,64), QColor (32, 32, 32));
    m_multiedit->horizontalScrollBar ()->setPalette (pal);
    m_multiedit->verticalScrollBar ()->setPalette (pal);
    viewerbox->addWidget (m_multiedit);
    m_multiedit->hide ();

    setFocusPolicy (QWidget::ClickFocus);

    connect (m_viewer, SIGNAL (aboutToPlay ()), this, SLOT (startsToPlay ()));
    connect (m_configButton, SIGNAL (clicked ()), this, SLOT (showPopupMenu()));

    XSelectInput (qt_xdisplay (), m_viewer->winId (), 
            ExposureMask | StructureNotifyMask | KeyPressMask);

    if (!kmplayer_event_filter)
        kmplayer_event_filter = eventFiterDeleter.setObject (new KMPlayerEventFiter());
    printf ("KMPlayerView %u %u\n", m_viewer->winId(), kmplayer_event_filter);
}

KMPlayerView::~KMPlayerView () {
    if (m_layer->parent () != this)
        delete m_layer;
    printf ("~KMPlayer\n");
}

void KMPlayerView::setAutoHideButtons (bool b) {
    killTimers ();
    m_auto_hide_buttons = b;
    if (b && m_playing)
        m_buttonbar->hide ();
    else
        m_buttonbar->show ();
    m_viewer->setMouseTracking (b && m_playing);
    m_viewer->parentWidget ()->setMouseTracking (b && m_playing);
}

void KMPlayerView::delayedShowButtons () {
    if (m_buttonbar->isVisible () || delayed_timer)
        return;
    delayed_timer = startTimer (300);
}

void KMPlayerView::setVolume (int vol) {
    if (m_inVolumeUpdate) return;
    float volume = float (0.0004*vol*vol);
    printf("setVolume %d -> %.4f\n", vol, volume);
    m_svc.scaleFactor (volume);
}

void KMPlayerView::updateVolume (float v) {
    m_inVolumeUpdate = true;
    printf("updateVolume %.4f\n", v);
    m_slider->setValue (int (sqrt(v*10000.0/4)));
    m_inVolumeUpdate = false;
}

void KMPlayerView::timerEvent (QTimerEvent * e) {
    killTimer (e->timerId ());
    delayed_timer = 0;
    if (m_layer->hasMouse () && m_layer->mapFromGlobal (QCursor::pos ()).y () > m_layer->height () - button_height)
        m_buttonbar->show ();
}

void KMPlayerView::addText (const QString & str) {
    m_multiedit->append (str);
}

void KMPlayerView::print (QPrinter *pPrinter)
{
    QPainter printpainter;
    printpainter.begin (pPrinter);

    // TODO: add your printing code here

    printpainter.end ();
}

void KMPlayerView::startsToPlay () {
    m_multiedit->hide ();
    m_playing = true;
    if (m_auto_hide_buttons) {
        m_buttonbar->hide ();
        m_viewer->setMouseTracking (true);
        m_viewer->parentWidget ()->setMouseTracking (true);
    }
}

void KMPlayerView::showPopupMenu () {
    updateVolume(m_svc.scaleFactor());
    m_popupMenu->exec (m_configButton->mapToGlobal (QPoint (0, button_height)));
}

void KMPlayerView::leaveEvent (QEvent *) {
    if (m_auto_hide_buttons && m_playing)
        m_buttonbar->hide ();
}

void KMPlayerView::reset () {
    m_playing = false;
    if (m_auto_hide_buttons) {
        m_buttonbar->show ();
        m_viewer->setMouseTracking (false);
        m_viewer->parentWidget ()->setMouseTracking (false);
    }
    m_multiedit->hide ();
    if (m_show_console_output) {
        m_multiedit->show ();
        m_multiedit->resize (m_viewer->width (), m_viewer->height ());//Qt bug?
    }
    m_viewer->show ();
}
//----------------------------------------------------------------------

KMPlayerViewer::KMPlayerViewer (QWidget *parent, KMPlayerView * view)
  : QWidget (parent), m_aspect (0.0),
    m_view (view),
    m_mouse_tracking_pos (0x7fffffff) {
    /*XWindowAttributes xwa;
    XGetWindowAttributes (qt_xdisplay(), winId (), &xwa);
    XSetWindowAttributes xswa;
    xswa.background_pixel = 0;
    xswa.border_pixel = 0;
    xswa.colormap = xwa.colormap;
    create (XCreateWindow (qt_xdisplay (), parent->winId (), 0, 0, 10, 10, 0, 
                           x11Depth (), InputOutput, (Visual*)x11Visual (),
                           CWBackPixel | CWBorderPixel | CWColormap, &xswa));*/
    setEraseColor (QColor (0, 0, 0));
}

KMPlayerViewer::~KMPlayerViewer () {
    printf ("KMPlayerViewer::~KMPlayerViewer\n");
}
    
void KMPlayerViewer::showEvent (QShowEvent *) {
    printf ("show\n");
    QWidget * w = static_cast <QWidget *> (parent ());
    QResizeEvent ev (w->size (), w->size ());
    QApplication::sendEvent (w, &ev);
    QWidget * parent = parentWidget ();
    XConfigureEvent c = {
        ConfigureNotify, 0UL, True,
        qt_xdisplay (), winId (), parent->winId (),
        0, 0, parent->width (), parent->height (),
        0, None, False
    };
    XSendEvent(qt_xdisplay(), c.event, TRUE, StructureNotifyMask, (XEvent*) &c);
    XFlush (qt_xdisplay ());
}

void KMPlayerViewer::hideEvent (QHideEvent *) {
    printf ("hide\n");
}

void KMPlayerViewer::mouseMoveEvent (QMouseEvent * e) {
    if (e->state () == Qt::NoButton) {
        if (e->y () > m_mouse_tracking_pos)
            m_view->delayedShowButtons ();
        else
            m_view->buttonBar ()->hide ();
    }
}

void KMPlayerViewer::setAspect (float a) {
    m_aspect = a;
    QWidget * w = static_cast <QWidget *> (parent ());
    QResizeEvent ev (w->size (), w->size ());
    QApplication::sendEvent (w, &ev);
}

int KMPlayerViewer::heightForWidth (int w) const {
    if (m_aspect <= 0.01)
        return 0;
    return int (w/m_aspect); 
}

bool KMPlayerViewer::x11Event (XEvent * e) {
    switch (e->type) {
        case UnmapNotify:
            if (e->xunmap.event == winId ()) {
                emit aboutToPlay ();
                hide();
            }
            break;
        case XKeyPress:
            printf ("key\n");
            break;
        case ColormapNotify:
            printf ("colormap notify\n");
            return true;
        /*case MapNotify:
            show();
            return true;
        case ConfigureNotify:
            break;
            //return true;*/
        default:
            break;
    }
    return false;
}

#include "kmplayerview.moc"
