/***************************************************************************
                          kmplayerconfig.h  -  description
                             -------------------
    begin                : 2002/12/30
    copyright            : (C) |2002| by Koos Vriezen
    email                : |EMAIL|
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KMPLAYERCONFIG_H_
#define _KMPLAYERCONFIG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>


class KMPlayer;
class KConfig;
class ConfigDialog;

class KMPlayerConfig : public QObject {
    Q_OBJECT
public:
    KMPlayerConfig (KMPlayer *, KConfig * part);
    ~KMPlayerConfig ();
    bool sizeratio;
    bool showconsole;
    bool loop;
    bool showbuttons;
    bool showcnfbutton;
    bool autohidebuttons;
    bool showdvdmenu;
    bool showvcdmenu;
    bool playdvd;
    bool playvcd;
    int seektime;
    int cachesize;
    QString videodriver;
    QString dvddevice;
    QString vcddevice;
    QString additionalarguments;
    QString sizepattern;
    QString cachepattern;
    QString startpattern;
    QString langpattern;
    QString titlespattern;
    QString subtitlespattern;
    QString chapterspattern;
    QString trackspattern;
signals:
    void configChanged ();
public slots:
    void readConfig ();
    void writeConfig ();
    void show ();
private slots:
    void okPressed ();
    void fileOpen ();
    void getHelp ();
private:
    ConfigDialog * configdialog;
    KConfig * m_config;
    KMPlayer * m_player;
};

#endif //_KMPLAYERCONFIG_H_
