/***************************************************************************
                          ktransferkioimpl.cpp  -  description
                             -------------------
    begin                : Sun Nov 5 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.10 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef ENABLE_KIO

#include <kapp.h>
#include <assert.h>
#include <kio/jobclasses.h>

#ifdef KDE_VERSION_POST_1207
#include <kio/slave.h>
#else
#include "slave.h"
#endif

#include <kdebug.h>
#include <qfileinfo.h>
#include <qdir.h>
#include "krootcontainerimpl.h"
#include "ktmanagerimpl.h"
#include "ktransferkioimpl.h"


KTransferKioImpl::KTransferKioImpl(int type) 
   : KTransferImpl(type), _job(0), _startDownload(false), _oldPartial(0)
{
   // connect timer signal for retry timeout
   connect(&_waitRetry, SIGNAL(timeout()),
	   SLOT(slotRetryTimeout()));
}

KTransferKioImpl::~KTransferKioImpl()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
   kdWarning(_job != 0, D_RUN) << name() << ": job != 0" << endl;
}

KObjectImpl* KTransferKioImpl::clone() const 
{
   return new KTransferKioImpl(type());
}

void KTransferKioImpl::loadData()
{
   KTransferImpl::loadData();
   kdDebug(D_INI) << name() << ": kio loadData" << endl;
   if (!dom().hasAttribute("DisableCookie"))
   {
      dom().setAttribute("DisableCookie", 0);
   }
   _cfg_disableCookie = dom().attribute("DisableCookie", 
					QString::number(false)).toInt();
}

KURL KTransferKioImpl::getTempFile(const KURL &rmt, const KURL &) const 
{
   KURL tmp;
   tmp.setPath(QFileInfo(
		  dynamic_cast<KTManagerImpl*>(container())->getWorkingDir(), 
		  rmt.fileName()).absFilePath());
   return tmp;
}

bool KTransferKioImpl::isProtocolSupported(const QString &proto) const 
{
   return (proto == "ftp" || proto == "http" || proto == "https");
}

const KTransferKioImpl * KTransferKioImpl::global() const 
{
   return dynamic_cast<const KTransferKioImpl*>(KTransferImpl::global());
}

void KTransferKioImpl::startJob(unsigned long offset, bool resumeOrAbort) 
{
   kdFatal(_job != 0, D_RUN) << name() << ": start job != 0" << endl;
   _startDownload = true;
   _job = new KTransferJob(remote(), tmp(), offset, resumeOrAbort, getDisableCookie());
   if (_job == 0) 
   {
      kdError(D_RUN) << name() << ": start job null" << endl;
      //FIXME messaggio di errore
      return;
   }
   connect(_job, SIGNAL(result(KIO::Job *)),
	   SLOT(slotResult(KIO::Job*)));
   //connect(_job, SIGNAL(connected(KIO::Job*)),
   //	    SLOT(slotConnected(KIO::Job*)));
   connect(_job, SIGNAL(totalSize(KIO::Job*, unsigned long)),
	   SLOT(slotTotalSize(KIO::Job*, unsigned long)));
   connect(_job, SIGNAL(processedSize(KIO::Job*, unsigned long)),
	   SLOT(slotProcessedSize(KIO::Job*, unsigned long)));
   connect(_job, SIGNAL(infoMessage(KIO::Job*, const QString &)),
	   SLOT(slotInfoMessage(KIO::Job*, const QString &)));
   connect(_job, SIGNAL(sigCanResume(bool)),
	   SLOT(slotCanResume(bool)));
   connect(_job, SIGNAL(sigConnect()),
	   SLOT(slotConnect()));
   connect(_job, SIGNAL(sigDownload()),
	   SLOT(slotDownload()));
}

bool KTransferKioImpl::processStart() 
{
   if (_job != 0)
   {
      kdWarning(D_RUN) << name() << ": processStart job != 0" << endl;
      _job = 0;
   }

   // move working file to temporary .part
   QString tmpfile = tmp().path();
   if (QDir::current().exists(tmpfile)) 
   {
      kdDebug(D_RUN) << name() << ": move " << tmpfile << " to .part" << endl;
      QDir::current().rename(tmpfile, tmpfile + ".part");
   }
   opProcessStart();
   startJob(0, true);
   return _job != 0;
}

bool KTransferKioImpl::processKill() 
{
   if (_job) 
   {
      _job->kill(false);
   } 
   _waitRetry.stop();
   return true;
}

void KTransferKioImpl::processCheckResumeBegin() 
{
   // saving current data
   _oldPartial = partial();
   QString tmpfile = tmp().path();
   QString tmpfileSave = tmpfile + ".tmp";
   if (QDir::current().exists(tmpfile))
      QDir::current().rename(tmpfile, tmpfileSave);

   // prepare a fake tmp to resume from

   // create a new tmp part file
   QFile f(tmpfile + ".part");
   f.open(IO_WriteOnly | IO_Append);
   char buffer[20];
   f.writeBlock(buffer, 20);
   f.close();
   setPartial(20);
}

void KTransferKioImpl::processCheckResumeEnd()
{
   // restoring previous data
   QString tmpfile = tmp().path();
   QString tmpfileSave = tmpfile + ".tmp";
   setPartial(_oldPartial);
   QDir::current().remove(tmpfile);
   QDir::current().remove(tmpfile + ".part");
   if (QDir::current().exists(tmpfileSave))
      QDir::current().rename(tmpfileSave, tmpfile);
}

//////////// SLOTS

void KTransferKioImpl::slotResult(KIO::Job *job) 
{
   kdFatal(job != _job, D_RUN) << name() << ": slotResult unknown job" << endl;
   kdDebug(D_RUN) << name() << ": job finish" << endl;
   QString tmpfile = tmp().path();
   unsigned int size = QFileInfo(tmpfile + ".part").size();
   if (size > (unsigned int)partial())
      opDataRead(size - partial());
   bool killed = false;
   setState(TRN_END_OK);
   if (_job->error()) 
   {
      kdDebug(D_RUN) << name() << ": job exit with error " << _job->errorText() << endl;
      bool error = false;
      switch (_job->error()) 
      {
      case KIO::ERR_CANNOT_RESUME:
	 opCheckResume(RSM_NO);
	 killed = true;
	 break;
#ifndef KDE_VERSION_POST_1207
//FIXME!! hack for misbehaviour in kio ftp
      case KIO::ERR_COULD_NOT_READ:
	 if (rsmState() == RSM_CHECKING) 
	 {
	    opCheckResume(RSM_NO);
	    killed = true;
	 } 
	 else
	    error = true;
	 break;
#endif
      case KIO::ERR_USER_CANCELED:
	 killed = true;
	 break;
      default:
	 error = true;
	 break;
      }
      if (rsmState() == RSM_CHECKING)
	 opCheckResume(RSM_CHECKFAIL);
      if (error)
      {
	 setState(TRN_END_ERROR);
	 opError(_job->errorString().stripWhiteSpace());
      }
      if (killed)
	 setState(TRN_END_KILL);
   }
   //if (_job->error() == 0 || retry() >= getMaxRetry() || killed || cmdStatus() == CMD_FATALERROR) {
   if (QDir::current().exists(tmpfile + ".part"))
      QDir::current().rename(tmpfile + ".part", tmpfile);
   opProcessEnd(_job->error());
   //}
   _job = 0;
}

//void KTransferKioImpl::slotConnected(KIO::Job *) 
//{
//  opConnect();
//}

void KTransferKioImpl::slotTotalSize(KIO::Job*, unsigned long size) 
{
   setLen(size);
}

void KTransferKioImpl::slotProcessedSize(KIO::Job*, unsigned long size) 
{
   opDataRead(size - partial());
}

void KTransferKioImpl::slotInfoMessage(KIO::Job*, const QString &msg) 
{
   opProcessOutput(msg + '\n');
}

void KTransferKioImpl::slotRetryTimeout() 
{
   processStart();
}

void KTransferKioImpl::slotConnect() 
{
   opConnect();
}

void KTransferKioImpl::slotDownload() 
{
   opDownload();
}

void KTransferKioImpl::slotCanResume(bool canResume) 
{
   opCheckResume( canResume ? RSM_YES : RSM_NO );
}

// config

bool KTransferKioImpl::getDisableCookie() const
{
   return useGlobal() ? global()->getDisableCookie() : _cfg_disableCookie;
}

void KTransferKioImpl::setDisableCookie(bool v)
{
   if (_cfg_disableCookie != v)
   {
      _cfg_disableCookie = v;
      dom().setAttribute("DisableCookie", _cfg_disableCookie);
      setMod(MDI_TRK_CFG_COOKIE);
      root()->setModified();
   }
}

//////////////////////////////////////////////////////////////////////

int KTransferJob::_cnt = 0;

KTransferJob::KTransferJob(const KURL &src, const KURL &dest, 
			   unsigned long srcOffset, bool resumeOrAbort, 
			   bool disableCookie) 
   : SimpleJob("", 0, QByteArray(), false), _src(src), _dest(dest), 
     _canResume(false), _resumeAnswerSent(false), _resumeOrAbort(resumeOrAbort), 
     _disableCookie(disableCookie), _srcOffset(srcOffset), _totalSize(0), 
     _getJob(0), _putJob(0) 
{
   setName(QString("KTransferJob-%1").arg(_cnt++));
   // create put job
   bool resume = QDir::current().exists(dest.path());
   _putJob = KIO::put(_dest, -1, false, resume, false);
   kdDebug(D_RUN) << name() << ": create put job " << _putJob << endl;
   connect(_putJob, SIGNAL(canResume(KIO::Job*, unsigned long)),
	   SLOT(slotCanResume(KIO::Job*, unsigned long)));
   connect(_putJob, SIGNAL(dataReq(KIO::Job*, QByteArray&)),
	   SLOT(slotDataReq(KIO::Job*, QByteArray&)));
   addSubjob(_putJob);
   // now wait for signal canResume from put
}

KTransferJob::~KTransferJob()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
}

void KTransferJob::connectSubjob(KIO::SimpleJob *job) 
{
   connect(job, SIGNAL(totalSize(KIO::Job*, unsigned long)),
	   SLOT(slotTotalSize(KIO::Job*, unsigned long)));
   connect(job, SIGNAL(processedSize(KIO::Job*, unsigned long)),
	   SLOT(slotProcessedSize(KIO::Job*, unsigned long)));
   connect(job, SIGNAL(percent(KIO::Job*, unsigned long)),
	   SLOT(slotPercent(KIO::Job*, unsigned long)));
}

// slots

void KTransferJob::slotCanResume(KIO::Job *job, unsigned long offset) 
{
   if (job == _putJob) 
   {
      kdDebug(D_RUN) << name() << ": put job resume from " << offset << endl;
      _getJob = KIO::get(_src, false, false);
      if (_disableCookie)
	 _getJob->addMetaData("cookies", "none");
      kdDebug(D_RUN) << name() << ": create get job " << _getJob << endl;
      // if _srcOffset != 0 we have a source offset != from the dest offset
      if (_srcOffset == 0)
	 _srcOffset = offset;
      if (_srcOffset) 
      {
	 kdDebug(D_RUN) << name() << ": ask to get to resume from " << _srcOffset << endl;
	 _getJob->addMetaData("resume", QString::number(_srcOffset));
	 connect(_getJob, SIGNAL(canResume(KIO::Job*, unsigned long)),
		 SLOT(slotCanResume(KIO::Job*, unsigned long)));
      } 
      else 
      {
	 // if we don't resume, _canResume is false but we don't have to abort
	 _resumeOrAbort = false;
      }
      _putJob->suspend();
      addSubjob(_getJob);
      connectSubjob(_getJob);
      _getJob->resume();
      connect(_getJob, SIGNAL(data(KIO::Job*, const QByteArray&)),
	      SLOT(slotData(KIO::Job*, const QByteArray&)));
      emit sigConnect();
   } 
   else if (job == _getJob) 
   {
      kdDebug(D_RUN) << name() << ": get job can resume" << endl;
      _canResume = true;
   } 
   else 
   {
      kdFatal(D_RUN) << name() << ": slotCanResume from unknown job" << endl;
   }
}

void KTransferJob::slotData(KIO::Job*, const QByteArray &data) 
{
   kdDebug(D_RUN) << name() << ": data " << data.size() << endl;
   kdFatal(_getJob == 0) << name() << ": put or get null" << endl;
   if (!_resumeAnswerSent) 
   {
      // first run of slotData
      // if we are trying to resume, send back the resume state
      if (_resumeOrAbort && !_canResume) 
      {
	 // if we can't resume, we have to abort the the transfer
	 _putJob->kill(true);
	 _getJob->kill(true);
	 m_error = KIO::ERR_CANNOT_RESUME;
	 emitResult();
	 return;
      }
      _resumeAnswerSent = true;
      emit sigDownload();
      kdDebug(D_RUN) << name() << ": send resume answer to put " << endl;
      // restart from 0 if we can't resume, or from the end if we can
      _putJob->slave()->sendResumeAnswer(_canResume);
      // signal the resume state
      if (_srcOffset != 0)
	 emit sigCanResume(_canResume);
   }
   _getJob->suspend();
   _putJob->resume();
   _buffer = data;
}

void KTransferJob::slotDataReq(KIO::Job*, QByteArray &data) 
{
   if (!_resumeAnswerSent && !_getJob) 
   {
      m_error = KIO::ERR_INTERNAL;
      m_errorText = "'Put' job didn't send canResume or 'Get' job didn't send data";
      _putJob->kill(true);
      _buffer = QByteArray(); //FIXME?
      emitResult();
      return;
   }
   if (_getJob) 
   {
      _getJob->resume();
      _putJob->suspend();
   }
   data = _buffer;
   _buffer = QByteArray();
}

void KTransferJob::slotResult(KIO::Job* job) 
{
   kdDebug(D_RUN) << name() << ": slotResult " << job << endl;
   if (job->error()) 
   {
      if (job == _getJob) 
      {
	 _getJob = 0;
	 if (_putJob)
	    _putJob->kill(true);
      } 
      else if (job == _putJob) 
      {
	 _putJob = 0;
	 if (_getJob)
	    _getJob->kill(true);
      }
      m_error = job->error();
      m_errorText = job->errorText();
      kdDebug(D_RUN) << name() << ": error in " << (job == _getJob ? "get" : "put" ) << endl;
      emitResult();
      return;
   }
   m_error = 0;
   if (job == _getJob) 
   {
      kdDebug(D_RUN) << name() << ": get job finished" << endl;
      _getJob = 0;
      if (_putJob)
	 _putJob->resume();
   } 
   else if (job == _putJob) 
   {
      kdDebug(D_RUN) << name() << ": put job finished" << endl;
      _putJob = 0;
      if (_getJob != 0) 
      {
	 kdWarning(D_RUN) << name() << ": end put while get still running" << endl;
	 _getJob->resume();
      }
   }
   removeSubjob(job);
}

void KTransferJob::slotProcessedSize(KIO::Job*, unsigned long size) 
{
   emit processedSize(this, size);
   if (size > _totalSize)
      slotTotalSize(this, size);
}

void KTransferJob::slotTotalSize(KIO::Job*, unsigned long size) 
{
   _totalSize = size;
   emit totalSize(this, _totalSize);
}

void KTransferJob::slotPercent(KIO::Job*, unsigned long pct) 
{
   if (pct > m_percent) 
   {
      m_percent = pct;
      emit percent(this, m_percent);
   }
}

#include "ktransferkioimpl.moc"

#endif
