/***************************************************************************
                          ktmanagerlistview.cpp  -  description
                             -------------------
    begin                : Wed Dec 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.12 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qtextstream.h>
#include <klocale.h>
#include <kmainwindow.h>
#include "utils.h"
#include "kmagodoc.h"
#include "kmagoview.h"
#include "ktmanagerlistview.h"

KTManagerListView::KTManagerListView(KMagoDoc *doc, Callback cb, 
				     QWidget *parent, const char *name)
   : KListView(parent, name), KContainerView(doc, cb, KContainer::null()) 
{
   setAcceptDrops(true);
   setDragEnabled(true);
   setShowSortIndicator(true);
   setAllColumnsShowFocus(true);
   setDropVisualizer(false);
   setMinimumSize(0, 0);

   connect(this, SIGNAL(dropped(QDropEvent*, QListViewItem*)),
	   this, SLOT(slotDropped(QDropEvent*, QListViewItem*)));
   //connect(this, SIGNAL(executed(QListViewItem*)),
   //	  this, SLOT(slotExecuted(QListViewItem*)));
   connect(this, SIGNAL(selectionChanged(QListViewItem*)),
	   this, SLOT(slotSelectionChanged(QListViewItem*)));
   connect(this, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)),
	   this, SLOT(slotContextMenu(KListView*, QListViewItem*, 
				      const QPoint&)));
   // init actions
   initActions();

   _sortIdx[0] = MDI_TRN_STATE;
   _sortIdx[1] = MDI_TRN_REMOTE;
   _sortIdx[2] = MDI_TRN_LOCAL;
   _sortIdx[3] = MDI_TRN_RSMSTATE;
   _sortIdx[4] = MDI_TRN_PARTIAL;
   _sortIdx[5] = MDI_TRN_PARTIAL;
   _sortIdx[6] = MDI_TRN_PARTIAL;
   _sortIdx[7] = MDI_TRN_LEN;
   _sortIdx[8] = MDI_BAND;
   _sortIdx[9] = MDI_BAND;
   _sortIdx[11] = MDI_ID;
   _sortIdx[12] = MDI_ID;
   _sortIdx[13] = MDI_ERROR;
}

KTManagerListView::~KTManagerListView()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
}

void KTManagerListView::initActions() 
{
   _viewState = new KToggleAction(i18n("Show State"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "tview_state");
   _viewURL = new KToggleAction(i18n("Show URL"),
				0, this, SLOT(slotInitView()),
				doc()->mainWindow()->actionCollection(), 
				"tview_url");
   _viewLocal = new KToggleAction(i18n("Show Local Filename"),
				0, this, SLOT(slotInitView()),
				doc()->mainWindow()->actionCollection(), 
				"tview_local");
   _viewResuming = new KToggleAction(i18n("Show Resuming"),
				     0, this, SLOT(slotInitView()),
				     doc()->mainWindow()->actionCollection(), 
				     "tview_resuming");
   _viewPercent = new KToggleAction(i18n("Show Percent"),
				    0, this, SLOT(slotInitView()),
				    doc()->mainWindow()->actionCollection(), 
				  "tview_percent");
   _viewTime = new KToggleAction(i18n("Show Est.Time"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "tview_time");
   _viewPartial = new KToggleAction(i18n("Show Partial"),
				    0, this, SLOT(slotInitView()),
				    doc()->mainWindow()->actionCollection(), 
				    "tview_partial");
   _viewLen = new KToggleAction(i18n("Show Length"),
				0, this, SLOT(slotInitView()),
				doc()->mainWindow()->actionCollection(), 
				"tview_len");
   _viewBand = new KToggleAction(i18n("Show Bandwidth"),
				 0, this, SLOT(slotInitView()),
				 doc()->mainWindow()->actionCollection(), 
				 "tview_band");
   _viewMBand = new KToggleAction(i18n("Show Medium Bandwidth"),
				  0, this, SLOT(slotInitView()),
				  doc()->mainWindow()->actionCollection(), 
				  "tview_mband");
   _viewPriority = new KToggleAction(i18n("Show Priority"),
				     0, this, SLOT(slotInitView()),
				     doc()->mainWindow()->actionCollection(), 
				     "tview_priority");
   _viewID = new KToggleAction(i18n("Show ID"),
			       0, this, SLOT(slotInitView()),
			       doc()->mainWindow()->actionCollection(), 
			       "tview_id");
   _viewType = new KToggleAction(i18n("Show Type"),
				 0, this, SLOT(slotInitView()),
				 doc()->mainWindow()->actionCollection(), 
				 "tview_type");
   _viewError = new KToggleAction(i18n("Show Error"),
				 0, this, SLOT(slotInitView()),
				 doc()->mainWindow()->actionCollection(), 
				 "tview_error");
   _viewStateStr = new KToggleAction(i18n("Show State String"),
					  0, this, SLOT(slotShowStateStr()),
					  doc()->mainWindow()->actionCollection(),
					  "tview_statestr");
}

void KTManagerListView::initView() 
{
   while (columns())
      removeColumn(0);
   int i = 0;
   if (_viewState->isChecked())
   {
      addColumn("State");
      _columnMap[i++] = 0;
   }
   if (_viewURL->isChecked())
   {
      addColumn("URL", 150);
      _columnMap[i++] = 1;
   }
   if (_viewLocal->isChecked())
   {
      addColumn("Local Filename", 150);
      _columnMap[i++] = 2;
   }
   if (_viewResuming->isChecked())
   {
      addColumn("Resuming", fontMetrics().width(" ---:00"));
      _columnMap[i++] = 3;
   }
   if (_viewPercent->isChecked())
   {
      addColumn("%", fontMetrics().width(" 000"));
      _columnMap[i++] = 4;
   }
   if (_viewTime->isChecked())
   {
      addColumn("Est.Time", fontMetrics().width(" 00:00:00"));
      _columnMap[i++] = 5;
   }
   if (_viewPartial->isChecked())
   {
      addColumn("Partial", fontMetrics().width(" 0.00B"));
      _columnMap[i++] = 6;
   }
   if (_viewLen->isChecked())
   {
      addColumn("Len", fontMetrics().width(" 0.00B"));
      _columnMap[i++] = 7;
   }
   if (_viewBand->isChecked())
   {
      addColumn("Band", fontMetrics().width(" 0.00B"));
      _columnMap[i++] = 8;
   }
   if (_viewMBand->isChecked())
   {
      addColumn("MBand", fontMetrics().width(" 0.00B"));
      _columnMap[i++] = 9;
   }
   if (_viewPriority->isChecked())
   {
      addColumn("Priority", fontMetrics().width(" 000"));
      _columnMap[i++] = 10;
   }
   _sortIdx[10] = MDI_PRIORITY;
   if (_viewID->isChecked())
   {
      addColumn("ID", fontMetrics().width("00000"));
      _columnMap[i++] = 11;
   }
   if (_viewType->isChecked())
   {
      addColumn("Type", fontMetrics().width(" XXXX"));
      _columnMap[i++] = 12;
   }
   if (_viewError->isChecked())
   {
      addColumn("Error", fontMetrics().width("XXXXXXXXXXXXXXXXXXXXXXXXXXX"));
      _columnMap[i++] = 13;
   }

   int j;
   for (j = 0; j < i && _columnMap[j] != _sortByCol; ++j);
   if (j < i)
      setSorting(_sortByCol, _sortDir);
   else
      setSorting(0);
}

void KTManagerListView::setSorting(int column, bool increasing)
{
   KListView::setSorting(column, increasing);
   _sortBy = _sortIdx[column];
   _sortByCol = column;
   _sortDir = increasing;
}

void KTManagerListView::setSortBy(ModIndex p, bool increasing)
{
   kdFatal(D_VIE) << name() << ": setSortBy : operation not defined" << endl;
   _sortBy = p;
   _sortDir = increasing;
}

QDragObject * KTManagerListView::dragObject() const 
{
   KTransfer item = doc()->currentTransfer();
   if (!transferDragEnabled(item))
      return 0;
   kdDebug(D_RUN) << name() << ": new drag" << item.name() << endl;
   KTransferListDrag *drag = new KTransferListDrag(const_cast<KTManagerListView*>(this));
   drag->setPixmap(DesktopIcon("document"));
   drag->append(item);
   /*
     if (drag->drag() && dragObj->target() != 0)
     kdDebug(D_RUN) << name() << ": drag move" << endl;
     else
     kdDebug(D_RUN) << name() << ": drag copy" << endl;
   */
   return drag;
}

bool KTManagerListView::acceptDrag(QDropEvent *event) const 
{
   //kdDebug(D_RUN) << name() << ": acceptDrag " << (source ? source->container().name() : QString::null) << " -> " << container().name() << endl;
   return (KContainerView::acceptDrop(event, container())
	   && transferCanDecode(event));
}

KTManagerListItem * KTManagerListView::itemFind(KObject item) const 
{
   kdFatal(item.isNull(), D_VIE) << name() << ": find null item" << endl;
   KTManagerListItem *i;
   for (i = dynamic_cast<KTManagerListItem*>(firstChild());
	i != 0 && i->transfer() != item;
	i = dynamic_cast<KTManagerListItem*>(i->nextSibling()));
   kdError(i == 0, D_VIE) << name() << ": item not found " << item.id() << endl;
   return i;
}

KObject KTManagerListView::itemFirst() const
{
   KTManagerListItem *i = dynamic_cast<KTManagerListItem*>(firstChild());
   if (i == 0)
      return KObject::null();
   return i->transfer();
}

KObject KTManagerListView::itemBelow(KObject item) const
{
   KTManagerListItem *i = itemFind(item);
   KTManagerListItem *b = dynamic_cast<KTManagerListItem*>(i->itemBelow());
   if (b == 0)
      return KObject::null();
   return b->transfer();
}

KObject KTManagerListView::itemAbove(KObject item) const
{
   KTManagerListItem *i = itemFind(item);
   KTManagerListItem *b = dynamic_cast<KTManagerListItem*>(i->itemAbove());
   if (b == 0)
      return KObject::null();
   return b->transfer();
}

void KTManagerListView::itemAdd(KObject item) 
{
   new KTManagerListItem(this, item.toTransfer());
}

void KTManagerListView::itemRemove(KObject item) 
{
   delete itemFind(item);
}

void KTManagerListView::itemSelect(KObject item) 
{
   if (item.isNull())
      clearSelection();
   else
      setSelected(itemFind(item), true);
}

void KTManagerListView::itemUpdate(KObject item) 
{
   if (item.isMod(sortBy()))
   {
      // reset view
      reset();
   }
   else
   {
      KTManagerListItem *i = itemFind(item);
      if (i != 0)
      {
	 i->update();
	 i->repaint();
      }
   }
}

void KTManagerListView::itemUpdateText(KObject item) 
{
   if (item.isMod(sortBy()))
   {
      // reset view
      reset();
   }
   else
   {
      KTManagerListItem *i = itemFind(item);
      if (i != 0)
      {
	 i->repaint();
      }
   }
}

int KTManagerListView::column(int i) const 
{
   return _columnMap[i];
}

void KTManagerListView::applySettings(KConfig *config) 
{
   _viewState->setChecked(config->readBoolEntry("TManagerListView State", true));
   _viewURL->setChecked(config->readBoolEntry("TManagerListView URL", true));
   _viewLocal->setChecked(config->readBoolEntry("TManagerListView Local", true));
   _viewResuming->setChecked(config->readBoolEntry("TManagerListView Resuming", 
						   true));
   _viewPercent->setChecked(config->readBoolEntry("TManagerListView Percent", 
						  true));
   _viewTime->setChecked(config->readBoolEntry("TManagerListView Time", true));
   _viewPartial->setChecked(config->readBoolEntry("TManagerListView Partial", 
						  true));
   _viewLen->setChecked(config->readBoolEntry("TManagerListView Len", true));
   _viewBand->setChecked(config->readBoolEntry("TManagerListView Band", true));
   _viewMBand->setChecked(config->readBoolEntry("TManagerListView MBand", true));
   _viewPriority->setChecked(config->readBoolEntry("TManagerListView Priority", 
						   true));
   _viewType->setChecked(config->readBoolEntry("TManagerListView Type", true));
   _viewID->setChecked(config->readBoolEntry("TManagerListView ID", true));
   _viewError->setChecked(config->readBoolEntry("TManagerListView Error", true));
   _viewStateStr->setChecked(config->readBoolEntry("TManagerListView StateStr", 
	 					   true));
   _sortByCol = config->readNumEntry("TManagerListView SortBy", 0);
   _sortDir = config->readBoolEntry("TManagerListView SortDir", true);
}   

void KTManagerListView::saveSettings(KConfig *config)
{
   config->writeEntry("TManagerListView State", _viewState->isChecked());
   config->writeEntry("TManagerListView URL", _viewURL->isChecked());
   config->writeEntry("TManagerListView Local", _viewLocal->isChecked());
   config->writeEntry("TManagerListView Resuming", _viewResuming->isChecked());
   config->writeEntry("TManagerListView Percent", _viewPercent->isChecked());
   config->writeEntry("TManagerListView Time", _viewTime->isChecked());
   config->writeEntry("TManagerListView Partial", _viewPartial->isChecked());
   config->writeEntry("TManagerListView Len", _viewLen->isChecked());
   config->writeEntry("TManagerListView Band", _viewBand->isChecked());
   config->writeEntry("TManagerListView MBand", _viewMBand->isChecked());
   config->writeEntry("TManagerListView Priority", _viewPriority->isChecked());
   config->writeEntry("TManagerListView Type", _viewType->isChecked());
   config->writeEntry("TManagerListView ID", _viewID->isChecked());
   config->writeEntry("TManagerListView Error", _viewError->isChecked());
   config->writeEntry("TManagerListView StateStr", _viewStateStr->isChecked());
   config->writeEntry("TManagerListView SortBy", _sortByCol);
   config->writeEntry("TManagerListView SortDir", _sortDir);
}

// slots

void KTManagerListView::slotDropped(QDropEvent *event, QListViewItem *) 
{
   dropTransferList(event, doc(), container());
}
/*
void KTManagerListView::slotExecuted(QListViewItem *) 
{
  mainView()->slotTransferStatus();
}
*/
void KTManagerListView::slotContextMenu(KListView *, QListViewItem *i,
					const QPoint &p) 
{
   if (i == 0)
      return;
   kdFatal(dynamic_cast<KTManagerListItem*>(i)->transfer() != doc()->currentTransfer()) << name() << " context menu" << endl;
   view()->transferMenu()->popup(p);
}

void KTManagerListView::slotSelectionChanged(QListViewItem * item) 
{
   //emit sigSelectionChanged(dynamic_cast<KTManagerListItem*>(item)->transfer());
   itemSelectionChanged(dynamic_cast<KTManagerListItem*>(item)->transfer());
}

void KTManagerListView::slotInitView()
{
   initView();
   reset();
}   

void KTManagerListView::slotShowStateStr()
{
   reset();
}

/////////////////////////////////////////////////////////////////////

KTManagerListItem::KTManagerListItem(KListView *parent, KTransfer tr)
   : QListViewItem(parent), t(tr) 
{
   update();
}

QString KTManagerListItem::text(int column) const 
{
   // this check is needed when a clear operation is done on container, as
   // all objects still visibles are destroyed
   if (t.isNull())
   {
      //kdWarning(D_VIE) << ": KTManagerListItem::text on null item" << endl;
      return QString::null;
   }
   KTManagerListView * view = dynamic_cast<KTManagerListView*>(listView());
   switch (view->column(column)) 
   {
      //#ifndef NTEST
      //  case 0: return QString("%1").arg(t.status(), 5, 16);
      //#else
   case 0: 
      if (view->showStateStr())
	 return t.stateStr();
      return QString::null;
      //#endif
   case 1:
      return t.remote().prettyURL();
   case 2:
      return t.local().fileName();
   case 3:
      return QString("%1:%2").arg(t.resumeStr()).arg(t.resumed());
   case 4:
      return QString("%1").arg(t.len() ? 100*t.partial()/t.len() : 0, 3);
   case 5:
      return t.estTime().toString();
   case 6:
      return unit(t.partial());
   case 7:
      return unit(t.len());
   case 8:
      return unit(t.bandwidth());
   case 9:
      return unit(t.mediumBandwidth());
   case 10:
      return QString("%1").arg(t.prioritySum(), 3);
   case 11:
      return QString("%1").arg(t.id(), 5);
   case 12:
      return KObject::typeStr(t.type());
   case 13:
      return t.message();
   default:
      kdFatal(D_VIE) << "TRANSFER COLUMN UNKNOWN" << endl;
   }
   return "";
}

QString KTManagerListItem::key(int column, bool) const 
{
   if (t.isNull())
   {
      //kdWarning(D_VIE) << ": KTManagerListItem::key on null item" << endl;
      return QString::null;
   }
   KTManagerListView * view = dynamic_cast<KTManagerListView*>(listView());
   switch (view->column(column)) 
   {
   case 1:
   case 2:
   case 3:
   case 4:
   case 5:
   case 12:
   case 13:
      return text(column);
   case 0:
      return t.stateStr();
   case 6:
      return QString("%1").arg(t.partial(), 15);
   case 7:
      return QString("%1").arg(t.len(), 15);
   case 8:
      return QString("%1").arg(t.bandwidth(), 10);
   case 9:
      return QString("%1").arg(t.mediumBandwidth(), 10);
   case 10:
      return QString("%1%2").arg(t.prioritySum(), 5).arg(t.id(), 6);
   case 11:
      return QString("%1").arg(t.id(), 6);
   }
   kdFatal(D_VIE) << "TRANSFER COLUMN UNKNOWN" << endl;
   return "";
}

void KTManagerListItem::update() 
{
   if (t.isNull())
   {
      //kdWarning(D_VIE) << ": KTManagerListItem::update on null item" << endl;
      return;
   }
   if (t.isComplete()) 
   {
      setPixmap(0, SmallIcon("player_eject"));
      return;
   }
   switch (t.state()) 
   {
   case TRN_READY:
   case TRN_END_READY:
      if (t.priority() > 0)
	 setPixmap(0, SmallIcon("run"));
      else
	 setPixmap(0, SmallIcon("lock"));
      break;
   case TRN_START:
      setPixmap(0, SmallIcon("connect_no"));
      break;
   case TRN_CONNECT:
      setPixmap(0, SmallIcon("connect_creating"));
      break;
   case TRN_DOWNLOAD:
      setPixmap(0, SmallIcon("connect_established"));
      break;
   case TRN_END_OK:
   case TRN_END_ERROR:
      setPixmap(0, SmallIcon("player_pause"));
      break;
   case TRN_END_KILL:
      setPixmap(0, SmallIcon("player_stop"));
      break;
   case TRN_END_FATAL:
      setPixmap(0, SmallIcon("stop"));
      break;
   default:
      kdFatal(D_VIE) << "KTManagerListView: unknown state " << t.state() << endl;
   }
}

#include "ktmanagerlistview.moc"
