/***************************************************************************
                          kmmanagerimpl.cpp  -  description
                             -------------------
    begin                : Wed Oct 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.18 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <qtextstream.h>
#include "utils.h"
#include "ktransferimpl.h"
#include "kfactoryimpl.h"
#include "ktmanagerimpl.h"
#include "kmmanagerimpl.h"

const char KMManagerImpl::DOCID[] = "MManager";
const char KMManagerImpl::DOCTYPE[] = "<!DOCTYPE MManager >";


KMManagerImpl::KMManagerImpl() 
   : KRootContainerImpl(TYP_MMANAGER), _downloadLock(false), _idle(false)
{
}

KObjectImpl * KMManagerImpl::clone() const 
{
   kdFatal(D_INI) << ": unable to clone root" << endl;
   return 0;
}

const KMManagerImpl * KMManagerImpl::global() const 
{
   const KMManagerImpl *globalmngr = 
      dynamic_cast<const KMManagerImpl*>(KObjectImpl::global());
   kdFatal( globalmngr != KObjectImpl::global(), D_INI) << name() << ": global has wrong type" << endl;
   return globalmngr; 
}

KTManagerImpl * KMManagerImpl::itemNew(const QString &title) 
{
   QString objDocId = KFactoryImpl::factory()->docId(TYP_TMANAGER);
   QString objTypeStr = KFactoryImpl::factory()->typeStr(TYP_TMANAGER);
   int objId = assignId();
   QString objStrId = 
      QString("%1-%2").arg(objTypeStr).arg(objId);
   kdDebug(D_INI) << name() << ": item new: " << objStrId << endl;
   QDomElement e = findDefault(TYP_TMANAGER)->dom().cloneNode(false).toElement();
   kdFatal(e.isNull(), D_INI) << name() << ": default null for TManager" << endl;
   domItems().appendChild(e);
   e.setAttribute("Id", objId);
   e.setAttribute("Name", objStrId);
   //e.setAttribute("Type", QString().setNum(TYP_TMANAGER));
   // itemType hardcoded in KTManagerImpl::loadData
   //e.setAttribute("ItemType", QString().setNum(TYP_FILE_TRANSFER_T));
   e.setAttribute("Title", title);
   return dynamic_cast<KTManagerImpl*>(itemLoad(e));
}

void KMManagerImpl::loadData() 
{
   dom().setAttribute("ItemType", TYP_TMANAGER_T);
   KRootContainerImpl::loadData();
   kdDebug(D_INI) << name() << ": MManager loadData" << endl;
   if (!dom().hasAttribute("DownloadLock"))
   {
      setDownloadLock(true);
      setMaxBandwidth(0);
      setMaxConnection(3);
   }
   _downloadLock = dom().attribute("DownloadLock", 
				   QString::number(true)).toInt();
   _cfg_maxBandwidth = dom().attribute("MaxBandwidth", 
				       QString::number(0)).toInt();
   _cfg_maxConnection = dom().attribute("MaxOpenConnection", 
					QString::number(3)).toInt();
   _bandwidth = 0;
   _mediumBandwidth = 0;
}

void KMManagerImpl::runPeriodically() 
{
   kdFatal(useGlobal() == true) << "normal = " << isNormal() << endl;
   KRootContainerImpl::runPeriodically();
}

void KMManagerImpl::startPendingTransfer() 
{
   KTransferImpl *best = 0;
   if (((_mediumBandwidth != 0 || _bandwidth != 0) && itemActiveCount() == 0)
       || (itemActiveCount() != 0))
   {
      setMod(MDI_BAND);
   }
   _bandwidth = 0;
   _mediumBandwidth = 0;
   int trActive = 0;
   bool runInFuture = false;
   for (Iterator it(*this); it.current(); ++it)
   {
      KTManagerImpl *m = dynamic_cast<KTManagerImpl*>(it.current());
      KTransferImpl *t = 0;
      if (m->priority() > 0)
	 t = m->selectForRunning(downloadLock(), runInFuture);
      if (t != 0 && (best == 0 || t->cmpPriority(best) == 1))
	 best = t;
      if (m->isRunning())
      {
	 _bandwidth += m->bandwidth();
	 _mediumBandwidth += m->mediumBandwidth();
	 trActive += m->itemActiveCount();
      }
   }
   setIdle(!(isRunning() || (!downloadLock() && runInFuture)));
   kdDebug(D_RUN) << name() << ": idle " << isIdle() << endl;
   if (!downloadLock() && best != 0 
       && (!getMaxBandwidth() || mediumBandwidth() < getMaxBandwidth())
       && (!getMaxConnection() || trActive < getMaxConnection()))
      best->start();
}

/////////// state entries

void KMManagerImpl::setDownloadLock(bool l)
{
   if (l != _downloadLock)
   {
      _downloadLock = l;
      dom().setAttribute("DownloadLock", _downloadLock);
      setMod(MDI_MMN_DLOCK);
      root()->setModified();
   }
}

void KMManagerImpl::setIdle(bool l)
{
   _idle = l;
   if (_idle)
      setMod(MDI_MMN_IDLE);
}

//////////// config entries

int KMManagerImpl::getMaxConnection() const 
{
   return useGlobal() ? global()->getMaxConnection() :_cfg_maxConnection;
}

void KMManagerImpl::setMaxConnection(int m)
{
   if (m != _cfg_maxConnection)
   {
      _cfg_maxConnection = m;
      dom().setAttribute("MaxOpenConnection", _cfg_maxConnection);
      setMod(MDI_CFG_MAXCONN);
      root()->setModified();
   }
}

int KMManagerImpl::getMaxBandwidth() const 
{
   return useGlobal() ? global()->getMaxBandwidth() :_cfg_maxBandwidth;
}

void KMManagerImpl::setMaxBandwidth(int v)
{
   if (_cfg_maxBandwidth != v)
   {
      _cfg_maxBandwidth = v;
      dom().setAttribute("MaxBandwidth", _cfg_maxBandwidth);
      setMod(MDI_CFG_MAXBAND);
      root()->setModified();
   }
}

#include "kmmanagerimpl.moc"
