/***************************************************************************
                          kmagoview.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.27 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmainwindow.h>
#include "utils.h"
#include "kcontainerview.h"
#include "kmmanagericonview.h"
#include "kmmanagerlistview.h"
#include "ktmanagerlistview.h"
#include "kmagoview.h"
#include "kmagodoc.h"


KMagoView::KMagoView(KMagoDoc *doc, QWidget *parent, const char *name) 
   : QSplitter(parent, name), _doc(doc), _managerView(0), _transferView(0) 
{
   //FIXME!! all the manager's views are created now, and only one is showed,
   //FIXME!! this is not a clean way to go, but destroying and re-creating views
   //FIXME!! brings problems on attributes-restoring
   _miv = new KMManagerIconView(doc->manager(), doc,
				&KMagoView::slotSetCurrentManager, this, 
				QString("%1-miconview").arg(name));
   setResizeMode(_miv, Stretch);
   _mlv = new KMManagerListView(doc->manager(), doc,
				&KMagoView::slotSetCurrentManager, this,
				QString("%1-mlistview").arg(name));
   setResizeMode(_mlv, Stretch);
   _mlv->hide();
   
   _managerView = dynamic_cast<KContainerView*>(_miv);

   _transferView = new KTManagerListView(doc, 
					 &KMagoView::slotSetCurrentTransfer, 
					 this, QString("%1-tview").arg(name));
   setResizeMode(dynamic_cast<QWidget*>(_transferView), Stretch);

   initActions();
}

KMagoView::~KMagoView() 
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
   //writeConfig();
}

void KMagoView::initMenu() 
{
   // to be called after createGUI
   _managerMenu = static_cast<KPopupMenu*>(
      doc()->mainWindow()->factory()->container("manager_popup", 
						doc()->mainWindow()));
   _transferMenu = static_cast<KPopupMenu*>(
      doc()->mainWindow()->factory()->container("transfer_popup", 
						doc()->mainWindow()));
}

void KMagoView::initActions()
{
   _managerViewMode = new KSelectAction(i18n("Manager View Mode"),
					0, this,
					SLOT(slotManagerViewMode()),
					doc()->mainWindow()->actionCollection(),
					"mview_mode");
   QStringList lst;
   lst << i18n("Icon View") << i18n("List View");
   _managerViewMode->setItems(lst);
   _managerViewMode->setCurrentItem(0); //FIXME save/restore settings

   _orientation = 
      new KToggleAction(i18n("Vertical Orientation"),
			0, this, SLOT(slotOrientation()),
			doc()->mainWindow()->actionCollection(), 
			"split_orientation");
   _orientation->setToolTip(i18n("Set view's orientation"));
}

void KMagoView::initView()
{
   QValueList<int> szs = sizes();
   if (_managerViewMode->currentItem() == 0)
   {
      _managerView = _miv;
      _mlv->hide();
      _mlv->clear();
      _miv->show();
      if (szs[0] == 1)
      {
	 szs[0] = szs[1];
	 szs[1] = 1;
	 setSizes(szs);
      }
   }
   else
   {
      _managerView = _mlv;
      _miv->hide();
      _miv->clear();
      _mlv->show();
      if (szs[1] == 1)
      {
	 szs[1] = szs[0];
	 szs[0] = 1;
	 setSizes(szs);
      }
   }
   managerView()->initView();
   transferView()->initView();
   managerView()->setContainer(doc()->manager());
   managerView()->itemSelect(doc()->currentManager());
   transferView()->reset();
   transferView()->itemSelect(doc()->currentTransfer());
}

KMagoDoc * KMagoView::doc() const 
{
   return _doc;
}

void KMagoView::reset() 
{
   kdDebug(D_VIE) << name() << ": reset view" << endl;
   managerView()->setContainer(doc()->manager());
   transferView()->setContainer(doc()->currentManager());
}

void KMagoView::showManagers(bool on) 
{ 
   //bool state = _lbManager->isVisible();
   //if (state == on)
   //  return;
   if (on) 
      dynamic_cast<QWidget*>(managerView())->show();
   else 
      dynamic_cast<QWidget*>(managerView())->hide();
}

void KMagoView::setOrientation(bool vert) 
{
   bool state = (orientation() == Vertical);
   if (vert == state)
      return;
   managerView()->setOrientation(vert);
   if (vert) 
   {
      QSplitter::setOrientation(Vertical);
      //_lbManager->setColumnMode(QListBox::FitToWidth);
   }  
   else 
   {
      QSplitter::setOrientation(Horizontal);
      //_lbManager->setColumnMode(1);
   }
}

void KMagoView::applySettings(KConfig *config)
{
   _managerViewMode->setCurrentItem(config->readNumEntry("ManagerViewMode", 0));
   _orientation->setChecked(config->readBoolEntry("Split Orientation", true));
   slotOrientation();
   setSizes(config->readIntListEntry("Splitter Sizes"));
   _miv->applySettings(config);
   _mlv->applySettings(config);
   transferView()->applySettings(config);
}

void KMagoView::saveSettings(KConfig *config)
{
   config->writeEntry("ManagerViewMode", _managerViewMode->currentItem());
   config->writeEntry("Split Orientation", _orientation->isChecked());
   config->writeEntry("Splitter Sizes", sizes());
   _miv->saveSettings(config);
   _mlv->saveSettings(config);
   transferView()->saveSettings(config);
}

// Slots

void KMagoView::slotSetCurrentManager(KObject item) 
{
   //FIXME replace with direct call to setCurrentManager
   kdDebug(D_VIE) << name() << ": highlight manager " << (item.isNull() ? -1 : item.id()) << endl;
   //transferView()->setContainer(item.toContainer());
   doc()->setCurrentManager(item.toTManager());
}

void KMagoView::slotSetCurrentTransfer(KObject item) 
{
   //FIXME replace with direct call to setCurrentTransfer
   kdDebug(D_VIE) << name() << ": highlight transfer " << (item.isNull() ? -1: item.id()) << endl;
   doc()->setCurrentTransfer(item.toTransfer());
}

void KMagoView::slotManagerViewMode()
{
   initView();
}

void KMagoView::slotOrientation() 
{
   setOrientation(_orientation->isChecked());
}

#include "kmagoview.moc"
