/***************************************************************************
                          kmago.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.40 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
//#include <qprinter.h>
//#include <qpainter.h>
#include <qclipboard.h>
#include <kurl.h>
#include <qfileinfo.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kdebug.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstdaction.h>
#include <qdragobject.h>
#include <qtooltip.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <qtextstream.h>
#include <assert.h>

// application specific includes
#include "utils.h"
#include "kcntiterator.h"
#include "ktmanager.h"
#include "ktransfer.h"
#include "kcontainerview.h"
#include "kdlgopenmanager.h"
#include "kdlgconfigure.h"
#include "kdlgtransferstatus.h"
#include "kdlgmanagerset.h"
#include "klogviewer.h"
#include "kdlgmanager.h"
#include "kdlgtransfer.h"
#include "ksystrayview.h"
#include "kdropper.h"
#include "kmago.h"
#include "kmagoview.h"
#include "kmagodoc.h"


const char KMagoApp::IDS_STATUS_DEFAULT[] = "Ready.";

KMagoApp::KMagoApp(bool restored) 
{
   setName(QString("App-%1").arg(memberList->count()));

   initActions();
   initStatusBar();
   initDocument();
   initView();
   createGUI();
   view()->initMenu(); // to call after createGUI
   initSysTray();

   connect(kapp->clipboard(), SIGNAL(dataChanged()), 
	   this, SLOT(slotClipboardChange()));

   // init state of actions
   fileDownloadLock->setChecked(false);
   //editCut->setEnabled(false);
   //editCopy->setEnabled(false);
   editPaste->setEnabled(false);
   viewToolBarMain->setChecked(true);
   viewToolBarTrn->setChecked(true);
   viewManagers->setChecked(true);
   viewSysTray->setChecked(false);
   managerClear->setEnabled(false);
   managerSetPriority->setEnabled(false);
   managerSetIncrPriority->setEnabled(false);
   managerSetDecrPriority->setEnabled(false);
   transferRemove->setEnabled(false);
   transferConf->setEnabled(false);
   transferLog->setEnabled(false);
   transferStatus->setEnabled(false);
   transferStartStop->setEnabled(false);
   transferCheck->setEnabled(false);
   transferAutoResume->setEnabled(false);
   transferAutoCheck->setEnabled(false);
   transferClear->setEnabled(false);
   transferSetPriority->setEnabled(false);
   transferSetIncrPriority->setEnabled(false);
   transferSetDecrPriority->setEnabled(false);
   transferSetRsmState->setEnabled(false);
   transferSetResumed->setEnabled(false);
   transferSetState->setEnabled(false);
   viewDropper->setChecked(false);
   slotStatusMsg(i18n(IDS_STATUS_DEFAULT));

   //_currentManager = 0;
   //_currentTransfer = 0;
   _dropper = 0;

   doc()->loadState(restored);
   doc()->start();
}

KMagoApp::~KMagoApp() 
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
   if (_dropper)
      delete _dropper;
}

QSize KMagoApp::sizeHint() const 
{
   return QSize(500, 280);
}

void KMagoApp::initActions() 
{
   if (!isUniqueApp())
   {
      fileNew = KStdAction::openNew(this, SLOT(slotFileNew()), 
				    actionCollection(), "file_new");
      //fileNew->setToolTip(i18n("Creates a new document"));
      fileOpen = KStdAction::open(this, SLOT(slotFileOpen()), 
				  actionCollection(), "file_open");
      //fileOpen->setToolTip(i18n("Opens an existing document"));
      fileOpenRecent = 
	 KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), 
				actionCollection(), "file_open_recent");
      //fileOpenRecent->setToolTip(i18n("Opens a recently used file"));
      fileSaveAs = KStdAction::saveAs(this, SLOT(slotFileSaveAs()), 
				      actionCollection(), "file_save_as");
      //fileSaveAs->setToolTip(i18n("Saves the actual document as..."));
   }
   else // run as unique app, disable some menu entries
   {
      fileNew = new KAction();
      fileOpen = new KAction();
      fileOpenRecent = new KRecentFilesAction();
      fileSaveAs = new KAction() ;
   }
   fileNewWindow = new KAction(i18n("New Window"),
			       QIconSet(kapp->miniIcon()), 0,
			       this, SLOT(slotFileNewWindow()),
			       actionCollection(), "file_new_window");
   fileNewWindow->setToolTip(i18n("Opens a new application window"));
   fileClose = KStdAction::close(this, SLOT(slotFileClose()), 
				 actionCollection(), "file_close");
   //fileQuit->setToolTip(i18n("Closes the actual document"));
   fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), 
			       actionCollection(), "file_quit");
   //fileQuit->setToolTip(i18n("Quits the application"));
   fileSelectMngr = new KListAction(i18n("Select Manager"),
				    0, this, SLOT(slotFileSelectMngr(int)),
				    actionCollection(), "file_select_mngr");
   fileSelectMngr->setToolTip(i18n("Select current Manager"));
   fileAddMngr = new KAction(i18n("Add Manager..."),
			     "queue",
			     0, this, SLOT(slotFileAddMngr()),
			     actionCollection(), "file_add_mngr");
   fileAddMngr->setToolTip(i18n("Add a Manager"));
   fileDownloadLock =
      new KToggleAction(i18n("Lock Auto Download"),
			"lock",
			0, this, SLOT(slotFileDownloadLock()),
			actionCollection(), "file_download_lock");
   fileDownloadLock->setToolTip(i18n("Lock/Unlock automatic downloading"));

   editCopy = KStdAction::copy(this, SLOT(slotEditCopy()), 
			       actionCollection(), "edit_copy");
   //editCopy->setToolTip(i18n("Copies the selected section to the clipboard"));
   editCut = KStdAction::cut(this, SLOT(slotEditCut()), 
			     actionCollection(), "edit_cut");
   //editCut->setToolTip(i18n("Cuts the selected section and puts it to the clipboard"));
   editPaste = KStdAction::paste(this, SLOT(slotEditPaste()), 
				 actionCollection(), "edit_paste");
   //editPaste->setToolTip(i18n("Pastes the clipboard contents to actual position"));
   editUnselectTransfer = new KAction(i18n("Unselect Transfer"),
				      0, this, SLOT(slotEditUnselectTransfer()),
				      actionCollection(), "edit_unselect");

   managerAdd = new KAction(i18n("Add Transfer..."),
			    "queue", 
			    0, this, SLOT(slotManagerAdd()),
			    actionCollection(), "manager_add");
   managerAdd->setToolTip(i18n("Add a transfer"));
   managerAddRecent = 
      new KRecentFilesAction(i18n("Add Recent Transfer"),
			     0, this, SLOT(slotManagerAddRecent(const KURL&)),
			     actionCollection(), "manager_add_recent");
   managerAddRecent->setToolTip(i18n("Add a recent transfer"));
   managerAutoDownload = 
      new KToggleAction(i18n("Auto Download"),
			"run",
			0, this, SLOT(slotManagerAutoDownload()),
			actionCollection(), "manager_auto_download");
   managerAutoDownload->setToolTip(i18n("Automatic Downloading"));
   managerConf = new KAction(i18n("Configure..."),
			     0, this, SLOT(slotManagerConfigure()),
			     actionCollection(), "manager_conf");
   managerConf->setToolTip(i18n("Open the Manager Configuration Dialog"));
   managerPaste = new KAction(i18n("Paste Transfer..."),
			      0, this, SLOT(slotManagerPaste()),
			      actionCollection(), "manager_paste");
   managerPaste->setToolTip(i18n("Add a transfer from clipboard"));
   managerKillAll = new KAction(i18n("Stop All"),
				 "stop",
				 0, this, SLOT(slotManagerKillAll()),
				 actionCollection(), "manager_kill_all");
   managerKillAll->setToolTip(i18n("Stop all transfers"));
   managerClear = new KAction(i18n("Clear"),
			      "editshred",
			      0, this, SLOT(slotManagerClear()),
			      actionCollection(), "manager_clear");
   managerClear->setToolTip(i18n("Clear manager"));
   managerRemoveMngr = new KAction(i18n("Remove"),
				   "edittrash",
				   0, this, SLOT(slotManagerRemoveMngr()),
				   actionCollection(), "manager_remove_mngr");
   managerRemoveMngr->setToolTip(i18n("Remove current manager"));
   managerSetPriority = new KListAction(i18n("Set Priority"), 0, this,
					SLOT(slotManagerSetPriority(int)),
					actionCollection(), 
					"manager_set_priority");
   QStringList lst;
   lst << i18n("High") << i18n("Normal") << i18n("Low") << i18n("Stopped");
   managerSetPriority->setItems(lst);
   managerSetIncrPriority = new KAction(i18n("Increase Priority"), 0, this,
					SLOT(slotManagerIncrPriority()),
					actionCollection(),
					"manager_set_incr_priority");
   managerSetDecrPriority = new KAction(i18n("Decrease Priority"), 0, this,
					SLOT(slotManagerDecrPriority()),
					actionCollection(),
					"manager_set_decr_priority");
   
   transferAutoCheck = 
      new KToggleAction(i18n("Auto Check Resume"),
			"wizard",
			0, this, SLOT(slotTransferAutoCheck()),
			actionCollection(), "transfer_auto_check");
   transferAutoCheck->setToolTip(i18n("Enable/disable automatic check resuming"));
   transferAutoResume = 
      new KToggleAction(i18n("Auto Resume"),
			"redo",
			0, this, SLOT(slotTransferAutoResume()),
			actionCollection(), "transfer_auto_resume");
   transferAutoResume->setToolTip(i18n("Enable/disable automatic resuming"));
   transferCheck = new KAction(i18n("Check Resume"),
			       0, this, SLOT(slotTransferCheck()),
			       actionCollection(), "transfer_check");
   transferCheck->setToolTip(i18n("Check for transfer resume capability"));
   transferConf = new KAction(i18n("Configure..."),
			      0, this, SLOT(slotTransferConfigure()),
			      actionCollection(), "transfer_conf");
   transferConf->setToolTip(i18n("Open the transfer configure dialog"));
   transferRemove = new KAction(i18n("Remove"),
				"edittrash",
				0, this, SLOT(slotTransferRemove()),
				actionCollection(), "transfer_remove");
   transferRemove->setToolTip(i18n("Remove the current transfer"));
   transferStartStop = new KAction(i18n("Start"),
				"1rightarrow",
				   0, this, SLOT(slotTransferStartStop()),
				actionCollection(), "transfer_startstop");
   transferStartStop->setToolTip(i18n("Start/Stop the current transfer"));
   transferStatus = new KAction(i18n("Status"),
				0, this, SLOT(slotTransferStatus()),
				actionCollection(), "transfer_status");
   transferStatus->setToolTip(i18n("View status of the current transfer"));
   transferLog = new KAction(i18n("View Log"),
			     0, this, SLOT(slotTransferLog()),
			     actionCollection(), "transfer_log");
   transferLog->setToolTip(i18n("View log of the current transfer process"));
   transferClear = new KAction(i18n("Clear"),
			       "editshred",
			       0, this, SLOT(slotTransferClear()),
			       actionCollection(), "transfer_clear");
   transferClear->setToolTip(i18n("Reset transfer"));
   transferSetPriority = new KListAction(i18n("Set Priority"), 0, this, 
					   SLOT(slotTransferSetPriority(int)),
					   actionCollection(), 
					   "transfer_set_priority");
   transferSetPriority->setItems(lst);
   transferSetIncrPriority = new KAction(i18n("Increase Priority"), 0, this,
					 SLOT(slotTransferIncrPriority()),
					 actionCollection(),
					 "transfer_set_incr_priority");
   transferSetDecrPriority = new KAction(i18n("Decrease Priority"), 0, this,
					 SLOT(slotTransferDecrPriority()),
					 actionCollection(),
					 "transfer_set_decr_priority");
   transferSetRsmState = new KListAction(i18n("Set Resume State"), 0, this, 
					   SLOT(slotTransferSetResumeState(int)),
					   actionCollection(), 
					   "transfer_set_rsmstate");
   lst.clear();
   lst << i18n("Unknown") << i18n("Checking") << i18n("Check Fail") 
       << i18n("Resumable") << i18n("Unresumable");
   transferSetRsmState->setItems(lst);
   transferSetResumed = new KAction(i18n("Reset Resumed"), 0, this, 
				    SLOT(slotTransferSetResumed()),
				    actionCollection(), "transfer_set_resumed");
   transferSetState = new KAction(i18n("Reset State"), 0, this, 
				  SLOT(slotTransferSetState()),
				  actionCollection(), "transfer_set_state");

   viewRefresh = KStdAction::redisplay(this, SLOT(slotViewRefresh()),
				       actionCollection(), "view_redisplay");
   //viewRefresh->setToolTip(i18n("Refresh views"));
   viewStatusBar = 
      KStdAction::showStatusbar(this, 
				SLOT(slotViewStatusBar()), 
				actionCollection(), "options_show_statusbar");
   //viewStatusBar->setToolTip(i18n("Enables/disables the statusbar"));
   viewToolBarMain = 
      KStdAction::showToolbar(this, SLOT(slotViewToolBarMain()), 
			      actionCollection(), "options_show_toolbar");
   //viewToolBarMain->setToolTip(i18n("Enables/disables the standard toolbar"));
   viewToolBarMng = 
      new KToggleAction(i18n("Show Managers Toolbar"),
			0, this, SLOT(slotViewToolBarMng()),
			actionCollection(), "options_show_toolbar_mng");
   viewToolBarMng->setToolTip(i18n("Enables/disables the managers toolbar"));
   viewToolBarTrn = 
      new KToggleAction(i18n("Show Transfers Toolbar"),
			0, this, SLOT(slotViewToolBarTrn()),
			actionCollection(), "options_show_toolbar_trn");
   viewToolBarTrn->setToolTip(i18n("Enables/disables the transfers toolbar"));
   viewPrefs = KStdAction::preferences(this, SLOT(slotViewPreferences()), 
				       actionCollection(), "options_configure");
   //viewPrefs->setToolTip(i18n("Open the Preferences Dialog"));
   viewManagers = new KToggleAction(i18n("Show Managers"), 
				    0, this, SLOT(slotViewManagers()),
				    actionCollection(), "options_show_managers");
   viewManagers->setToolTip(i18n("View the Manager's list"));
   viewSysTray = new KToggleAction(i18n("Show System Tray Icon"),
				   0, this, SLOT(slotViewSysTray()),
				   actionCollection(), "options_show_systray");
   viewSysTray->setToolTip(i18n("Enable/disable tray icon"));
   viewDropper = new KToggleAction(i18n("Show Drop Target"),
				   0, this, SLOT(slotViewDropper()),
				   actionCollection(), "options_show_dropper");
   viewDropper->setToolTip(i18n("Show/hide drop target window"));

   KStdAction::keyBindings(this, SLOT(slotEditKeys()), actionCollection());
   KStdAction::configureToolbars(this, SLOT(slotEditToolbars()), actionCollection());
   KStdAction::saveOptions(this, SLOT(slotSaveOptions()), actionCollection());

   separator = new KActionSeparator(this, "separator");
   //kdFatal(separator == 0) << "???? NULL" << endl;
}

void KMagoApp::initStatusBar() 
{
   statusBar()->insertFixedItem("XXXXXXXXXXXXXXXXXXXXXXXXXXXXX", STATUS_MSG);
   statusBar()->changeItem(IDS_STATUS_DEFAULT, STATUS_MSG);
   statusBar()->insertFixedItem("000/000", STATUS_COUNT);
   statusBar()->insertFixedItem("00000/00000", STATUS_BAND);
   statusBar()->insertFixedItem("000/000", STATUS_GLB_COUNT);
   statusBar()->insertFixedItem("00000/00000", STATUS_GLB_BAND);
   int w = 
      statusBar()->fontMetrics().width("000/000") +
      statusBar()->fontMetrics().width("00000/00000") +
      statusBar()->fontMetrics().width("000/000") +
      statusBar()->fontMetrics().width("00000/00000");
   _statusMsgWidth = width() - w - 35; //FIXME not a very clean way
   statusBar()->setItemFixed(STATUS_MSG, _statusMsgWidth);
}

void KMagoApp::initDocument() 
{
   _doc = new KMagoDoc(this, QString("%1-Doc").arg(name()));
}

void KMagoApp::initView() 
{
   _view = new KMagoView(doc(), this, QString("%1-View").arg(name()));
   setCentralWidget(_view);
}

void KMagoApp::initSysTray() 
{
   _sysTray = new KSysTrayView(doc(), this, QString("%1-TView").arg(name()));
}

void KMagoApp::saveProperties(KConfig *config) 
{
   kdDebug(D_INI) << name() << ": save properties" << endl;
   //KMainWindow::saveProperties(config);
   doc()->saveConfig(config);
   saveSettings(config, true);
   if (doc()->isTmp())
      config->writeEntry("Current Document", "");
   else
      config->writeEntry("Current Document", doc()->lastUsed());
}

void KMagoApp::readProperties(KConfig* config) 
{
   kdDebug(D_INI) << name() << ": read properties" << endl;
   //KMainWindow::readProperties(config);
   doc()->readConfig(config);
   applySettings(config, true);
   // document initialization
   QString newfile = config->readEntry("Current Document");
   if (newfile.isEmpty())
      doc()->openNew();
   else
      doc()->open(newfile);
   view()->initView();
}

void KMagoApp::applySettings(KConfig *config, bool fromSession) 
{
   kdDebug(D_INI) << name() << ": apply settings" << endl;
   // when restoring from session applyMain.. has already been called
   if (!fromSession) 
   {
      QString savename = name(); //FIXME!! little hack to save object name
      KMainWindow::applyMainWindowSettings(config, config->group());
      setName(savename);
   }

   // options
   viewSysTray->setChecked(config->readBoolEntry("System Tray", false));
   slotViewSysTray();
   viewManagers->setChecked(config->readBoolEntry("View Managers", true));
   slotViewManagers();
  
   viewDropper->setChecked(config->readBoolEntry("Dropper", false));
   slotViewDropper();

   // apply view settings
   view()->applySettings(config);
  
   // show window
   if (config->readBoolEntry("Visible", true))
      if (config->readBoolEntry("Minimized", false))
	 showMinimized();
      else
	 show();
   else
      hide();

   // get toolbar settings
   viewToolBarMain->setChecked(toolBar("mainToolBar")->isVisible());
   viewToolBarMng->setChecked(toolBar("managerToolBar")->isVisible());
   viewToolBarTrn->setChecked(toolBar("transferToolBar")->isVisible());
}

void KMagoApp::saveSettings(KConfig *config, bool toSession) 
{
   kdDebug(D_INI) << name() << ": save settings" << endl;
   // when saving to session saveMain... has already been called
   if (!toSession)
      KMainWindow::saveMainWindowSettings(config, config->group());

   // save options
   config->writeEntry("System Tray", viewSysTray->isChecked());
   config->writeEntry("View Managers", viewManagers->isChecked());
   config->writeEntry("Dropper", viewDropper->isChecked());

   // save view settings
   view()->saveSettings(config);
  
   // save hide/show state
   config->writeEntry("Minimized", isMinimized());
   if (viewSysTray->isChecked())
      config->writeEntry("Visible", isVisible());
}

bool KMagoApp::queryClose() 
{
   kdDebug(D_INI) << name() << ": queryClose" << endl;
   if (doc()->manager().isRunning())
      if (doc()->getExpertMode() 
	  || KMessageBox::questionYesNo(
	     this,
	     i18n("Active Transfers exist, confirm exit application?"),
	     i18n("Exit"),
	     QString::null, QString::null, false) == KMessageBox::Yes)
      {
	 goto close;
      } 
      else
      {
	 return false;
      }
close:
   //FIXME!! without this I can't destroy the app object, it says: QMimeSource::~QMimeSource: clipboard data deleted!
   kapp->clipboard()->clear();
   doc()->saveState();
   doc()->close();
   return true;
}

bool KMagoApp::queryExit() 
{
   kdDebug(D_INI) << name() << ": queryExit" << endl;
   // hack to maintain memory of dropper presence
   if (_dropper)
      disconnect(_dropper, SIGNAL(sigClose()),
		 this, SLOT(slotDropperClose()));
   return true;
}

void KMagoApp::setDownloadLock(bool v)
{
   fileDownloadLock->setChecked(v);
   slotFileDownloadLock();
}   

void KMagoApp::closeTransferWindows(KTransfer t) 
{
   QWidget *wnd = 0;
   if ((wnd = _logWnds[t.id()]) != 0) 
   {
      wnd->close();
      _logWnds.remove(t.id());
   }
   if ((wnd = _statusWnds[t.id()]) != 0) 
   {
      wnd->close();
      _statusWnds.remove(t.id());
   }
}

/////////////////////////////////////////////////////////////////////

void KMagoApp::updateCaption()
{
   setCaption(doc()->title() + " - " + doc()->currentManager().title());
   sysTray()->updateMenuTitle();
}

void KMagoApp::updateStatusBarCount()
{
   KMManager mngr = doc()->manager();
   KTManager tmngr = doc()->currentManager();
   // active counts
   statusBar()->changeItem(QString("%1/%2").arg(mngr.itemActiveCountGlobal(), 3).arg(mngr.itemCountGlobal(), 3), STATUS_GLB_COUNT);
   if (tmngr.isNull())
      statusBar()->changeItem("-/-", STATUS_COUNT);
   else
      statusBar()->changeItem(QString("%1/%2").arg(tmngr.itemActiveCount(), 3).arg(tmngr.itemCount(), 3), STATUS_COUNT);
}

void KMagoApp::updateStatusBarBand()
{
   KMManager mngr = doc()->manager();
   KTManager tmngr = doc()->currentManager();
   // bandwidth
   statusBar()->changeItem(QString("%1/%2").arg(unit(mngr.bandwidth()), 6).arg(unit(mngr.mediumBandwidth()), 6), STATUS_GLB_BAND);
   if (tmngr.isNull())
      statusBar()->changeItem("-/-", STATUS_BAND);
   else
      statusBar()->changeItem(QString("%1/%2").arg(unit(tmngr.bandwidth()), 6).arg(unit(tmngr.mediumBandwidth()), 6), STATUS_BAND);
}

void KMagoApp::updateToolTip()
{
   KMManager mngr = doc()->manager();
   // update systray tooltip
   QToolTip::remove(sysTray());
   QToolTip::add(sysTray(), QString("%1 - %2/%3 - %4").arg(PACKAGE).arg(mngr.itemActiveCountGlobal()).arg(mngr.itemCountGlobal()).arg(unit(mngr.mediumBandwidth())));
}

void KMagoApp::updateManagerList()
{
   QStringList lst;
   for (KCntIterator it(doc()->manager()); !it.current().isNull(); ++it)
      lst += it.current().toTManager().title();
   //fileSelectMngr->clear();
   fileSelectMngr->setItems(lst);
}

void KMagoApp::updateManagerMenu()
{
   kdDebug(D_VIE) << name() << ": updateManagerMenu" << endl;
   bool cond = !doc()->currentManager().isNull();
   managerAdd->setEnabled(cond);
   managerAddRecent->setEnabled(cond);
   managerSetPriority->setEnabled(cond);
   managerSetIncrPriority->setEnabled(cond);
   managerSetDecrPriority->setEnabled(cond);
   //editCopy->setEnabled(cond);
   //editCut->setEnabled(cond);
   managerConf->setEnabled(cond);
   managerPaste->setEnabled(cond);
   managerClear->setEnabled(cond && doc()->currentManager().itemCount() > 0);
   managerRemoveMngr->setEnabled(doc()->manager().itemCount() > 1);
   managerAutoDownload->setChecked(doc()->currentManager().getAutoDownload());
   managerKillAll->setEnabled(doc()->currentManager().isRunning());
}

void KMagoApp::updateTransferMenu()
{
   kdDebug(D_VIE) << name() << ": updateTransferMenu" << endl;

   // if current transfer is null
   if (doc()->currentTransfer().isNull())
   {
      transferRemove->setEnabled(false);
      transferConf->setEnabled(false);
      transferLog->setEnabled(false);
      transferStatus->setEnabled(false);
      transferSetPriority->setEnabled(false);
      transferSetIncrPriority->setEnabled(false);
      transferSetDecrPriority->setEnabled(false);
      transferSetRsmState->setEnabled(false);
      transferSetResumed->setEnabled(false);
      transferSetState->setEnabled(false);
      transferStartStop->setEnabled(false);
      transferClear->setEnabled(false);
      transferCheck->setEnabled(false);
      transferAutoResume->setEnabled(false);
      transferAutoCheck->setEnabled(false);
      return;
   }

   transferRemove->setEnabled(true);
   transferLog->setEnabled(true);
   transferStatus->setEnabled(true);
   transferStartStop->setEnabled(true);

   if (doc()->currentTransfer().isRunning() 
       && transferStartStop->icon() != "player_stop")
   {
      transferStartStop->setIcon("player_stop");
      transferStartStop->setText(i18n("Stop"));
   }
   else if (!doc()->currentTransfer().isRunning() 
	    && transferStartStop->icon() != "1rightarrow")
   {
      transferStartStop->setIcon("1rightarrow");
      transferStartStop->setText(i18n("Start"));
   }

   // if manager has autodownload or current transfer is running
   /*
   bool cond = !(doc()->currentManager().getAutoDownload() || doc()->currentTransfer().isRunning());
   if (transferCheck->isEnabled() != cond)
   {
      transferCheck->setEnabled(cond);
   }
   */
   bool cond = !doc()->currentTransfer().isRunning();
   if (transferClear->isEnabled() != cond)
   {
      transferCheck->setEnabled(cond);
      transferClear->setEnabled(cond);
      transferSetPriority->setEnabled(cond);
      transferSetIncrPriority->setEnabled(cond);
      transferSetDecrPriority->setEnabled(cond);
      transferSetRsmState->setEnabled(cond);
      transferSetResumed->setEnabled(cond);
      transferSetState->setEnabled(cond);
      transferConf->setEnabled(cond);
   }
   cond = !doc()->currentTransfer().useGlobal();
   if (transferAutoResume->isEnabled() != cond)
   {
      transferAutoResume->setEnabled(cond);
      transferAutoCheck->setEnabled(cond);
   }
   cond = doc()->currentTransfer().getAutoResume();
   if (transferAutoResume->isChecked() != cond)
   {
      transferAutoResume->setChecked(cond);
   }
   cond = doc()->currentTransfer().getCheckResume();
   if (transferAutoCheck->isChecked() != cond) 
   {
      transferAutoCheck->setChecked(cond);
   }
}

////////////// EVENTS

void KMagoApp::resizeEvent(QResizeEvent *event) 
{
   _statusMsgWidth += event->size().width() - event->oldSize().width();
   statusBar()->setItemFixed(STATUS_MSG, _statusMsgWidth);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

// slot menu FILE_*

void KMagoApp::slotFileNewWindow() 
{
   KMagoApp *new_window= new KMagoApp();
   new_window->doc()->openNew();
   new_window->show();
}

void KMagoApp::slotFileNew() 
{
   if (!doc()->openNew())
   {
      KMessageBox::sorry(
	 this, 
	 i18n("Error in opening new document, operation aborted"),
	 i18n("Error in opening new document"), false);
      slotFileClose();
   }
}

void KMagoApp::slotFileOpen() 
{
   QString fileToOpen = 
      KFileDialog::getOpenFileName(QDir::currentDirPath(),
				   i18n("*|All files"), 
				   this, i18n("Open File..."));
   QDir::setCurrent(QFileInfo(fileToOpen).dirPath());
   if(fileToOpen.isEmpty())
      return;
   if (!doc()->open(fileToOpen))
   {
      KMessageBox::sorry(
	 this, 
	 i18n("Error in opening file " + fileToOpen + ", operation aborted"),
	 i18n("Error in opening file"), false);
      slotFileClose();
   }
}

void KMagoApp::slotFileOpenRecent(const KURL &url) 
{
   if(url.path().isEmpty())
      return;
   QFileInfo file(url.directory(), url.fileName());
   if (!doc()->open(file.absFilePath()))
      KMessageBox::sorry(this, 
			 i18n("Error in opening file " + file.absFilePath() + ", operation aborted"),
			 i18n("Error in opening file"), false);
}

void KMagoApp::slotFileSaveAs() 
{
   QString newFile = KFileDialog::getSaveFileName(QDir::currentDirPath(),
						  QString::null, 
						  this, i18n("Save as..."));
   if(newFile.isEmpty())
      return;
   if (!doc()->saveAs(newFile))
      KMessageBox::sorry(this, 
			 i18n("Error in saving file " + newFile + ", operation aborted"),
			 i18n("Error in saving file"), false);
   QDir::setCurrent(QFileInfo(newFile).dirPath());
}

void KMagoApp::slotFileClose() 
{
   close();
}

void KMagoApp::slotFileQuit() 
{
   // close the first window, the list makes the next one the first again.
   // This ensures that queryClose() is called on each window to ask for closing
   KMainWindow* w;
   if(memberList) 
   {
      for(w=memberList->first(); w!=0; w=memberList->first()) 
      {
	 // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
	 // the window and the application stay open.
	 if(!w->close())
	    break;
      }
   }
}

void KMagoApp::slotFileSelectMngr(int i) 
{
   //int i = fileSelectMngr->currentItem();
   doc()->setCurrentManager(doc()->manager().itemAt(i).toTManager());
}

void KMagoApp::slotFileAddMngr() 
{
   // dialog box manager
   KDlgOpenManager *dlg = new KDlgOpenManager(this, "KDlgOpenManager");
   QString title = dlg->exec();
   delete dlg;
   if (title.isEmpty())
      return;
   doc()->manager().itemNew(title);
}

void KMagoApp::slotFileDownloadLock() 
{
   bool state = fileDownloadLock->isChecked();
   KMManager m = doc()->manager();
   if (m.downloadLock() != state) 
   {
      m.setDownloadLock(state);
      m.emitMod();
   }
}

// slot menu MANAGER_*

void KMagoApp::slotManagerRemoveMngr() 
{
   if (doc()->getExpertMode()
       || KMessageBox::questionYesNo(this,
				     i18n("Remove the highlighted Manager?"),
				     i18n("Remove Manager"),
				     QString::null, QString::null, false
	  ) == KMessageBox::Yes)
      doc()->manager().itemRemove(doc()->currentManager());
}

void KMagoApp::slotManagerAdd() 
{
   doc()->addTransfer("");
}

void KMagoApp::slotManagerPaste() 
{
   QStrList uris;
   QString text;
   if (QUriDrag::canDecode(kapp->clipboard()->data())) 
   {
      if (!QUriDrag::decode(kapp->clipboard()->data(), uris)) 
      {
	 kdWarning(D_RUN) << name() << ": paste uri: decode fail" << endl;
	 return;
      }
      //kdDebug(D_RUN) << name() << ": URIS=" << uris.join(",") << endl;
      KContainerView::dropUriList(doc(), doc()->currentManager(), uris);
   } 
   else if (QTextDrag::canDecode(kapp->clipboard()->data())) 
   {
      if (!QTextDrag::decode(kapp->clipboard()->data(), text)) 
      {
	 kdWarning(D_RUN) << name() << ": paste text: decode fail" << endl;
	 return;
      }
      KContainerView::dropText(doc(), doc()->currentManager(), text);
   }
}

void KMagoApp::slotManagerAddRecent(const KURL &url) 
{
   doc()->addTransfer(url);
}

void KMagoApp::slotManagerClear() 
{
   if (doc()->getExpertMode() ||
       KMessageBox::questionYesNo(this,
				  i18n("Really delete all transfers?"),
				  i18n("Clear Manager"),
				  QString::null, QString::null, 
				  false) == KMessageBox::Yes)
   {
      doc()->currentManager().clear();
   }
}

void KMagoApp::slotManagerKillAll()
{
   if (doc()->getExpertMode() ||
       KMessageBox::questionYesNo(this,
				  i18n("Stop All Transfers?"),
				  i18n("Stop all transfers"),
				  QString::null, QString::null, 
				  false) == KMessageBox::Yes)
      doc()->currentManager().kill();
}

void KMagoApp::slotManagerAutoDownload() 
{
   bool state = managerAutoDownload->isChecked();
   if (doc()->currentManager().getAutoDownload() != state) 
   {
      doc()->currentManager().setAutoDownload(state);
      doc()->currentManager().emitMod();
   }
}

void KMagoApp::slotManagerConfigure() 
{
   KDlgManager *dlg = new KDlgManager(doc()->currentManager(), this);
   dlg->exec();
   delete dlg;
}

void KMagoApp::slotManagerRefresh(KTManager m) 
{
   if (doc()->currentManager() != m)
      return;
   view()->transferView()->reset();
}

void KMagoApp::slotManagerSetPriority(int index)
{
   int priority = 0;
   switch (index)
   {
   case 0:
      priority = PRM_HIGH;
      break;
   case 1:
      priority = PRM_NORMAL;
      break;
   case 2:
      priority = PRM_LOW;
      break;
   case 3:
      priority = 0;
      break;
   default:
      kdFatal(D_RUN) << name() << ": slotManagerSetPriority : unknown index" << endl;
   }
   doc()->currentManager().setPriority(priority);
   doc()->currentManager().emitMod();
}

void KMagoApp::slotManagerIncrPriority()
{
   doc()->currentManager().setPriority(doc()->currentManager().priority() + 1);
   doc()->currentManager().emitMod();
}

void KMagoApp::slotManagerDecrPriority()
{
   doc()->currentManager().setPriority(doc()->currentManager().priority() - 1);
   doc()->currentManager().emitMod();
}

// slot menu TRANSFER_*

void KMagoApp::slotTransferStartStop() 
{
   if (doc()->currentTransfer().isRunning())
   {
      doc()->currentTransfer().kill();
   }
   else
   {
      if (doc()->getExpertMode()
	  || !doc()->currentTransfer().isComplete()
	  || KMessageBox::questionYesNo(
	     this,
	     i18n("Starting transfer will overwrite current content, continue?"),
	     i18n("Start Transfer"),
	     QString::null, QString::null, 
	     false) == KMessageBox::Yes)
	 doc()->currentTransfer().start();
   }
}

void KMagoApp::slotTransferRemove() 
{
   if (doc()->getExpertMode()
       || KMessageBox::questionYesNo(this,
				     i18n("Remove the highlighted transfer?"),
				     i18n("Remove Transfer"),
				     QString::null, QString::null, false
	  ) == KMessageBox::Yes)
      doc()->currentManager().itemRemove(doc()->currentTransfer());
}

void KMagoApp::slotTransferCheck()
{
   doc()->currentTransfer().startCheckResume();
}

void KMagoApp::slotTransferAutoResume() 
{
   bool state = transferAutoResume->isChecked();
   KTransfer t = doc()->currentTransfer();
   kdFatal(t.isNull(), D_VIE) << "CHANGE AUTORESUME WHEN CURRENT NULL" << endl;
   if (t.getAutoResume() != state) 
   {
      t.setAutoResume(state);
      t.emitMod();
   }
}

void KMagoApp::slotTransferAutoCheck() 
{
   bool state = transferAutoCheck->isChecked();
   KTransfer t = doc()->currentTransfer();
   kdFatal(t.isNull(), D_VIE) << "CHANGE AUTOCHECK WHEN CURRENT NULL" << endl;
   if (t.getCheckResume() != state) 
   {
      t.setCheckResume(state);
      t.emitMod();
   }
}

void KMagoApp::slotTransferClear() 
{
   kdFatal(doc()->currentTransfer().isNull() || doc()->currentTransfer().isRunning(), D_RUN) << name() << ": transfer clear" << endl;
   if (doc()->getExpertMode()
       || KMessageBox::questionYesNo(this,
				     i18n("Clear transfer content, continue?"),
				     i18n("Clear Transfer"),
				     QString::null, QString::null, 
				     false) == KMessageBox::Yes)
      doc()->currentTransfer().clear();
}
	
void KMagoApp::slotTransferConfigure() 
{
   KDlgTransfer *dlg = new KDlgTransfer(doc()->currentTransfer(), this);
   dlg->exec();
   delete dlg;
}

void KMagoApp::slotTransferStatus() 
{
   QWidget *status;
   int id = doc()->currentTransfer().id();
   if ((status = _statusWnds[id]) != 0)
      status->raise();
   else 
   {
      status = new KDlgTransferStatus(doc()->currentTransfer(), doc(), this);
      connect(status, SIGNAL(sigClose(int)), 
	      this, SLOT(slotWndStatusClosed(int)));
      _statusWnds.insert(id, status);
      status->show();
   }
}

void KMagoApp::slotTransferLog() 
{
   QWidget *viewer;
   int id = doc()->currentTransfer().id();
   if ((viewer = _logWnds[id]) != 0)
      viewer->raise();
   else 
   {
      viewer = new KLogViewer(doc()->currentTransfer(), this);
      connect(viewer, SIGNAL(sigClose(int)), 
	      this, SLOT(slotWndLogClosed(int)));
      _logWnds.insert(id, viewer);
      viewer->show();
   }
}

void KMagoApp::slotTransferSetPriority(int index)
{
   int priority = 0;
   switch (index)
   {
   case 0:
      priority = PRT_HIGH;
      break;
   case 1:
      priority = PRT_NORMAL;
      break;
   case 2:
      priority = PRT_LOW;
      break;
   case 3:
      priority = 0;
      break;
   default:
      kdFatal(D_RUN) << name() << ": slotTransferSetPriority : unknown index" << endl;
   }
   doc()->currentTransfer().setPriority(priority);
   doc()->currentTransfer().emitMod();
}

void KMagoApp::slotTransferIncrPriority()
{
   doc()->currentTransfer().setPriority(doc()->currentTransfer().priority() + 1);
   doc()->currentTransfer().emitMod();
}

void KMagoApp::slotTransferDecrPriority()
{
   doc()->currentTransfer().setPriority(doc()->currentTransfer().priority() - 1);
   doc()->currentTransfer().emitMod();
}

void KMagoApp::slotTransferSetResumeState(int index)
{
   RsmState state = RSM_UNKNOWN;
   switch (index)
   {
   case 0:
      state = RSM_UNKNOWN;
      break;
   case 1:
      state = RSM_CHECKING;
      break;
   case 2:
      state = RSM_CHECKFAIL;
      break;
   case 3:
      state = RSM_YES;
      break;
   case 4:
      state = RSM_NO;
      break;
   default:
      kdFatal(D_RUN) << name() << ": slotTransferSetResumeState : unknown index" << endl;
   }
   doc()->currentTransfer().setRsmState(state);
   doc()->currentTransfer().emitMod();
}

void KMagoApp::slotTransferSetResumed()
{
   doc()->currentTransfer().setResumed(0);
   doc()->currentTransfer().emitMod();
}

void KMagoApp::slotTransferSetState()
{
   doc()->currentTransfer().resetState();
   doc()->currentTransfer().emitMod();
}

// slot menu EDIT_*

void KMagoApp::slotEditCut() 
{
   KTransfer t = doc()->currentTransfer();
   KTManager m = doc()->currentManager();
   if (t.isNull() && KContainerView::managerDragEnabled(m)) 
   {
      // cut manager
      /*
	KTManagerListDrag *drag = new KTManagerListDrag(view(), QString("%1-clipboard").arg(name()));
	drag->append(m);
	//FIXME!! clipboard know only text/plain
	kapp->clipboard()->setData(drag);
      */
      QString text;
      QTextOStream s(&text);
      for (KCntIterator it(m); !it.current().isNull(); ++it)
	 s << it.current().toTransfer().remote().url() << endl;
      kapp->clipboard()->setData(new QTextDrag(text, this));
      doc()->manager().itemRemove(m);
   } 
   else if (KContainerView::transferDragEnabled(t)) 
   {
      // cut transfer
      /*
	KTransferListDrag *drag = new KTransferListDrag(view(), QString("%1-clipboard").arg(name()));
	drag->append(t);
	kapp->clipboard()->setData(drag);
      */
      kapp->clipboard()->setData(new QTextDrag(t.remote().url(), this));
      m.itemRemove(t);
   }
}

void KMagoApp::slotEditCopy() 
{
   KTransfer t = doc()->currentTransfer();
   KTManager m = doc()->currentManager();
   if (t.isNull() && KContainerView::managerDragEnabled(m)) 
   {
      // copy manager
      /*
	KTManagerListDrag *drag = new KTManagerListDrag(view(), QString("%1-clipboard").arg(name()));
	drag->append(m);
	//FIXME!! clipboard know only text/plain
	kapp->clipboard()->setData(drag);
      */
      QString text;
      QTextOStream s(&text);
      for (KCntIterator it(m); !it.current().isNull(); ++it)
	 s << it.current().toTransfer().remote().url() << endl;
      kapp->clipboard()->setData(new QTextDrag(text, this));
   } 
   else if (KContainerView::transferDragEnabled(t)) 
   {
      /*
      // copy transfer
      KTransferListDrag *drag = new KTransferListDrag(view(), QString("%1-clipboard").arg(name()));
      drag->append(t);
      kapp->clipboard()->setData(drag);
      */
      kapp->clipboard()->setData(new QTextDrag(t.remote().url(), this));
   }
}

void KMagoApp::slotEditPaste() 
{
   QMimeSource *mime = kapp->clipboard()->data();
   if (mime->provides(KContainerView::MIMETYPE[KContainerView::MimeTManagerList])) 
   {
      QDomDocument dom("item-list");
      if (!dom.setContent(mime->encodedData(KContainerView::MIMETYPE[KContainerView::MimeTManagerList]))) 
      {
	 kdWarning(D_RUN) << name() << ": error decoding tmanager-list" << dom.toString() << endl;
	 return;
      }
      KContainerView::dropItemList(KContainer::null(), doc()->manager(), false, dom);
   } 
   else if (mime->provides(KContainerView::MIMETYPE[KContainerView::MimeTransferList])) 
   {
      QDomDocument dom("item-list");
      if (!dom.setContent(mime->encodedData(KContainerView::MIMETYPE[KContainerView::MimeTransferList]))) 
      {
	 kdWarning(D_RUN) << name() << ": error decoding transfer-list " << dom.toString() << endl;
	 return;
      }
      KContainerView::dropItemList(KContainer::null(), doc()->currentManager(), false, dom);
   }
   else if (mime->provides(KContainerView::MIMETYPE[KContainerView::MimeUriList])) 
   {
      QStrList lst;
      QUriDrag::decode(mime, lst);
      KContainerView::dropUriList(doc(), doc()->currentManager(), lst);
   } 
   else if (mime->provides(KContainerView::MIMETYPE[KContainerView::MimeText])) 
   {
      slotManagerPaste();
   }
}

void KMagoApp::slotEditUnselectTransfer()
{
   doc()->setCurrentTransfer(KTransfer::null());
}

// slot menu VIEW_*

void KMagoApp::slotViewToolBarMain() 
{
   bool state = viewToolBarMain->isChecked();
   if (state)
      toolBar("mainToolBar")->show();
   else
      toolBar("mainToolBar")->hide();
}

void KMagoApp::slotViewToolBarMng() 
{
   bool state = viewToolBarMng->isChecked();
   if (state)
      toolBar("managerToolBar")->show();
   else
      toolBar("managerToolBar")->hide();
}

void KMagoApp::slotViewToolBarTrn() 
{
   bool state = viewToolBarTrn->isChecked();
   if (state)
      toolBar("transferToolBar")->show();
   else
      toolBar("transferToolBar")->hide();
}

void KMagoApp::slotViewStatusBar() 
{
   bool state = viewStatusBar->isChecked();
   if (state)
      statusBar()->show();
   else
      statusBar()->hide();
}

void KMagoApp::slotViewPreferences()
{
   KDlgConfigure *dlg = new KDlgConfigure(doc(), this, "KDlgConfigure");
   dlg->exec();
   delete dlg;
}

void KMagoApp::slotViewManagers() 
{
   view()->showManagers(viewManagers->isChecked());
}

void KMagoApp::slotViewSysTray() 
{
   if (viewSysTray->isChecked())
      sysTray()->show();
   else
      sysTray()->hide();
}

void KMagoApp::slotViewDropper() 
{
   if (viewDropper->isChecked()) 
   {
      kdFatal(_dropper != 0, D_RUN) << name() << ": dropper already showed" << endl;
      _dropper = new KDropper(doc(), this, QString("%1-Dropper").arg(name()));
      connect(_dropper, SIGNAL(sigClose()),
	      this, SLOT(slotDropperClose()));
      _dropper->show();
   } 
   else 
   {
      if (_dropper)
	 _dropper->close();
      _dropper = 0;
   }
   kdDebug(D_VIE) << name() << ": dropper view " << (_dropper != 0) << endl;
}

void KMagoApp::slotDropperClose() 
{
   _dropper = 0;
   viewDropper->setChecked(false);
}

void KMagoApp::slotViewRefresh()
{
   doc()->resetView();
}

void KMagoApp::slotEditKeys() 
{
   KKeyDialog::configureKeys(actionCollection(), xmlFile());
}


void KMagoApp::slotEditToolbars() 
{
   KEditToolbar *dlg = new KEditToolbar(actionCollection());

   if (dlg->exec())
      createGUI();
   delete dlg;
}

void KMagoApp::slotSaveOptions() 
{
   KConfig * config = kapp->config();
   QString grp = config->group();
   config->setGroup("Configuration");
   //saveOptions(config);
   saveSettings(config, false);
   config->setGroup(grp);
}

////////////////////////////

void KMagoApp::slotStatusMsg(const QString &text) 
{
   statusBar()->changeItem(text, STATUS_MSG);
}

void KMagoApp::slotStatusHelpMsg(const QString &text) 
{
   statusBar()->message(text, 2000);
}

/** called when clipboard data change */
void KMagoApp::slotClipboardChange()
{
   QString s = kapp->clipboard()->text();
   editPaste->setEnabled(!s.isEmpty());
}

////////////////////////////////

void KMagoApp::slotWndStatusClosed(int id) 
{
   _statusWnds.remove(id);
}

void KMagoApp::slotWndLogClosed(int id) 
{
   _logWnds.remove(id);
}

#include "kmago.moc"
