/***************************************************************************
                          kdropper.cpp  -  description
                             -------------------
    begin                : Tue Jan 2 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.4 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include "kiconloader.h"
#include "kcontainerview.h"
#include "kmagodoc.h"
#include "kdropper.h"

KDropper::KDropper(KMagoDoc *doc, QWidget *parent, const char *name ) :
   QLabel(parent,name, WType_TopLevel | WStyle_Tool | WStyle_StaysOnTop 
	  | WDestructiveClose), _doc(doc)
{
   kdDebug(D_VIE) << name << ": create" << endl;
   setPixmap(DesktopIcon("kmago"));
   setAcceptDrops(true);
}

KDropper::~KDropper()
{
   kdDebug(D_VIE) << name() << ": destroy" << endl;
}

KMagoDoc * KDropper::doc() const 
{
   return _doc;
}

void KDropper::dropEvent(QDropEvent *event) 
{
   KTManager m = 
      (doc()->getListOnDrop() ?
       KContainerView::selectManager(doc()) : doc()->currentManager());
   if (!m.isNull())
      KContainerView::dropTransferList(event, doc(), m);
}

void KDropper::dragEnterEvent(QDragEnterEvent *event) 
{
   event->acceptAction(KContainerView::transferCanDecode(event));
}

void KDropper::closeEvent(QCloseEvent *e) 
{
   QLabel::closeEvent(e);
   emit sigClose();
}

#include "kdropper.moc"
