/***************************************************************************
                          kdlgtransferwget1.h  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.9 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGTRANSFERWGET1_H
#define KDLGTRANSFERWGET1_H

#include <qwidget.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include "ktransferwget.h"

class KTransferWget;

/**
 * @short Page configuration for @ref KTransferWget objects.
 * 
 * @author Sergio Moretti
 *
 * @version $Id: kdlgtransferwget1.h,v 1.9 2001/03/05 20:59:22 sergio Exp $
 */

class KDlgTransferWget1 : public QWidget 
{
   Q_OBJECT

public:	  
   KDlgTransferWget1(KTransferWget t, QWidget *parent, const char *name=0);
   ~KDlgTransferWget1();
   /** check if the dialog is in an acceptable state */
   bool isAcceptable();
   void accept();
   void reject();

protected:
   void initDialog();
   /** init dialog state */
   void init();

public slots: // Protected slots
   /** update the dialog after a change in global checkbutton */
   void slotSetGlobal(bool on);

protected slots:
   void slotSetProxy(bool on);
	
protected:
   QLineEdit *lneReadTO;
   QCheckBox *cbtPasv;
   QCheckBox *cbtCache;
   QCheckBox *cbtIgnLen;
   QLineEdit *lneCmdPath;
   QCheckBox *cbtProxy;
   QLineEdit *lnePHA;
   QLineEdit *lnePHP;
   QLineEdit *lnePFA;
   QLineEdit *lnePFP;
   QLineEdit *lneNoProxy;
   KComboBox *cmbSpeed;

private:
   KTransferWget t;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
