/***************************************************************************
                          kdlgtransferstatus.cpp  -  description
                             -------------------
    begin                : Thu Sep 7 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.16 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qdir.h>
#include "ktmanager.h"
#include "utils.h"
#include "kmagodoc.h"
#include "kdlgtransferstatus.h"

KDlgTransferStatus::KDlgTransferStatus(KTransfer tr, KMagoDoc *doc, 
				       QWidget *parent, const char *name) 
   : QWidget(parent, name,
	     WDestructiveClose
	     | WType_TopLevel | WStyle_Customize | WStyle_NormalBorder 
	     | WStyle_Title | WStyle_SysMenu | WStyle_MinMax) 
{
   t = tr;
   initDialog();
   init();
   connect(doc, SIGNAL(sigTransferChange(KTransfer)), 
	   this, SLOT(slotUpdate(KTransfer)));
}

KDlgTransferStatus::~KDlgTransferStatus()
{
   emit sigClose(t.id());
}

void KDlgTransferStatus::init() 
{
   setCaption("Transfer " + t.remote().prettyURL() + " => " 
	      + t.local().fileName());
   lneType->setText(KObject::typeStr(t.type()));
   lneRemote->setText(t.remote().url());
   lneLocal->setText(t.local().path());
   lnePriority->setText(QString::number(t.priority()));
   lneTmp->setText(t.tmp().path());
   lneID->setAlignment(AlignRight | AlignVCenter);
   lneID->setText(QString::number(t.id()));
   lneTEst->setAlignment(AlignRight | AlignVCenter);
   lneTStart->setAlignment(AlignRight | AlignVCenter);
   slotUpdate(t);
}

void  KDlgTransferStatus::initDialog() 
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(2, Horizontal, i18n("Url & File"), 
				   this, "GB1");
   l->addWidget(gbox);

   new QLabel(i18n("Url:"), gbox);
   lneRemote = new QLineEdit(gbox, "LneRemote");
   lneRemote->setReadOnly(true);
   QToolTip::add(lneRemote, i18n("Url to download"));

   new QLabel(i18n("File:"), gbox);
   lneLocal = new QLineEdit(gbox, "LneLocal");
   lneLocal->setReadOnly(true);
   QToolTip::add(lneLocal, i18n("File to write"));
  
   new QLabel(i18n("Tmp File:"), gbox);
   lneTmp = new QLineEdit(gbox, "LneTmp");
   lneTmp->setReadOnly(true);
   QToolTip::add(lneLocal, i18n("Temporary file"));

   new QLabel(i18n("Type:"), gbox);
   lneType = new QLineEdit(gbox, "lneType");
   lneType->setFixedWidth(lneType->fontMetrics().width("XXXXXXX"));
   lneType->setReadOnly(true);

   gbox = new QGroupBox(2, Horizontal, i18n("Running"), this, "GB2");
   l->addWidget(gbox);

   QHBox * box = new QHBox(gbox);
   QLabel *lbl = new QLabel(i18n("Start:"), box);
   lneTStart = new QLineEdit(box, "LblTStart");
   lneTStart->setFixedWidth(lneTStart->fontMetrics().width("XXXXXXXXXX"));
   lneTStart->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneTStart, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Est.Time:"), box);
   lneTEst = new QLineEdit(box, "LblTEst");
   lneTEst->setFixedWidth(lneTEst->fontMetrics().width("XXXXXXXXXX"));
   lneTEst->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneTEst, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Band:"), box);
   lneBand = new QLineEdit(box, "LblBand");
   lneBand->setFixedWidth(lneBand->fontMetrics().width("XXXXXXXXXX"));
   lneBand->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneBand, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Medium B.:"), box);
   lneMBand = new QLineEdit(box, "LblMBand");
   lneMBand->setFixedWidth(lneMBand->fontMetrics().width("XXXXXXXXXX"));
   lneMBand->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneMBand, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Try n.:"), box);
   lneRetry = new QLineEdit(box, "LblRetry");
   lneRetry->setFixedWidth(lneRetry->fontMetrics().width("XXXXX"));
   lneRetry->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneRetry, 1);

   gbox = new QGroupBox(2, Horizontal, i18n("State"), this, "GB3");
   l->addWidget(gbox);
   /*
     QWidget *wdg = new QWidget(gbox);
     QGridLayout *grid = new QGridLayout(wdg, 4, 4, 0, 8);
     grid->setColStretch(0, 1);
     grid->setColStretch(1, 10);
     grid->setColStretch(2, 1);
     grid->setColStretch(3, 11);
   */
   box = new QHBox(gbox);
   lbl = new QLabel(i18n("ID:"), box);
   //grid->addWidget(lbl, 0, 0);
   lneID = new QLineEdit(box, "LblID");
   lneID->setFixedWidth(lneID->fontMetrics().width("XXXXX"));
   lneID->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneID, 1);
   //grid->addWidget(lblID, 0, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Priority:"), box);
   //grid->addWidget(lbl, 0, 2);
   lnePriority= new QLineEdit(box, "LnePriority");
   lnePriority->setReadOnly(true);
   lnePriority->setFixedWidth(lnePriority->fontMetrics().width("XXXXX"));
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lnePriority, 1);
   //grid->addWidget(lnePriority, 0, 3);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("State:"), box);
   //grid->addWidget(lbl, 1, 0);
   lneState = new QLineEdit(box, "lblState");
   lneState->setFixedWidth(lneState->fontMetrics().width("XXXXXXXXXXX"));
   lneState->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneState, 1);
   //grid->addMultiCellWidget(lblStatus, 1, 1, 1, 3);
   gbox->addSpace(0);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Partial:"), box);
   //grid->addWidget(lbl, 2, 0);
   lnePartial = new QLineEdit(box, "LblPartial");
   lnePartial->setFixedWidth(lnePartial->fontMetrics().width("XXXXXXXX"));
   lnePartial->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lnePartial, 1);
   //grid->addWidget(lblPartial, 2, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Length:"), box);
   //grid->addWidget(lbl, 2, 2);
   lneLen = new QLineEdit(box, "LblLen");
   lneLen->setFixedWidth(lneLen->fontMetrics().width("XXXXXXXX"));
   lneLen->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneLen, 1);
   //grid->addWidget(lblLen, 2, 3);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Resumable:"), box);
   //grid->addWidget(lbl, 3, 0);
   lneResumable = new QLineEdit(box, "lneResumable");
   lneResumable->setFixedWidth(lneResumable->fontMetrics().width("XXXXXXXXXX"));
   lneResumable->setReadOnly(true);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneResumable, 1);
   //grid->addWidget(lblResumable, 3, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Resumed:"), box);
   //grid->addWidget(lbl, 3, 2);
   lneResumed = new QLineEdit(box, "LneResumed");
   lneResumed->setReadOnly(true);
   lneResumed->setFixedWidth(lneResumed->fontMetrics().width("XXXXX"));
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneResumed, 1);
   //grid->addWidget(lneResumed, 3, 3);

   QHBoxLayout *btnBox = new QHBoxLayout(l);
   btnBox->addStretch(1);

   btnOK = new QPushButton(i18n("OK"), this, "BtnOK");
   btnOK->setDefault(true);
   btnBox->addWidget(btnOK);
   connect(btnOK, SIGNAL(clicked()), this, SLOT(slotOk()));
}

void KDlgTransferStatus::slotUpdate(KTransfer tr) 
{
   if (tr != t)
      return;
   QString s;
   lneState->setText(t.stateStr());
   lneLen->setAlignment(AlignRight | AlignVCenter);	
   lneLen->setText(unit(t.len()) + "B");
   lneBand->setAlignment(AlignRight | AlignVCenter);	
   lneBand->setText(unit(t.bandwidth()) + "B/s");
   lneMBand->setAlignment(AlignRight | AlignVCenter);
   lneMBand->setText(unit(t.mediumBandwidth()) + "B/s");
   lnePartial->setAlignment(AlignRight | AlignVCenter);
   lnePartial->setText(unit(t.partial()) + "B");
   lneResumed->setText(s.setNum(t.resumed()));
   lneResumable->setText(t.resumeString(t.rsmState()));
   lneRetry->setAlignment(AlignRight | AlignVCenter);
   lneRetry->setText(QString::number(t.retry()));
   if(t.isRunning()) 
   {
      lneTStart->setText(t.startTime().toString());
      lneTEst->setText(t.estTime().toString());
   } 
   else 
   {
      lneTStart->setText("");
      lneTEst->setText("");
   }
}

void KDlgTransferStatus::slotOk() 
{
   QWidget::close();
}

#include "kdlgtransferstatus.moc"
