/***************************************************************************
                          kdlgtransfer.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.11 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qvbox.h>
#include <qtooltip.h>
#include "kdlgtransfer1.h"
#include "kdlgtransferset.h"
#ifdef ENABLE_WGET
#include "ktransferwget.h"
#include "kdlgtransferwget1.h"
#endif
#ifdef ENABLE_KIO
#include "ktransferkio.h"
#include "kdlgtransferkio1.h"
#endif
#include "kdlgtransfer.h"

KDlgTransfer::KDlgTransfer(KTransfer t, QWidget *parent, const char *name ) 
   : KDialogBase(Tabbed, i18n("Transfer Options"), Ok|Apply|Cancel, Ok, parent, 
		 name, true)
     , _ps(0)
     , _p1(0)
#ifdef ENABLE_WGET
     , _p2w(0)
#endif
#ifdef ENABLE_KIO
     , _p3k(0)
#endif
{
   _t = t;
   initDialog();
}

KDlgTransfer::~KDlgTransfer()
{
}

void KDlgTransfer::initDialog() 
{
   //resize(340, 380);
   //setMinimumSize(340, 380);
	
   QVBox *page = addVBoxPage(i18n("Settings"));
   _ps = new KDlgTransferSet(_t, page);

   page = addVBoxPage(i18n(QString("%1 1").arg(KObject::typeStr(_t.type()))));
   _p1 = new KDlgTransfer1(_t, page);

#ifdef ENABLE_WGET
   KTransferWget tw = _t.toTransferWget();
   if (!tw.isNull()) 
   {
      page = addVBoxPage(QString("%1 2").arg(KObject::typeStr(tw.type())));
      _p2w = new KDlgTransferWget1(tw, page);
      connect(_p1, SIGNAL(signalGlobalChange(bool)),
	      _p2w, SLOT(slotSetGlobal(bool)));
   }
#endif

#ifdef ENABLE_KIO
   KTransferKio tk = _t.toTransferKio();
   if (!tk.isNull()) 
   {
      page = addVBoxPage(QString("%1 2").arg(KObject::typeStr(tk.type())));
      _p3k = new KDlgTransferKio1(tk, page);
      connect(_p1, SIGNAL(signalGlobalChange(bool)),
	      _p3k, SLOT(slotSetGlobal(bool)));
   }
#endif
}

void KDlgTransfer::slotApply() 
{
   if (!_ps->isAcceptable()
       || !_p1->isAcceptable()
#ifdef ENABLE_WGET
       || (_p2w && !_p2w->isAcceptable())
#endif
#ifdef ENABLE_KIO
       || (_p3k && !_p3k->isAcceptable())
#endif
      )
      return;
   _ps->accept();
   _p1->accept();
#ifdef ENABLE_WGET
   if (_p2w)
      _p2w->accept();
#endif
#ifdef ENABLE_KIO
   if (_p3k)
      _p3k->accept();
#endif
   _t.emitMod();
   KDialogBase::slotApply();
}

void KDlgTransfer::slotOk()
{
   slotApply();
   KDialogBase::slotOk();
}

void KDlgTransfer::slotCancel()
{
   _ps->reject();
   _p1->reject();
#ifdef ENABLE_WGET
   if (_p2w)
      _p2w->reject();
#endif
#ifdef ENABLE_KIO
   if (_p3k)
      _p3k->reject();
#endif
   _t.emitMod();
   KDialogBase::slotCancel();
}

#include "kdlgtransfer.moc"
