/***************************************************************************
                          kdlgopentransfer.cpp  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.19 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <kfiledialog.h>
#include <kdialogbase.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qgroupbox.h>
#include <kapp.h>
#include <kdebug.h>
#include "kmagodoc.h"
#include "utils.h"
#include "kcntiterator.h"
#include "ktmanager.h"
#include "kdlgopentransfer.h"


KDlgOpenTransfer * KDlgOpenTransfer::dlg = 0;


KDlgOpenTransfer::KDlgOpenTransfer(QWidget *parent, const char *name) : 
   // don't enable WDestructiveClose
   KDialogBase(parent, name, true, i18n("Open Transfer"), Ok|Cancel, Ok) {
   initDialog();
   actionButton(Ok)->setAutoDefault(false);
}

KDlgOpenTransfer::~KDlgOpenTransfer() 
{
}

KMagoDoc * KDlgOpenTransfer::doc() const 
{
   return _doc;
}

void KDlgOpenTransfer::initDialog() 
{
   QWidget *page = new QWidget(this);
   page->setMinimumWidth(300);
   setMainWidget(page);

   QBoxLayout *l = new QVBoxLayout(page, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, page);
   l->addWidget(gbox);
  
   QLabel *lbl = new QLabel(i18n("URL to download:"), gbox,"LblURL");
   cmbURL = new KComboBox(true, gbox,"CmbURL");
   connect(cmbURL, SIGNAL(activated(const QString&)), 
	   this, SLOT(slotReadURL(const QString&)));

   lbl = new QLabel(i18n("Write to file:"), gbox,"LblFile");
   cmbFile = new KURLRequester(gbox, "CmbFile");
   KFile::Mode mode = static_cast<KFile::Mode>(KFile::File|KFile::LocalOnly);
   cmbFile->fileDialog()->setMode(mode);

   QHBox * box = new QHBox(gbox);
   QLabel *lbl1 = new QLabel(i18n("Manager"), box, "LblManager");
   cmbManager = new KComboBox(box, "CmbManager");
   connect(cmbManager, SIGNAL(activated(int)),
	   this, SLOT(slotSelectManager(int)));
   new QLabel(i18n("Transfer Type"), box, "LblType");
   cmbType= new KComboBox(box, "CmbType");
   box->setSpacing(5);
   box->setStretchFactor(lbl1, 5);
   box->setStretchFactor(cmbManager, 1);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(cmbType, 1);
}

void KDlgOpenTransfer::init(KMagoDoc *doc, KTManager mngr, const KURL &rmt, 
			    const KURL &lcl) 
{
   _doc = doc;
   _mngr = mngr.isNull() ? doc->currentManager() : mngr;
   updateType();
   cmbManager->clear();
   for (KCntIterator it(doc->manager()); !it.current().isNull(); ++it)
      cmbManager->insertItem(it.current().toTManager().title());
   cmbManager->setCurrentItem(doc->manager().itemFind(_mngr));
   if (!rmt.path().isEmpty()) {
      _rmt = rmt;
      cmbURL->setEditText(_rmt.url());
   }
   cmbFile->fileDialog()->setURL(_mngr.getDownloadDir().absPath());
   if (!lcl.path().isEmpty()) {
      _lcl = lcl;
      cmbFile->setURL(_lcl.path());
   }
}

bool KDlgOpenTransfer::getOpenTransfer(KMagoDoc *doc, KTManager &mngr, 
				       KURL &rmt, KURL &lcl, int &type) 
{
   if (dlg == 0)
      dlg = new KDlgOpenTransfer(kapp->mainWidget(), "KDlgOpenTransfer");
   dlg->init(doc, mngr, rmt, lcl);
   if (dlg->exec() == Accepted) 
   {
      mngr = dlg->_mngr;
      rmt = dlg->_rmt;
      lcl = dlg->_lcl;
      type = dlg->_type;
      kdDebug(D_VIE) << "getOpenTransfer: URL=" << rmt.url() << ",FILE=" << lcl.path() << ",TYPE=" << type << ",MNGR=" << mngr.name() << endl;
      return true;
   }
   return false;
}

/** try to correct the url
KURL KDlgOpenTransfer::correctURL(const QString &u) {
KURL url(u);
	if (url.url() == ":" || url.isMalformed()) {
		KURL url2(QString("http://") + u);
		if (url2.url() != ":" && !url2.isMalformed())
			url = url2;
		else
			return url;
	}
	if (_flags & FLG_URL_AUTO_ENCODE) {
		QString proto = url.protocol();
		QString str = url.url().mid(proto.length()+1, url.url().length());
		kdDebug() << "S1=" << str;
		if (str.find(' ') != -1) {
			str = KURL::encode_string(str);
			kdDebug() << "S2=" << str;
			url = proto + ":" + str;
		}
	}
	return url;
}
*/

/** correct file name */
QString KDlgOpenTransfer::correctFile(const QString &f) 
{
   QFileInfo file(_mngr.getDownloadDir(), f);
   if (doc()->getOpenFlags() & FLG_FILE_AUTO_ENCODE) 
   {
      QString filename = file.fileName();
      int p;
      while ((p = filename.find(' ')) != -1) 
      {
	 filename[p] = '_';
      }
      file.setFile(_mngr.getDownloadDir(), filename);
   }
   return file.absFilePath();
}

void KDlgOpenTransfer::updateType() 
{
   cmbType->clear();
   _typeList.clear();
   KObject::List lst = _mngr.globals();
   for(KObject::List::Iterator i = lst.begin(); i != lst.end(); ++i) 
   {
      cmbType->insertItem(KObject::typeStr((*i).type()));
      _typeList += (*i).type();
   }
   _type = _mngr.getDefaultType();
   cmbType->setCurrentItem(_typeList.findIndex(_type));
}

//// slots

/** open file dialog to select filename
    void KDlgOpenTransfer::slotOpenFileDlg(){
    QString newfile = KFileDialog::getOpenFileName();
    if (newfile.isEmpty())
    return;
    lneFile->setText(newfile);
    }
*/

void KDlgOpenTransfer::slotSelectManager(int i) 
{
   _mngr = doc()->manager().itemAt(i).toTManager();
   updateType();
   slotReadURL(_rmt.url());
}

void KDlgOpenTransfer::slotOk() 
{
   if (cmbURL->currentText() == "" || cmbFile->url() == "")
      return;
   _rmt = cmbURL->currentText();
   _lcl.setPath(cmbFile->url());
   _type = _typeList[cmbType->currentItem()];
   //kdDebug(D_VIE) << name() << ": URL=<" << _rmt.url() << "> =>" << _rmt.isMalformed() << " FILE=<" << _lcl.path() << ">" << endl;
   if (_rmt.path().isEmpty() || _rmt.isMalformed() 
       || _lcl.path().isEmpty() 
       || !QDir::current().exists(_lcl.directory())
       || (doc()->getOpenFlags() & FLG_FILE_FORCE_ENCODE
	   && _lcl.path().find(' ') != -1)
      )
      return;
   QDialog::accept();
}

/** create the file name, based on the url */
void KDlgOpenTransfer::slotReadURL(const QString &u)
{
   _rmt = u;
   if (!_rmt.path().isEmpty()) {
      cmbURL->setEditText(_rmt.url());
      _lcl.setPath(correctFile(_rmt.fileName()));
      cmbFile->setURL(_lcl.path());
   }
}

#include "kdlgopentransfer.moc"
