/***************************************************************************
                          kdlgdoc.cpp  -  description
                             -------------------
    begin                : Tue Nov 21 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.9 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qlabel.h>
#include <qhbox.h>
#include <klocale.h>
#include "kmagodoc.h"
#include "kdlgdoc.h"

KDlgDoc::KDlgDoc(KMagoDoc *doc, QWidget *parent, const char *name ) 
   : QWidget(parent, name) 
{
   _doc = doc;
   initDialog();
   init();
}

KDlgDoc::~KDlgDoc()
{
}

void KDlgDoc::init() 
{
   KMManager m = _doc->manager();
   lneMaxBand->setText(QString::number(m.getMaxBandwidth()));
   lneMaxConn->setText(QString::number(m.getMaxConnection()));
}

void KDlgDoc::initDialog() 
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("General"), this, "GB1");
   l->addWidget(gbox);
  
   new QLabel(i18n("Title"), gbox);
   QLineEdit *lne = new QLineEdit(_doc->title(), gbox);
   lne->setReadOnly(true);
   new QLabel(i18n("Filename"), gbox);
   lne = new QLineEdit(_doc->manager().fileName(), gbox);
   lne->setReadOnly(true);
   new QLabel(i18n("Type"), gbox);
   lne = new QLineEdit((_doc->isTmp() ? i18n("Temporary") : i18n("Persistent")),
		       gbox);
   lne->setReadOnly(true);
  
   QHBox *box = new QHBox(gbox);
   QLabel *lbl = new QLabel(i18n("Max Open Transfers"), box,"LblMaxConn");
   lneMaxConn= new QLineEdit(box,"LneMaxConn");
   lneMaxConn->setFixedWidth(lneMaxConn->fontMetrics().width("XXXXX"));
   QToolTip::add(lneMaxConn,i18n("Maximum number of running transfers"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneMaxConn, 0);
  
   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Max Bandwidth (BPS)"), box,"LblMaxBand");
   lneMaxBand= new QLineEdit("XXXXXX", box, "LneMaxBand");
   lneMaxBand->setFixedWidth(lneMaxBand->fontMetrics().width("XXXXXXXX"));
   QToolTip::add(lneMaxBand,i18n("Maximum bandwidth allowed in BPS"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneMaxBand, 0);

   adjustSize();
   setMinimumSize(size());
}

bool KDlgDoc::isAcceptable() const 
{
   bool check;
   QString(lneMaxBand->text()).toInt(&check);
   if (!check)
      return false;
   QString(lneMaxConn->text()).toInt(&check);
   if (!check)
      return false;
   return true;
}

void KDlgDoc::accept() 
{
   _doc->manager().setMaxBandwidth(QString(lneMaxBand->text()).toInt());
   _doc->manager().setMaxConnection(QString(lneMaxConn->text()).toInt());
}

void KDlgDoc::reject()
{
}

#include "kdlgdoc.moc"
