/***************************************************************************
                          kdlgconfigure.cpp  -  description
                             -------------------
    begin                : Tue Jan 2 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.5 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qvbox.h>
#include "kdlgapp.h"
#include "kdlgdoc.h"
#include "kdlgdefault.h"
#include "kdlgconfigure.h"

KDlgConfigure::KDlgConfigure(KMagoDoc *doc, QWidget *parent, const char *name ) 
   : KDialogBase(IconList, i18n("Configure"), Ok|Apply|Cancel, Ok, parent, name, 
		 true), _doc(doc), _p1(0), _p2(0), _p3(0)
{
   init();
}

KDlgConfigure::~KDlgConfigure()
{
}

KMagoDoc * KDlgConfigure::doc() const 
{
   return _doc;
}

void KDlgConfigure::init() 
{
   QVBox *page = addVBoxPage(i18n("Application Settings"), 
		      i18n("Application settings"), 
		      DesktopIcon("configure"));
   _p1 = new KDlgApp(doc(), page, QString("%1-app").arg(name()));
   //FIXME this page is partially hidden
  
   page = addVBoxPage(i18n("Document Settings"), 
			     i18n("Document Settings"), 
			     DesktopIcon("contents"));
   _p2 = new KDlgDoc(doc(), page, QString("%1-doc").arg(name()));

   page = addVBoxPage(i18n("Document Defaults"), 
		      i18n("Defaults values for document elements"), 
		      DesktopIcon("edit"));
   _p3 = new KDlgDefault(doc(), page, 
			 QString("%1-default").arg(name()));
}

void KDlgConfigure::slotApply() 
{
   if (!_p1->isAcceptable()
       || !_p2->isAcceptable()
       || !_p3->isAcceptable()
      )
      return;

   _p1->accept();
   _p2->accept();
   _p3->accept();
}

void KDlgConfigure::slotOk() 
{
   slotApply();
   KDialogBase::slotOk();
}

void KDlgConfigure::slotCancel()
{
   _p1->reject();
   _p2->reject();
   _p3->reject();
   KDialogBase::slotCancel();
}

#include "kdlgconfigure.moc"
