/***************************************************************************
                          kmagodoc.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.17 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAGODOC_H
#define KMAGODOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kconfig.h>
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qintdict.h>
#include <kmainwindow.h>
#include <kbugreport.h>
#include "kmmanager.h"
#include "ktmanager.h"
#include "ktransfer.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif

/**
 * @short Bug report dialog modified to accept body text fill.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmagodoc.h,v 1.17 2001/03/23 17:14:59 sergio Exp $
 */

class KMagoBugReport : public KBugReport 
{
   Q_OBJECT
public:
   KMagoBugReport(QWidget * parent = 0L, bool modal=true, 
		  const KAboutData *aboutData = 0L);
   void appendLine(const QString &line);
};

class DocEvent : public QEvent
{
public:
   DocEvent(KObject obj) 
      : QEvent(QEvent::User), _obj(obj) {}
   KObject obj() const { return _obj; }
private:
   KObject _obj;
};

class KMagoApp;
class KMagoView;

/**	
 * @short KMagoDoc provides a document object for a document-view model.
 *
 * @author Sergio Moretti
 * 
 * @version $Id: kmagodoc.h,v 1.17 2001/03/23 17:14:59 sergio Exp $
 *
 * The KMagoDoc class provides a document object that can be used in 
 * conjunction with the classes KMagoApp and KMagoView to create a 
 * document-view model for standard KDE applications based on KApplication 
 * and KTMainWindow. Thereby, the document object is created by the KMagoApp 
 * instance and contains the document structure with the according methods for 
 * manipulation of the document data by KMagoView objects. Also, KMagoDoc 
 * contains the methods for serialization of the document data from and to 
 * files.
 */

class KMagoDoc : public QObject 
{
   Q_OBJECT

   class NotifyChange : public KNotifyChange 
   {
   public:
      NotifyChange(KMagoDoc *doc) : _doc(doc) {}
      virtual ~NotifyChange() {}
      virtual void operator()(const KObject obj) const;
   private:
      KMagoDoc *_doc;
   };

   friend class NotifyChange;
  
public:
   /** Constructor for the fileclass of the application */
   KMagoDoc(KMagoApp *parent, const char *name=0);
   /** Destructor for the fileclass of the application */
   ~KMagoDoc();

   /** get the main view */
   KMagoApp * mainView() const;
   /** get the view */
   KMagoView *view() const;
   KMainWindow *mainWindow() const;

   QString title() const { return _title; }
   void setTitle(const QString &title) { _title = title; }
   KMManager manager() const { return _manager; }
   QString lastUsed() const { return _lastUsed; }
   bool isClosed() const { return _manager.isNull(); }
   bool isTmp() const { return _tmp; }
   int isDuplicate(const KURL &rmt, const KURL &lcl);
	  
   /** open a new document from a temporary file */
   bool openNew();
   /** open last used document file */
   bool openLastUsed();
   /** loads the document by filename and emits the updateViews() signal */
   bool open(const QString &filename, bool tmpDoc = false);
   /** save document, if filename != "" then save in the current file,
    * and then copy the data to the new file
    */
   bool saveAs(const QString &filename);
   /** close the document */
   void close();

   /** return the current transfer */
   KTransfer currentTransfer() const { return _currentTransfer; }
   /** set the current transfer */
   void setCurrentTransfer(KTransfer tr);
   /** get the current manager */
   KTManager currentManager() const { return _currentManager; }
   /** set the current manager */
   void setCurrentManager(KTManager m);
   /** update view after a modification in object */
   void updateView(KObject obj);

   /** add a transfer */
   void addTransfer(const KURL &url, KTManager target = KTManager::null());
   /** update the view */
   void resetView();

   /** get open dialog flags */
   int getOpenFlags() const { return _cfg_openFlags; }
   /** set open dialog flags */
   void setOpenFlags(int f) { _cfg_openFlags = f; }
   bool getExpertMode() const { return _cfg_expertMode; }
   void setExpertMode(bool m=true) { _cfg_expertMode = m; }
   int getUpdateTime() const { return _cfg_updateTime; }
   void setUpdateTime(int u);
   int getSaveTime() const { return _cfg_saveTime; }
   void setSaveTime(int u);
   int getTransferStartTime() const { return _cfg_TStartTime; }
   void setTransferStartTime(int t);
   int getStartMode() const { return _cfg_startMode; }
   void setStartMode(int m) { _cfg_startMode = m; }
   bool getLoadLastDoc() const { return _cfg_loadLastDoc; }
   void setLoadLastDoc(bool l) { _cfg_loadLastDoc = l; }
   bool getListOnDrop() const { return _cfg_listOnDrop; }
   void setListOnDrop(bool l) { _cfg_listOnDrop = l; }
   bool getExitOnIdle() const { return _cfg_exitOnIdle; }
   void setExitOnIdle(bool l);

   /** read state from config object */
   void readConfig(KConfig *config);
   /** save state to config object */
   void saveConfig(KConfig *config);

   /** load initial state, called by init */
   void loadState(bool restored);
   /** save final state, called by queryExit */
   void saveState();

   /** start timers */
   void start();

   // static
   static void reloadState();

protected:
   virtual bool event(QEvent *event);

protected slots:
   /** called to update view */
   void slotUpdate();
   /** called to save data */
   void slotSave();
   /** called to start pending transfers */
   void slotTransferStart();

signals:
   void sigTransferChange(KTransfer t);

private:
   KMagoApp *_app;
   KMManager _manager;
   QString _title;

   /** current transfer */
   KTransfer _currentTransfer;
   /** current manager */
   KTManager _currentManager;

   /** update on a regular base manager sync */
   QTimer _timerUpd;
   /** save timer */
   QTimer _timerSave;
   /** transfer starting span */
   QTimer _timerTStart;
   /** flag to recognize temporary documents */
   bool _tmp;
   /** last open document file */
   QString _lastUsed;

   QIntDict<KTransfer> _curTransferDict;

   // configuration
  
   /** flags to control open dialog */
   int _cfg_openFlags;
   /** expert mode: don't prompt for delete operation*/
   bool _cfg_expertMode;
   /** exit on idle: exit app if no transfers are left to run */
   bool _cfg_exitOnIdle;
   /** update display time */
   int _cfg_updateTime;
   /** time interval between transfer startings */
   int _cfg_TStartTime;
   /** time interval between savings (in seconds) */
   int _cfg_saveTime;
   /** what to do with ther last added transfer */
   int _cfg_startMode;
   /** load last document at startup */
   bool _cfg_loadLastDoc;
   /** open popup menu with managers list on drop */
   bool _cfg_listOnDrop;
};

#endif // KMAGODOC_H

/* Local Variables: */
/* mode: c++ */
/* End: */
