/***************************************************************************
                          km.h  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.20 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KM_H
#define KM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// FIXME!! exceptions disabled
//#include <exception>
#include <kdebug.h>
#include <iostream.h>
#include <qstring.h>
#include <qdom.h>
#include <qbitarray.h>

/** 
 * @short namespace containing all common defs for KMago.
 *
 * @author Sergio Moretti
 *
 * @version $Id: km.h,v 1.20 2001/03/18 16:31:03 sergio Exp $
 */

namespace KM 
{

   /** debug areas */
   enum DebugAreas 
   {
      D_INI =    41000,
      D_VIE =    41001,
      D_RUN =    41002,
      D_PRS =    41003
   };

   /**
    * @short Base exception class.
    *
    * @author Sergio Moretti
    *
    * @version $Id: km.h,v 1.20 2001/03/18 16:31:03 sergio Exp $
    */
  
   class Error /* : public exception */ 
   {
   public:
      Error(const QString &name, const QString &descr) 
	 {
	    _what = QString("%1: %2").arg(name).arg(descr);
	    //cerr << _what << endl;
	    kdFatal(D_RUN) << _what << endl;
	 }
      QString what() { return _what; }
   protected:
      Error() {}
   protected:
      QString _what;
   };

  
   /**
    * @short Exception related to DOM errors.
    *
    * @author Sergio Moretti
    *
    * @version $Id: km.h,v 1.20 2001/03/18 16:31:03 sergio Exp $
    */
  
   class DomError : public Error 
   {
   public:
      DomError(const QString &name, const QString &descr, QDomDocument doc) 
	 : Error(name, QString("%1:\n%2").arg(descr).arg(doc.toString())) {}
      DomError(const QString &name, const QString &descr, QDomNode n) 
	 : Error(name, QString("%1:\n%2").arg(descr).arg(n.ownerDocument().toString())) {}
   };

   /**
    * Object types: 
    * @li TYP_*_T mask type
    * @li TYP_* type id of an object
    */
   enum ObjectType
   {
      TYP_OBJECT_T        = 0xf0,
      TYP_CONTAINER_T     = 0x30,
      TYP_MMANAGER_T      = 0x10, // main manager
      TYP_MMANAGER        = 0x11,
      TYP_TMANAGER_T      = 0x20, // transfer manager
      TYP_TMANAGER        = 0x21,
      //TYP_TRANSFER_T      = 0xb0, // transfer type
      TYP_FILE_TRANSFER_T = 0x40, // file transfer type
      TYP_TWGET           = 0x41,
      TYP_TKIO            = 0x42,
      TYP_WEB_TRANSFER_T  = 0x80 // web transfer type
   };

   enum ModIndex
   {
      // object
      MDI_ID = 0,
      MDI_GLOBAL,
      MDI_FATAL,
      MDI_ERROR,
      MDI_MESSAGE,
      MDI_PRIORITY,
      MDI_START,
      MDI_STOP,
      MDI_CLEAR,
      // container
      MDI_ADD,     // 10
      MDI_REMOVE,
      MDI_CNT,
      MDI_ACTCNT,
      MDI_BAND,
      MDI_CFG_WORKINGDIR,
      MDI_CFG_PRPOLICY,
      MDI_CFG_MAXBAND,
      MDI_CFG_MINBAND,
      MDI_CFG_MAXCONN,
      // transfer
      MDI_TRN_LEN,  // 20
      MDI_TRN_PARTIAL,
      MDI_TRN_RSMSTATE,
      MDI_TRN_RETRY,
      MDI_TRN_TMP,
      MDI_TRN_LOCAL,
      MDI_TRN_REMOTE,
      MDI_TRN_STATE,
      MDI_TRN_RESUMED,
      MDI_TRN_CFG_CHKRESUME,
      MDI_TRN_CFG_MAXRESUME,
      MDI_TRN_CFG_AUTORESUME,
      MDI_TRN_CFG_WAITRESUME,
      MDI_TRN_CFG_WAITRETRY,
      MDI_TRN_CFG_MAXRETRY,
      MDI_TRN_CFG_LOGPROCESS,
      // wget transfer
      MDI_TRW_CFG_PASSIVE,
      MDI_TRW_CFG_CMDPATH,
      MDI_TRW_CFG_HTTPCACHE,
      MDI_TRW_CFG_RDTIMEOUT,
      MDI_TRW_CFG_PROXY,
      MDI_TRW_CFG_PROXYFTP,
      MDI_TRW_CFG_PROXYPORTFTP,
      MDI_TRW_CFG_PROXYHTTP,
      MDI_TRW_CFG_PROXYPORTHTTP,
      MDI_TRW_CFG_NOPROXYLST,
      MDI_TRW_CFG_SPEED,
      MDI_TRW_CFG_IGNLEN,
      // kio transfer
      MDI_TRK_CFG_COOKIE,
      // tmanager
      MDI_TMN_TITLE,
      MDI_TMN_CFG_AUTODWNL,
      MDI_TMN_CFG_AUTOREMOVE,
      MDI_TMN_CFG_LOGFILE,
      MDI_TMN_CFG_DWNLDIR,
      MDI_TMN_CFG_DFLTYPE,
      // mmanager
      MDI_MMN_DLOCK,
      MDI_MMN_IDLE,
      
      MDI_NUM
   };

   typedef QBitArray ModFlags;

   /**
    * Modification state propagation mode:
    * @li PRP_NONE : no propagation
    * @li PRP_THIS : propagation of nofication for this object only
    * @li PRP_ALL  : propagation of notifications for all objects in calling 
    object's hierarchy.
   */
   enum PropMode 
   {
      PRP_NONE,
      PRP_THIS,
      PRP_ALL
   };

   // TRANSFER

   /**
    * Transfer state
    */
   enum TrnState 
   {
      TRN_READY = 0,
      TRN_START,
      TRN_CONNECT,
      TRN_DOWNLOAD,
      TRN_END_OK,
      TRN_END_ERROR,
      TRN_END_FATAL,
      TRN_END_KILL,
      TRN_END_READY
   };
  
   /**
    * Transfer resume status
    */
   enum RsmState 
   {
      RSM_UNKNOWN = 0,
      RSM_CHECKING,
      RSM_CHECKFAIL,
      RSM_YES,
      RSM_NO
   };
  
   /**
    * Priority policy for transfer activation selection.
    */
   enum PriorityPolicy 
   {
      PRI_FIFO = 0,
      PRI_LIFO,
      PRI_SHORT,
      PRI_LONG
   };

   enum PriorityTransfer
   {
      PRT_LOW = 10,
      PRT_NORMAL = 20,
      PRT_HIGH = 30
   };

   enum PriorityManager
   {
      PRM_LOW = 50,
      PRM_NORMAL = 100,
      PRM_HIGH = 150
   };

   // END TRANSFER

   // WGET

   /** protocols supported */
   enum Protocol 
   {
      FTP = 1,
      HTTP
   };

   /**
    * Wget categories for transfer bandwidth.
    */
   enum TransferSpeed 
   {
      SPD_DEFAULT = 0,
      SPD_BINARY,
      SPD_MEGA,
      SPD_MICRO
   };

   // END WGET

   // KMAGOAPP
  
   /**
    * Flags to control transfer insertion.
    */
   enum OpenFlags 
   {
      FLG_FILE_AUTO_ENCODE =   0x001,
      FLG_FILE_FORCE_ENCODE =  0x002,
      FLG_NO_PROMPT =          0x004
   };
  
   /**
    * action to perform on transfer insertion.
    */
   enum StartMode 
   {
      START_NOW    = 0,
      START_PROMPT,
      START_NO
   };
  
   /**
    * identificators for status labels
    */
   enum IDs 
   {
      STATUS_MSG   = 0,
      STATUS_COUNT,
      STATUS_BAND,
      STATUS_GLB_COUNT,
      STATUS_GLB_BAND
   };

   // END KMAGOAPP

   void setBit(int p, ModFlags &data);
   bool getBit(int p, const ModFlags &data);
   void resetBits(ModFlags &data);
   void orBits(const ModFlags &map, ModFlags &data);
   void andBits(const ModFlags &map, ModFlags &data);
   bool mapBits(const ModFlags &map, const ModFlags &data);
   QString bitsToString(const ModFlags &data);
   ModFlags initAnyMod();
   ModFlags initCfgMod();

   extern const ModFlags &ANYMOD;
   extern const ModFlags &CFGMOD;

} // namespace

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
