/***************************************************************************
                          klogviewer.cpp  -  description
                             -------------------
    begin                : Thu Aug 31 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.9 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>
#include <qlayout.h>
#include "ktransfer.h"
#include "klogviewer.h"

KLogViewer::KLogViewer(KTransfer t, QWidget *parent, const char *name) : 
   QWidget(parent, name,
	   WDestructiveClose 
	   | WType_TopLevel | WStyle_Customize | WStyle_NormalBorder 
	   | WStyle_Title | WStyle_SysMenu | WStyle_MinMax) 
{
   _id = t.id();
   initDialog();
   setCaption("Log: " + t.remote().prettyURL());
   t.connect(SIGNAL(sigProcessOutput(const QString &)), 
	     this, SLOT(slotRead(const QString &)));
}

KLogViewer::~KLogViewer()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
   emit sigClose(_id);
}

void  KLogViewer::initDialog()
{
   QBoxLayout * l = new QVBoxLayout(this, 8);

   //this->resize(290,280);
   //this->setMinimumSize(120,80);

   mleText = new QMultiLineEdit(this, "MleText");
   l->addWidget(mleText, 1);
   mleText->setReadOnly(true);

   QPushButton *btnOK = new QPushButton(i18n("OK"), this,"BtnOK");
   btnOK->setDefault(true);
   connect(btnOK, SIGNAL(clicked()), this, SLOT(close()));
   l->addWidget(btnOK, 0, AlignRight);
}

void KLogViewer::slotRead(const QString &data) 
{
   int l, c;
   mleText->getCursorPosition(&l, &c);
   mleText->insertAt(data, l, c);
}

#include "klogviewer.moc"
