/***************************************************************************
                           kdlgtransferset.h - 
                         ---------------------------
    begin                : Sun Mar  4 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGTRANSFERSET_H
#define KDLGTRANSFERSET_H

#include <qwidget.h>
#include <qlineedit.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include "ktransfer.h"

/**
 * @short Dialog class for @ref KTransfer settings
 * 
 * @author Sergio Moretti
 * 
 * @version $Id: kdlgtransferset.h,v 1.1 2001/03/05 20:59:22 sergio Exp $
 */

class KDlgTransferSet : public QWidget
{
   Q_OBJECT
public:
   KDlgTransferSet(KTransfer t, QWidget *parent, const char *name=0);
   ~KDlgTransferSet();
   bool isAcceptable();
   void accept();
   void reject();

protected:
   void init();
   void initDialog();

protected slots:
#ifdef KDE_VERSION_POST_1207
   void slotOpenFileDialog(KURLRequester *kreq);
#else
   void slotOpenFileDialog(KURLRequester *) {}
#endif
  
private:
   KTransfer t;
   QLineEdit *lneRemote,
      *lneResumed,
      *lneLen,
      *lnePriority;
   KComboBox *cmbResumable;
#ifndef KURLREQ_ERR
   KURLRequester *cmbLocal;
   KURLRequester *cmbTmp;
#else
   QLineEdit *lneLocal;
   QLineEdit *lneTmp;
#endif
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
