/***************************************************************************
                          kdlgdefault.cpp  -  description
                             -------------------
    begin                : Wed Jan 17 2001
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qtooltip.h>
#include "kmagodoc.h"
#include "kdlgdefault.h"
#include "kdlgmanager1.h"
#include "kdlgtransfer1.h"
#ifdef ENABLE_WGET
#include "kdlgtransferwget1.h"
#endif
#ifdef ENABLE_KIO
#include "ktransferkio.h"
#include "kdlgtransferkio1.h"
#endif

KDlgDefault::KDlgDefault(KMagoDoc *doc, QWidget *parent, const char *name ) 
   : KTabCtl(parent, name) 
{
   _doc = doc;
   initDialog();
}

KDlgDefault::~KDlgDefault()
{
}

void KDlgDefault::initDialog() 
{
   KObject obj = _doc->manager().findDefault(TYP_TMANAGER);
   _p1 = new KDlgManager1(obj.toTManager(), this);
   addTab(_p1, i18n("Manager"));
   int minH = _p1->minimumHeight();

#ifdef ENABLE_WGET
   obj = _doc->manager().findDefault(TYP_TWGET);
   _p2 = new KDlgTransfer1(obj.toTransferWget(), this);
   addTab(_p2, i18n("Wget 1"));
   if (_p2->minimumHeight() > minH)
      minH = _p2->minimumHeight();

   _p3 = new KDlgTransferWget1(obj.toTransferWget(), this);
   addTab(_p3, i18n("Wget 2"));
   if (_p3->minimumHeight() > minH)
      minH = _p3->minimumHeight();
#endif

#ifdef ENABLE_KIO
   obj = _doc->manager().findDefault(TYP_TKIO);
   _p4 = new KDlgTransfer1(obj.toTransferKio(), this);
   addTab(_p4, i18n("Kio 1"));
   if (_p4->minimumHeight() > minH)
      minH = _p4->minimumHeight();

   _p5 = new KDlgTransferKio1(obj.toTransferKio(), this);
   addTab(_p5, i18n("Kio 2"));
   if (_p5->minimumHeight() > minH)
      minH = _p5->minimumHeight();
#endif

   kdDebug(D_VIE) << name() << ": minimum Height = " << minH << endl;
   setMinimumHeight(minH);
}

bool KDlgDefault::isAcceptable() const 
{
   if (!_p1->isAcceptable()
#ifdef ENABLE_WGET
       || !_p2->isAcceptable()
       || !_p3->isAcceptable()
#endif
#ifdef ENABLE_KIO
       || !_p4->isAcceptable()
       || !_p5->isAcceptable()
#endif
      )
      return false;
   return true;
}

void KDlgDefault::accept() 
{
   _p1->accept();
#ifdef ENABLE_WGET
   _p2->accept();
   _p3->accept();
   _doc->manager().findDefault(TYP_TWGET).emitMod();
#endif
#ifdef ENABLE_KIO
   _p4->accept();
   _p5->accept();
   _doc->manager().findDefault(TYP_TKIO).emitMod();
#endif
   _doc->manager().findDefault(TYP_TMANAGER).emitMod();
}

void KDlgDefault::reject()
{
   _p1->reject();
#ifdef ENABLE_WGET
   _p2->reject();
   _p3->reject();
   _doc->manager().findDefault(TYP_TWGET).emitMod();
#endif
#ifdef ENABLE_KIO
   _p4->reject();
   _p5->reject();
   _doc->manager().findDefault(TYP_TKIO).emitMod();
#endif
   _doc->manager().findDefault(TYP_TMANAGER).emitMod();
}

#include "kdlgdefault.moc"
