/***************************************************************************
                          utils.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.13 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>
#include <unistd.h>
#include <kdebug.h>
#include <kapp.h>
#include <kuniqueapp.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <math.h>
#include "utils.h"

bool _uniqueApp;
bool _singleDoc;

bool checkFilePermission(const QFileInfo &file)
{
   if (file.permission(QFileInfo::ReadUser | QFileInfo::WriteUser))
      return true;
   // permission error
   KMessageBox::sorry(kapp->mainWidget(),
		      i18n("Wrong permission in file " + file.absFilePath()),
		      i18n("Error in file permission"),
		      false);
   return false;
}

bool checkFileCreation(const QFileInfo &file)
{
   // create file
   QFile f(file.absFilePath());
   if (!f.open(IO_ReadWrite))
   {
      KMessageBox::sorry(kapp->mainWidget(),
			 i18n("Error in creation of file " + file.absFilePath()),
			 i18n("Error in file creation"),
			 false);
      return false;
   }
   f.close();
   return true;
}

bool promptFileOverwrite(const QFileInfo &file)
{
   return KMessageBox::questionYesNo(
      kapp->mainWidget(),
      i18n("File " + file.absFilePath() + " exist, Overwrite it?"),
      i18n("File exist"),
      QString::null, QString::null, false) == KMessageBox::Yes;
}

bool promptFileCreate(const QFileInfo &file)
{
   return KMessageBox::questionYesNo(
      kapp->mainWidget(),
      i18n("File " + file.absFilePath() + " not exist, Create it?"),
      i18n("Create file?"),
      QString::null, QString::null, false) == KMessageBox::Yes;
}

/** mod = ASK_IFNOTEXIST 	-> ask to create if file not exist
	* mod = ASK_IFEXIST 		-> ask to overwrite if file exits
	* mod = DONT_ASK 				-> don't ask
	*/
bool promptFileOpen(const QFileInfo &file, int mod = ASK_IFEXIST)
{
   if (!file.exists() &&
       mod == ASK_IFNOTEXIST &&
       promptFileCreate(file))
      return checkFileCreation(file);

   if (file.exists() &&
       mod == ASK_IFEXIST &&
       promptFileOverwrite(file))
      return checkFilePermission(file);

   return true;
}

/** open a message box with the prompt for the add mode */
int promptStartMode(const QString &caption, const QString &message)
{
   return KMessageBox::warningYesNoCancel(kapp->mainWidget(),
					  message,
					  caption,
					  i18n("Start Now"),
					  i18n("Add to List"),
					  false);
}

/** select which file to recover */
int promptFilesToRecover(const QString &f1, const QString &f2)
{
   int retval;
   retval = KMessageBox::warningYesNoCancel(
      kapp->mainWidget(),
      i18n("Files\n") + f1 + "\n" + f2 + i18n("\nalready existing, do you want to recover?"),
      i18n("Recover File"),
      QString::null, QString::null, false);

   if (retval == KMessageBox::No || retval == KMessageBox::Cancel)
      return retval;

   retval = KMessageBox::warningYesNoCancel(
      kapp->mainWidget(),
      i18n("Select file to recover:\nFile A:") + f1 + i18n("\nFile B:") + f2,
      i18n("Recover File"),
      i18n("File A"),
      i18n("File B"), false);

   if (retval == KMessageBox::Cancel)
      return retval;

   return  retval == KMessageBox::Yes ? KMessageBox::Ok : KMessageBox::Yes;
}

/** prompt to recover file */
int promptFileToRecover(const QString &f)
{
   return KMessageBox::warningYesNoCancel(
      kapp->mainWidget(),
      i18n("File " + f + " exist, do you want to recover it?"),
      i18n("File exist"),
      QString::null, QString::null, false);
}

/** create a tmp filename */
QString tempFile()
{
   //FIXME!!
   char templ[40] = "/tmp/kmagoXXXXXX";
   int fd = mkstemp(templ);
   kdFatal(fd == -1) << ": COULD NOT CREATE TMP FILE" << endl;
   close(fd);
   return QString(templ);
}

/** transform a number of type 100,000 to 100000*/
int parseNumber(const QString& num)
{
   QString tmp = num;
   int p;
   while ((p = tmp.find(',')) != -1)
   {
      tmp.remove(p, 1);
   }
   return tmp.toInt();
}

/** save a file moving it to file.NN */
QString saveFile(const QString &f)
{
   int i = 0;
   QFileInfo tmpfile, file(f);
   do
   {
      i++;
      tmpfile.setFile(file.dir(), QString("%1.%2").arg(file.fileName()).arg(i));
   } while (tmpfile.exists());
   bool check =
      QDir::current().rename(file.absFilePath(), tmpfile.absFilePath());
   if (!check)
   {
      kdError() << "saveFile : error in moving " << file.absFilePath() << " -> " << tmpfile.absFilePath() << endl;
      return QString::null;
   }
   return tmpfile.absFilePath();
}

static QString unitk(float val)
{
   QString str;
   if (val < 10)
      return str.sprintf("%4.2f", val);
   else if (val < 100)
      return str.sprintf("%4.1f", val);
   //else if (val < 1000)
   return str.sprintf("%4.0f", val);
}

QString unit(float val)
{
   float v = fabs(val);
   if (v < 1e3)
      return unitk(val);
   else if (v < 1e6)
      return unitk(val / 1e3) + "K";
   else if (v < 1e9)
      return unitk(val / 1e6) + "M";
   else if (v < 1e12)
      return unitk(val / 1e9) + "G";
   else if (v < 1e15)
      return unitk(val / 1e12) + "T";
   else return "XXXXX";
}

/** copy file source to dest */
bool copyFile(const QString &source, const QString &dest)
{
   QFile s(source), d(dest);
   if (!s.open(IO_ReadOnly))
      return false;
   if (!d.open(IO_WriteOnly | IO_Truncate))
   {
      s.close();
      return false;
   }
   while (!s.atEnd())
   {
      char buf[1024];
      int len = s.readBlock(buf, 1024);
      kdFatal(len == -1) << "READ ERROR IN " << source << endl;
      len = d.writeBlock(buf, len);
      kdFatal(len == -1) << "WRITE ERROR IN " << dest << endl;
   }
   s.close();
   d.close();
   return true;
}

QString encodeFileName(const QString &f)
{
   QString filename = f;
   int p;
   while ((p = filename.find(' ')) != -1)
   {
      filename[p] = '_';
   }
   return filename;
}

bool isUniqueApp()
{
   return _uniqueApp;
}

bool isSingleDoc()
{
   return _singleDoc;
}

/*
uint mem()
{
   QString statfile;
   statfile = QString("/proc/%1/stat").arg(getpid());
   QFile f(statfile);
   f.open(IO_ReadOnly);
   QTextStream s(&f);
   int pid, ppid, pgrp, session, tty, tpgid, utime, stime, cutime, cstime,
      counter, priority, starttime;
   uint flags, minflt, cminflt, majflt, cmajflt, timeout, itrealvalue, vsize,
      rss;
   QString comm;
   char state;

   s >> pid >> comm >> state >> ppid >> pgrp >> session >> tty >> tpgid >> flags
     >> minflt >> cminflt >> majflt >> cmajflt >> utime >> stime >> cutime
     >> cstime >> counter >> priority >> timeout >> itrealvalue >> starttime
     >> vsize >> rss;
   f.close();
   return vsize;
}
*/
